/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.lib.LibBlockNames;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class RecipeDatagen
extends RecipeProvider {
    public static Ingredient SOURCE_GEM = Ingredient.of(ItemTagProvider.SOURCE_GEM_TAG);
    public static Ingredient SOURCE_GEM_BLOCK = Ingredient.of(ItemTagProvider.SOURCE_GEM_BLOCK_TAG);
    public static Ingredient ARCHWOOD_LOG = Ingredient.of(ItemTagProvider.ARCHWOOD_LOG_TAG);
    public static Ingredient WILDEN_DROP = Ingredient.of(ItemTagProvider.WILDEN_DROP_TAG);
    public static Ingredient SUMMON_SHARDS = Ingredient.of(ItemTagProvider.SUMMON_SHARDS_TAG);
    public RecipeOutput consumer;
    private static int STONECUTTER_COUNTER = 0;

    public RecipeDatagen(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput pRecipeOutput) {
        this.consumer = pRecipeOutput;
        Block SOURCESTONE = BlockRegistry.getBlock("sourcestone");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, ItemsRegistry.NOVICE_SPELLBOOK).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).requires((ItemLike)Items.BOOK).requires((ItemLike)Items.IRON_SHOVEL).requires((ItemLike)Items.IRON_PICKAXE).requires((ItemLike)Items.IRON_AXE).requires((ItemLike)Items.IRON_SWORD).save(this.consumer);
        this.shapelessBuilder(ItemsRegistry.STABLE_WARP_SCROLL).requires(ItemsRegistry.STABLE_WARP_SCROLL).save(this.consumer, ArsNouveau.prefix("reset_stable_warp_scroll"));
        this.shapelessBuilder(ItemsRegistry.WARP_SCROLL).requires(ItemsRegistry.WARP_SCROLL).save(this.consumer, ArsNouveau.prefix("reset_warp_scroll"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, ItemsRegistry.WORN_NOTEBOOK).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).requires(Ingredient.of((TagKey)Tags.Items.GEMS_LAPIS), 1).requires((ItemLike)Items.BOOK).save(this.consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, ItemsRegistry.MAGE_FIBER, (int)4).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).requires(ItemsRegistry.MAGE_BLOOM).save(this.consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, ItemsRegistry.RUNIC_CHALK, (int)1).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).requires(ItemsRegistry.MANIPULATION_ESSENCE).requires((ItemLike)Items.BONE_MEAL).requires(ItemsRegistry.MAGE_FIBER).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, BlockRegistry.SOURCE_JAR).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern("yyy").pattern("x x").pattern("yyy").define(Character.valueOf('x'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('y'), BlockRegistry.ARCHWOOD_SLABS).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BlockRegistry.ARCANE_PEDESTAL.get())).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern("xzx").pattern("yxy").pattern("yxy").define(Character.valueOf('x'), (ItemLike)SOURCESTONE).define(Character.valueOf('y'), Tags.Items.NUGGETS_GOLD).define(Character.valueOf('z'), SOURCE_GEM).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, BlockRegistry.ENCHANTING_APP_BLOCK).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern("nsn").pattern("gdg").pattern("nsn").define(Character.valueOf('n'), Tags.Items.NUGGETS_GOLD).define(Character.valueOf('s'), (ItemLike)SOURCESTONE).define(Character.valueOf('d'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ItemsRegistry.MUNDANE_BELT).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern("   ").pattern("xyx").pattern(" x ").define(Character.valueOf('x'), Tags.Items.LEATHERS).define(Character.valueOf('y'), SOURCE_GEM).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ItemsRegistry.RING_OF_POTENTIAL).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), Tags.Items.NUGGETS_IRON).define(Character.valueOf('y'), SOURCE_GEM).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, BlockRegistry.SCRIBES_BLOCK).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern("xxx").pattern("y y").pattern("z z").define(Character.valueOf('x'), Ingredient.of((ItemLike[])new ItemLike[]{BlockRegistry.ARCHWOOD_SLABS})).define(Character.valueOf('y'), Tags.Items.NUGGETS_GOLD).define(Character.valueOf('z'), ARCHWOOD_LOG).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ItemsRegistry.DULL_TRINKET).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern(" x ").pattern("xyx").pattern(" x ").define(Character.valueOf('x'), Tags.Items.NUGGETS_IRON).define(Character.valueOf('y'), SOURCE_GEM).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, BlockRegistry.ARCANE_CORE_BLOCK).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern("xxx").pattern("yzy").pattern("xxx").define(Character.valueOf('y'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('x'), (ItemLike)SOURCESTONE).define(Character.valueOf('z'), SOURCE_GEM).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)SOURCESTONE, (int)8).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('y'), SOURCE_GEM).define(Character.valueOf('x'), Tags.Items.STONES).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)BlockRegistry.IMBUEMENT_BLOCK.asItem(), (int)1).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern("xyx").pattern("x x").pattern("xyx").define(Character.valueOf('x'), BlockRegistry.ARCHWOOD_PLANK).define(Character.valueOf('y'), Tags.Items.INGOTS_GOLD).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ItemsRegistry.BLANK_PARCHMENT, (int)1).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern("yyy").pattern("yxy").pattern("yyy").define(Character.valueOf('x'), (ItemLike)Items.PAPER).define(Character.valueOf('y'), ItemsRegistry.MAGE_FIBER).save(this.consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, ItemsRegistry.ALLOW_ITEM_SCROLL, (int)1).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).requires(ItemsRegistry.BLANK_PARCHMENT, 1).requires(Ingredient.of((TagKey)Tags.Items.CHESTS), 1).save(this.consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, ItemsRegistry.DENY_ITEM_SCROLL, (int)1).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).requires(ItemsRegistry.BLANK_PARCHMENT, 1).requires(Ingredient.of((TagKey)Tags.Items.COBBLESTONES), 1).save(this.consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, ItemsRegistry.WARP_SCROLL).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).requires(Ingredient.of((TagKey)Tags.Items.GEMS_LAPIS), 4).requires(ItemsRegistry.BLANK_PARCHMENT).requires(SOURCE_GEM, 4).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, BlockRegistry.VOLCANIC_BLOCK).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern(" s ").pattern("gig").pattern(" s ").define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('s'), SOURCE_GEM).define(Character.valueOf('i'), (ItemLike)Items.LAVA_BUCKET).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.ARCHWOOD_PLANK, 4).requires(ARCHWOOD_LOG).save(this.consumer);
        RecipeDatagen.makeWood(BlockRegistry.VEXING_LOG, BlockRegistry.VEXING_WOOD, 3).save(this.consumer);
        RecipeDatagen.makeWood(BlockRegistry.CASCADING_LOG, BlockRegistry.CASCADING_WOOD, 3).save(this.consumer);
        RecipeDatagen.makeWood(BlockRegistry.BLAZING_LOG, BlockRegistry.BLAZING_WOOD, 3).save(this.consumer);
        RecipeDatagen.makeWood(BlockRegistry.FLOURISHING_LOG, BlockRegistry.FLOURISHING_WOOD, 3).save(this.consumer);
        RecipeDatagen.shapedWoodenStairs(this.consumer, BlockRegistry.ARCHWOOD_STAIRS, BlockRegistry.ARCHWOOD_PLANK);
        RecipeDatagen.shapelessWoodenButton(this.consumer, BlockRegistry.ARCHWOOD_BUTTON, BlockRegistry.ARCHWOOD_PLANK);
        RecipeDatagen.shapedWoodenDoor(this.consumer, BlockRegistry.ARCHWOOD_DOOR, BlockRegistry.ARCHWOOD_PLANK);
        RecipeDatagen.shapedWoodenFence(this.consumer, BlockRegistry.ARCHWOOD_FENCE, BlockRegistry.ARCHWOOD_PLANK);
        RecipeDatagen.shapedWoodenFenceGate(this.consumer, BlockRegistry.ARCHWOOD_FENCE_GATE, BlockRegistry.ARCHWOOD_PLANK);
        RecipeDatagen.shapedWoodenPressurePlate(this.consumer, BlockRegistry.ARCHWOOD_PPlate, BlockRegistry.ARCHWOOD_PLANK);
        RecipeDatagen.shapedWoodenSlab(this.consumer, BlockRegistry.ARCHWOOD_SLABS, BlockRegistry.ARCHWOOD_PLANK);
        RecipeDatagen.strippedLogToWood(this.consumer, BlockRegistry.STRIPPED_AWLOG_BLUE, BlockRegistry.STRIPPED_AWWOOD_BLUE);
        RecipeDatagen.strippedLogToWood(this.consumer, BlockRegistry.STRIPPED_AWLOG_GREEN, BlockRegistry.STRIPPED_AWWOOD_GREEN);
        RecipeDatagen.strippedLogToWood(this.consumer, BlockRegistry.STRIPPED_AWLOG_RED, BlockRegistry.STRIPPED_AWWOOD_RED);
        RecipeDatagen.strippedLogToWood(this.consumer, BlockRegistry.STRIPPED_AWLOG_PURPLE, BlockRegistry.STRIPPED_AWWOOD_PURPLE);
        RecipeDatagen.shapedWoodenTrapdoor(this.consumer, BlockRegistry.ARCHWOOD_TRAPDOOR, BlockRegistry.ARCHWOOD_PLANK);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, BlockRegistry.SOURCE_GEM_BLOCK, (int)1).pattern("xx").pattern("xx").define(Character.valueOf('x'), SOURCE_GEM).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(this.consumer);
        this.shapelessBuilder(ItemsRegistry.SOURCE_GEM, 4).requires(BlockRegistry.SOURCE_GEM_BLOCK, 1).save(this.consumer, ArsNouveau.prefix("source_gem_block_2"));
        this.shapelessBuilder((ItemLike)Items.LEATHER, 1).requires(ItemsRegistry.WILDEN_WING).save(this.consumer, ArsNouveau.prefix("wing_to_leather"));
        this.shapelessBuilder((ItemLike)Items.BONE_MEAL, 3).requires(ItemsRegistry.WILDEN_HORN).save(this.consumer, ArsNouveau.prefix("horn_to_bonemeal"));
        this.shapelessBuilder((ItemLike)Items.ORANGE_DYE, 5).requires(ItemsRegistry.WILDEN_SPIKE).save(this.consumer, ArsNouveau.prefix("spike_to_dye"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.ARROW, (int)32).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern(" x ").pattern(" y ").pattern(" z ").define(Character.valueOf('x'), ItemsRegistry.WILDEN_SPIKE).define(Character.valueOf('y'), (ItemLike)Items.STICK).define(Character.valueOf('z'), (ItemLike)Items.FEATHER).save(this.consumer, ArsNouveau.prefix("spike_to_arrow"));
        this.shapelessBuilder(BlockRegistry.POTION_JAR).requires(BlockRegistry.SOURCE_JAR).requires(ItemsRegistry.ABJURATION_ESSENCE).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.POTION_JAR).requires(BlockRegistry.POTION_JAR).save(this.consumer, ArsNouveau.prefix("potion_jar_empty"));
        this.shapelessBuilder(BlockRegistry.RITUAL_BLOCK).requires((ItemLike)BlockRegistry.ARCANE_PEDESTAL.get()).requires(SOURCE_GEM_BLOCK).requires(Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), 3).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.GOLD_SCONCE_BLOCK).requires(SOURCE_GEM).requires(Ingredient.of((TagKey)Tags.Items.NUGGETS_GOLD), 2).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.SOURCESTONE_SCONCE_BLOCK).requires(SOURCE_GEM).requires(Ingredient.of((ItemLike[])new ItemLike[]{BlockRegistry.getBlock("sourcestone")}), 2).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.ARCHWOOD_SCONCE_BLOCK).requires(SOURCE_GEM).requires(Ingredient.of((ItemLike[])new ItemLike[]{BlockRegistry.ARCHWOOD_PLANK}), 2).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.POLISHED_SCONCE_BLOCK).requires(BlockRegistry.SOURCESTONE_SCONCE_BLOCK).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.SOURCESTONE_SCONCE_BLOCK).requires(BlockRegistry.POLISHED_SCONCE_BLOCK).save(this.consumer, ArsNouveau.prefix("polished_source_sconce"));
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.MOONFALL)).requires(BlockRegistry.CASCADING_LOG).requires((ItemLike)Items.INK_SAC).requires(Tags.Items.STORAGE_BLOCKS_COAL).requires((ItemLike)Items.CLOCK).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.MOONFALL)).requires(BlockRegistry.CASCADING_LOG).requires(ItemsRegistry.WILDEN_WING).save(this.consumer, ArsNouveau.prefix("moonfall_2"));
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.SUNRISE)).requires(BlockRegistry.BLAZING_LOG).requires((ItemLike)Items.DANDELION, 3).requires((ItemLike)Items.CLOCK).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.SUNRISE)).requires(BlockRegistry.BLAZING_LOG).requires((ItemLike)Items.SUNFLOWER).save(this.consumer, ArsNouveau.prefix("sunrise_2"));
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.DIG)).requires(BlockRegistry.FLOURISHING_LOG).requires((ItemLike)Items.IRON_PICKAXE).requires(Tags.Items.STORAGE_BLOCKS_COAL).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.CLOUDSHAPER)).requires(BlockRegistry.CASCADING_LOG).requires((ItemLike)Items.FEATHER).requires(SOURCE_GEM_BLOCK).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.CHALLENGE)).requires(BlockRegistry.VEXING_LOG).requires((ItemLike)Items.EMERALD_BLOCK).requires((ItemLike)Items.INK_SAC).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.CHALLENGE)).requires(BlockRegistry.VEXING_LOG).requires(ItemsRegistry.WILDEN_HORN).requires((ItemLike)Items.EMERALD).save(this.consumer, ArsNouveau.prefix("challenge_2"));
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.OVERGROWTH)).requires(BlockRegistry.FLOURISHING_LOG).requires(ItemsRegistry.MAGE_BLOOM, 3).requires(ItemsRegistry.EARTH_ESSENCE, 2).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.FERTILITY)).requires(BlockRegistry.FLOURISHING_LOG).requires((ItemLike)Items.WHEAT, 3).requires((ItemLike)Items.GOLDEN_APPLE).requires((ItemLike)Items.BLAZE_POWDER, 2).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.RESTORATION)).requires(BlockRegistry.FLOURISHING_LOG).requires((ItemLike)Items.GOLDEN_APPLE).requires(ItemsRegistry.ABJURATION_ESSENCE, 1).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.DISINTEGRATION)).requires(BlockRegistry.BLAZING_LOG).requires((ItemLike)Items.GOLDEN_SWORD, 3).requires((ItemLike)Items.BOOK, 3).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.WARP)).requires(BlockRegistry.VEXING_LOG).requires(ItemsRegistry.WARP_SCROLL).save(this.consumer);
        this.shapelessBuilder(ItemsRegistry.GREATER_EXPERIENCE_GEM).requires(ItemsRegistry.EXPERIENCE_GEM, 4).save(this.consumer);
        this.shapelessBuilder(ItemsRegistry.EXPERIENCE_GEM, 4).requires(ItemsRegistry.GREATER_EXPERIENCE_GEM).save(this.consumer);
        this.shapelessBuilder(ItemsRegistry.ALLOW_ITEM_SCROLL).requires(ItemsRegistry.ALLOW_ITEM_SCROLL).save(this.consumer, ArsNouveau.prefix("clear_allow"));
        this.shapelessBuilder(ItemsRegistry.DENY_ITEM_SCROLL).requires(ItemsRegistry.DENY_ITEM_SCROLL).save(this.consumer, ArsNouveau.prefix("clear_deny"));
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.SCRYING)).requires(BlockRegistry.VEXING_LOG).requires((ItemLike)Items.SPIDER_EYE, 3).requires((ItemLike)Items.GLOWSTONE).requires(SOURCE_GEM_BLOCK).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.FLIGHT)).requires(BlockRegistry.VEXING_LOG).requires(ItemsRegistry.WILDEN_WING, 3).requires(Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), 2).requires((ItemLike)Items.ENDER_PEARL).save(this.consumer);
        this.shapelessBuilder(ItemsRegistry.MIMIC_ITEM_SCROLL).requires(ItemsRegistry.ALLOW_ITEM_SCROLL).requires((ItemLike)Items.CHEST).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.WILDEN_SUMMON)).requires(BlockRegistry.VEXING_LOG).requires(WILDEN_DROP, 3).requires((ItemLike)Items.LAPIS_BLOCK).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.WILDEN_SUMMON)).requires(BlockRegistry.VEXING_LOG).requires((ItemLike)Items.EMERALD_BLOCK, 1).requires((ItemLike)Items.IRON_SWORD, 1).requires((ItemLike)Items.BOW, 1).requires((ItemLike)Items.LAPIS_BLOCK).save(this.consumer, ArsNouveau.prefix("wilden_summon_alt"));
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.ANIMAL_SUMMON)).requires(BlockRegistry.VEXING_LOG).requires(SUMMON_SHARDS, 3).requires((ItemLike)Items.LAPIS_BLOCK).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.GRAVITY)).requires(BlockRegistry.FLOURISHING_LOG).requires(ItemsRegistry.AIR_ESSENCE).requires(ItemsRegistry.EARTH_ESSENCE).requires((ItemLike)Items.FEATHER).requires((ItemLike)Items.ANVIL).save(this.consumer);
        STONECUTTER_COUNTER = 1;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, BlockRegistry.ALCHEMICAL_BLOCK).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern(" s ").pattern("gig").pattern(" s ").define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('s'), SOURCE_GEM).define(Character.valueOf('i'), (ItemLike)Items.BREWING_STAND).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, BlockRegistry.VITALIC_BLOCK).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern(" s ").pattern("gig").pattern(" s ").define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('s'), SOURCE_GEM).define(Character.valueOf('i'), (ItemLike)Items.GLISTERING_MELON_SLICE).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, BlockRegistry.MYCELIAL_BLOCK).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern(" s ").pattern("gig").pattern(" s ").define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('s'), SOURCE_GEM).define(Character.valueOf('i'), (ItemLike)Items.MUSHROOM_STEW).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, BlockRegistry.AGRONOMIC_SOURCELINK).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern(" s ").pattern("gig").pattern(" s ").define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('s'), SOURCE_GEM).define(Character.valueOf('i'), (ItemLike)Items.WHEAT).save(this.consumer);
        this.shapelessBuilder(ItemsRegistry.SOURCE_BERRY_PIE).requires((ItemLike)Items.EGG).requires((ItemLike)Items.SUGAR).requires(ItemsRegistry.MAGE_BLOOM).requires(BlockRegistry.SOURCEBERRY_BUSH, 3).save(this.consumer);
        this.shapelessBuilder(ItemsRegistry.SOURCE_BERRY_ROLL).requires((ItemLike)Items.WHEAT, 3).requires(BlockRegistry.SOURCEBERRY_BUSH).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, BlockRegistry.RELAY).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern("g g").pattern("gMg").pattern("g g").define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('M'), SOURCE_GEM_BLOCK).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.BINDING)).requires(BlockRegistry.VEXING_LOG).requires(ItemsRegistry.BLANK_PARCHMENT).requires((ItemLike)Items.ENDER_PEARL, 1).requires(SOURCE_GEM, 3).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, BlockRegistry.BASIC_SPELL_TURRET).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern("xxx").pattern("xzy").pattern("yyy").define(Character.valueOf('z'), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_REDSTONE)).define(Character.valueOf('x'), SOURCE_GEM).define(Character.valueOf('y'), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD)).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, BlockRegistry.ARCHWOOD_CHEST).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), BlockRegistry.ARCHWOOD_PLANK).define(Character.valueOf('y'), (ItemLike)Items.GOLD_NUGGET).save(this.consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, BlockRegistry.SPELL_PRISM).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern("gxg").pattern("xnx").pattern("gxg").define(Character.valueOf('x'), BlockRegistry.ARCHWOOD_PLANK).define(Character.valueOf('g'), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD)).define(Character.valueOf('n'), Ingredient.of(ItemTagProvider.STORAGE_BLOCKS_QUARTZ)).save(this.consumer);
        this.shapelessBuilder((ItemLike)Items.CHEST).requires(BlockRegistry.ARCHWOOD_CHEST).save(this.consumer, ArsNouveau.prefix("archwood_to_chest"));
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.AWAKENING)).requires(BlockRegistry.FLOURISHING_LOG).requires(BlockRegistry.BLAZING_SAPLING).requires(BlockRegistry.CASCADING_SAPLING).requires(BlockRegistry.FLOURISHING_SAPLING).requires(BlockRegistry.VEXING_SAPLING).requires(SOURCE_GEM, 4).save(this.consumer);
        this.shapelessBuilder((ItemLike)Items.PINK_DYE, 2).requires(ItemsRegistry.MAGE_BLOOM, 2).save(this.consumer, ArsNouveau.prefix("magebloom_to_pink"));
        this.shapelessBuilder((ItemLike)Items.PURPLE_DYE).requires(BlockRegistry.SOURCEBERRY_BUSH).save(this.consumer, ArsNouveau.prefix("sourceberry_to_purple"));
        this.shapelessBuilder((ItemLike)Items.WATER_BUCKET).requires(ItemsRegistry.WATER_ESSENCE).requires((ItemLike)Items.BUCKET).save(this.consumer, ArsNouveau.prefix("water_essence_to_bucket"));
        this.shapelessBuilder((ItemLike)Items.FIRE_CHARGE, 3).requires(ItemsRegistry.FIRE_ESSENCE).requires((ItemLike)Items.GUNPOWDER).requires((ItemLike)Items.COAL).save(this.consumer, ArsNouveau.prefix("fire_essence_to_charge"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ItemsRegistry.DOWSING_ROD).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern(" x ").pattern("a a").define(Character.valueOf('x'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('a'), BlockRegistry.ARCHWOOD_PLANK).save(this.consumer);
        this.shapelessBuilder(ItemsRegistry.ANNOTATED_CODEX).requires(ItemsRegistry.BLANK_PARCHMENT).requires((ItemLike)Items.LEATHER).save(this.consumer);
        this.shapelessBuilder((ItemLike)Items.POWDER_SNOW_BUCKET).requires(ItemsRegistry.AIR_ESSENCE).requires((ItemLike)Items.BUCKET).requires((ItemLike)Items.SNOW_BLOCK).save(this.consumer, ArsNouveau.prefix("air_essence_to_snow_bucket"));
        this.shapedBuilder((ItemLike)Items.SOUL_SAND, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), Tags.Items.SANDS).define(Character.valueOf('y'), ItemsRegistry.CONJURATION_ESSENCE).save(this.consumer, ArsNouveau.prefix("conjuration_essence_to_soul_sand"));
        this.shapedBuilder((ItemLike)Items.END_STONE, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), Tags.Items.STONES).define(Character.valueOf('y'), ItemsRegistry.CONJURATION_ESSENCE).save(this.consumer, ArsNouveau.prefix("conjuration_essence_to_end_stone"));
        this.shapelessBuilder((ItemLike)Items.OBSIDIAN).requires((ItemLike)Items.LAVA_BUCKET).requires(ItemsRegistry.WATER_ESSENCE).save(this.consumer, ArsNouveau.prefix("water_essence_to_obsidian"));
        this.shapedBuilder((ItemLike)Items.MAGMA_BLOCK, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), Tags.Items.STONES).define(Character.valueOf('y'), ItemsRegistry.FIRE_ESSENCE).save(this.consumer, ArsNouveau.prefix("fire_essence_to_magma_block"));
        this.shapedBuilder((ItemLike)Items.GRANITE, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), (ItemLike)Items.DIORITE).define(Character.valueOf('y'), ItemsRegistry.MANIPULATION_ESSENCE).save(this.consumer, ArsNouveau.prefix("manipulation_essence_to_granite"));
        this.shapedBuilder((ItemLike)Items.ANDESITE, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), (ItemLike)Items.GRANITE).define(Character.valueOf('y'), ItemsRegistry.MANIPULATION_ESSENCE).save(this.consumer, ArsNouveau.prefix("manipulation_essence_to_andesite"));
        this.shapedBuilder((ItemLike)Items.DIORITE, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), (ItemLike)Items.ANDESITE).define(Character.valueOf('y'), ItemsRegistry.MANIPULATION_ESSENCE).save(this.consumer, ArsNouveau.prefix("manipulation_essence_to_diorite"));
        this.shapedBuilder((ItemLike)Items.MYCELIUM, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), (ItemLike)Items.GRASS_BLOCK).define(Character.valueOf('y'), ItemsRegistry.MANIPULATION_ESSENCE).save(this.consumer, ArsNouveau.prefix("manipulation_essence_to_mycelium"));
        this.shapedBuilder((ItemLike)Items.MOSS_BLOCK, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), (ItemLike)Items.MYCELIUM).define(Character.valueOf('y'), ItemsRegistry.MANIPULATION_ESSENCE).save(this.consumer, ArsNouveau.prefix("manipulation_essence_to_moss_block"));
        this.shapedBuilder((ItemLike)Items.GRASS_BLOCK, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), (ItemLike)Items.MOSS_BLOCK).define(Character.valueOf('y'), ItemsRegistry.MANIPULATION_ESSENCE).save(this.consumer, ArsNouveau.prefix("manipulation_essence_to_grass_block"));
        this.shapedBuilder((ItemLike)Items.TUFF, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), (ItemLike)Items.DEEPSLATE).define(Character.valueOf('y'), ItemsRegistry.MANIPULATION_ESSENCE).save(this.consumer, ArsNouveau.prefix("manipulation_essence_to_tuff"));
        this.shapedBuilder((ItemLike)Items.CALCITE, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), (ItemLike)Items.TUFF).define(Character.valueOf('y'), ItemsRegistry.MANIPULATION_ESSENCE).save(this.consumer, ArsNouveau.prefix("manipulation_essence_to_calcite"));
        this.shapedBuilder((ItemLike)Items.DEEPSLATE, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), (ItemLike)Items.CALCITE).define(Character.valueOf('y'), ItemsRegistry.MANIPULATION_ESSENCE).save(this.consumer, ArsNouveau.prefix("manipulation_essence_to_deepslate"));
        this.shapelessBuilder(BlockRegistry.CASCADING_SAPLING).requires(ItemsRegistry.MANIPULATION_ESSENCE).requires(BlockRegistry.BLAZING_SAPLING).save(this.consumer, ArsNouveau.prefix("manipulation_essence_to_cascading_sapling"));
        this.shapelessBuilder(BlockRegistry.FLOURISHING_SAPLING).requires(ItemsRegistry.MANIPULATION_ESSENCE).requires(BlockRegistry.CASCADING_SAPLING).save(this.consumer, ArsNouveau.prefix("manipulation_essence_to_flourishing_sapling"));
        this.shapelessBuilder(BlockRegistry.VEXING_SAPLING).requires(ItemsRegistry.MANIPULATION_ESSENCE).requires(BlockRegistry.FLOURISHING_SAPLING).save(this.consumer, ArsNouveau.prefix("manipulation_essence_to_vexing_sapling"));
        this.shapelessBuilder(BlockRegistry.BLAZING_SAPLING).requires(ItemsRegistry.MANIPULATION_ESSENCE).requires(BlockRegistry.VEXING_SAPLING).save(this.consumer, ArsNouveau.prefix("manipulation_essence_to_blazin_sapling"));
        this.shapedBuilder(BlockRegistry.ORANGE_SBED).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), ItemsRegistry.MAGE_FIBER).define(Character.valueOf('y'), (ItemLike)Items.FEATHER).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.RED_SBED).requires(ItemTagProvider.SUMMON_BED_ITEMS).requires(Tags.Items.DYES_RED).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.GREEN_SBED).requires(ItemTagProvider.SUMMON_BED_ITEMS).requires(Tags.Items.DYES_GREEN).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.BLUE_SBED).requires(ItemTagProvider.SUMMON_BED_ITEMS).requires(Tags.Items.DYES_BLUE).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.PURPLE_SBED).requires(ItemTagProvider.SUMMON_BED_ITEMS).requires(Tags.Items.DYES_PURPLE).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.YELLOW_SBED).requires(ItemTagProvider.SUMMON_BED_ITEMS).requires(Tags.Items.DYES_YELLOW).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.SCRYERS_CRYSTAL).requires((ItemLike)Items.ENDER_EYE).requires(SOURCE_GEM).save(this.consumer);
        this.shapelessBuilder(ItemsRegistry.BLANK_PARCHMENT).requires(ItemsRegistry.SCRYER_SCROLL).save(this.consumer, ArsNouveau.prefix("scry_to_blank_parchment"));
        this.shapelessBuilder(ItemsRegistry.BLANK_PARCHMENT).requires(ItemsRegistry.SPELL_PARCHMENT).save(this.consumer, ArsNouveau.prefix("wipe_spell_parchment"));
        this.shapedBuilder(ItemsRegistry.STARBUNCLE_SHADES).pattern("xyx").define(Character.valueOf('x'), (ItemLike)Items.TINTED_GLASS).define(Character.valueOf('y'), ItemsRegistry.SOURCE_GEM).save(this.consumer);
        for (String s : LibBlockNames.DECORATIVE_SOURCESTONE) {
            if (s.equals("sourcestone")) continue;
            RecipeDatagen.makeStonecutter(this.consumer, (ItemLike)BlockRegistry.getBlock("sourcestone"), (ItemLike)BlockRegistry.getBlock(s), "sourcestone");
            this.shapelessBuilder((ItemLike)SOURCESTONE).requires((ItemLike)BlockRegistry.getBlock(s)).save(this.consumer, ArsNouveau.prefix(s + "_to_sourcestone"));
            Block stair = (Block)BuiltInRegistries.BLOCK.get(ArsNouveau.prefix(s + "_stairs"));
            Block slab = (Block)BuiltInRegistries.BLOCK.get(ArsNouveau.prefix(s + "_slab"));
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BlockRegistry.getBlock(s)}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stair).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(this.consumer, ArsNouveau.prefix(s + "_stonecutter_stair"));
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BlockRegistry.getBlock(s)}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (int)2).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(this.consumer, ArsNouveau.prefix(s + "_stone_cutterslab"));
            RecipeDatagen.shapedWoodenStairs(this.consumer, (ItemLike)stair, (ItemLike)BlockRegistry.getBlock(s), s + "_stairs");
            RecipeDatagen.shapedWoodenSlab(this.consumer, (ItemLike)slab, (ItemLike)BlockRegistry.getBlock(s), s + "_slab");
        }
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.HARVEST)).requires(BlockRegistry.FLOURISHING_LOG).requires(ItemsRegistry.EARTH_ESSENCE).requires((ItemLike)Items.IRON_HOE).save(this.consumer);
        this.shapedBuilder(ItemsRegistry.WIXIE_HAT).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), ItemsRegistry.MAGE_FIBER).define(Character.valueOf('y'), Tags.Items.INGOTS_GOLD).save(this.consumer);
        this.shapedBuilder((ItemLike)ItemsRegistry.BLANK_THREAD, 1).pattern("xxx").pattern("yyy").pattern("xxx").define(Character.valueOf('x'), ItemsRegistry.MAGE_FIBER).define(Character.valueOf('y'), Tags.Items.NUGGETS_GOLD).save(this.consumer);
        this.shapedBuilder(BlockRegistry.ALTERATION_TABLE).pattern(" x ").pattern("xyx").pattern(" x ").define(Character.valueOf('x'), ItemsRegistry.MAGE_FIBER).define(Character.valueOf('y'), BlockRegistry.SCRIBES_BLOCK).save(this.consumer);
        this.shapedBuilder(BlockRegistry.MOB_JAR).pattern("yyy").pattern("x x").pattern("xxx").define(Character.valueOf('y'), BlockRegistry.ARCHWOOD_SLABS).define(Character.valueOf('x'), Ingredient.of((TagKey)Tags.Items.GLASS_BLOCKS)).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.CONTAINMENT)).requires(BlockRegistry.VEXING_LOG).requires(ItemsRegistry.MANIPULATION_ESSENCE).requires((ItemLike)Items.GLASS_BOTTLE, 3).save(this.consumer);
        this.shapedBuilder(BlockRegistry.VOID_PRISM).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('y'), BlockRegistry.SPELL_PRISM).define(Character.valueOf('x'), Ingredient.of((TagKey)Tags.Items.OBSIDIANS)).save(this.consumer);
        this.shapedBuilder(BlockRegistry.MAGEBLOOM_BLOCK).pattern("xx ").pattern("xx ").define(Character.valueOf('x'), ItemsRegistry.MAGE_FIBER).save(this.consumer);
        this.shapelessBuilder(ItemsRegistry.MAGE_FIBER, 4).requires(BlockRegistry.MAGEBLOOM_BLOCK).save(this.consumer, ArsNouveau.prefix("magebloom_block_to_magebloom"));
        this.shapedBuilder(BlockRegistry.FALSE_WEAVE, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), BlockRegistry.MAGEBLOOM_BLOCK).define(Character.valueOf('y'), ItemsRegistry.AIR_ESSENCE).save(this.consumer);
        this.shapedBuilder(BlockRegistry.GHOST_WEAVE, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), BlockRegistry.MAGEBLOOM_BLOCK).define(Character.valueOf('y'), ItemsRegistry.ABJURATION_ESSENCE).save(this.consumer);
        this.shapedBuilder(BlockRegistry.MIRROR_WEAVE, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), BlockRegistry.MAGEBLOOM_BLOCK).define(Character.valueOf('y'), ItemsRegistry.CONJURATION_ESSENCE).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.PLAINS)).requires(BlockRegistry.FLOURISHING_LOG).requires((ItemLike)Blocks.GRASS_BLOCK).requires(ItemsRegistry.EARTH_ESSENCE).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.FORESTATION)).requires(BlockRegistry.FLOURISHING_LOG).requires(BlockRegistry.MENDOSTEEN_POD).requires(ItemsRegistry.EARTH_ESSENCE).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.FLOWERING)).requires(BlockRegistry.FLOURISHING_LOG).requires((ItemLike)Items.POPPY, 3).requires((ItemLike)Items.DANDELION, 3).requires(ItemsRegistry.EARTH_ESSENCE).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.DESERT)).requires(BlockRegistry.BLAZING_LOG).requires((ItemLike)Blocks.SAND).requires(ItemsRegistry.EARTH_ESSENCE).save(this.consumer);
        this.shapedBuilder(BlockRegistry.MAGELIGHT_TORCH, 1).pattern("   ").pattern("xyx").pattern(" x ").define(Character.valueOf('x'), Tags.Items.NUGGETS_GOLD).define(Character.valueOf('y'), SOURCE_GEM).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.ARCANE_PLATFORM).requires(BlockRegistry.ARCANE_PEDESTAL).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.ARCANE_PEDESTAL).requires(BlockRegistry.ARCANE_PLATFORM).save(this.consumer, ArsNouveau.prefix("platform_to_pedestal"));
        this.shapedBuilder(BlockRegistry.SKY_WEAVE, 8).pattern("xxx").pattern("xyx").pattern("xxx").define(Character.valueOf('x'), BlockRegistry.MAGEBLOOM_BLOCK).define(Character.valueOf('y'), ItemsRegistry.MANIPULATION_ESSENCE).save(this.consumer);
        this.shapedBuilder(BlockRegistry.ITEM_DETECTOR).pattern("xxx").pattern("xyx").pattern("zzz").define(Character.valueOf('x'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('y'), (ItemLike)Blocks.OBSERVER).define(Character.valueOf('z'), BlockRegistry.ARCHWOOD_PLANK).save(this.consumer);
        this.shapedBuilder(BlockRegistry.REPOSITORY).pattern("yxy").pattern("x x").pattern("yxy").define(Character.valueOf('x'), ARCHWOOD_LOG).define(Character.valueOf('y'), Tags.Items.NUGGETS_GOLD).save(this.consumer);
        this.shapelessBuilder((ItemLike)RecipeDatagen.getRitualItem(RitualLib.SANCTUARY)).requires(BlockRegistry.CASCADING_LOG).requires(ItemsRegistry.WATER_ESSENCE).requires((ItemLike)Items.SEA_LANTERN).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.ROTATING_TURRET).requires(BlockRegistry.BASIC_SPELL_TURRET).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.BASIC_SPELL_TURRET).requires(BlockRegistry.ROTATING_TURRET).save(this.consumer, ArsNouveau.prefix("rotating_turret_to_basic_spell_turret"));
        this.shapelessBuilder(ItemsRegistry.STARBUNCLE_SHARD).requires(ItemsRegistry.STARBUNCLE_SHARD).save(this.consumer, ArsNouveau.prefix("wipe_starby_shard"));
        this.shapedBuilder(BlockRegistry.REDSTONE_RELAY).pattern("gxg").pattern("gMg").pattern("gxg").define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('M'), SOURCE_GEM_BLOCK).define(Character.valueOf('x'), Tags.Items.DUSTS_REDSTONE).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.SOURCEBERRY_SACK).requires(BlockRegistry.SOURCEBERRY_BUSH, 9).save(this.consumer);
        this.shapelessBuilder(BlockRegistry.SOURCEBERRY_BUSH, 9).requires(BlockRegistry.SOURCEBERRY_SACK).save(this.consumer, ArsNouveau.prefix("sourceberry_sack_to_bush"));
    }

    public static RitualTablet getRitualItem(String name) {
        return RitualRegistry.getRitualItemMap().get(ArsNouveau.prefix(name));
    }

    public ShapedRecipeBuilder shapedBuilder(ItemLike item) {
        return this.shapedBuilder(item, 1);
    }

    public ShapedRecipeBuilder shapedBuilder(ItemLike result, int count) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)count).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK}));
    }

    public static ShapedRecipeBuilder makeWood(ItemLike logs, ItemLike wood, int count) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)wood, (int)count).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).pattern("xx ").pattern("xx ").define(Character.valueOf('x'), logs);
    }

    private static void shapedWoodenTrapdoor(RecipeOutput recipeConsumer, ItemLike trapdoor, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)trapdoor, (int)2).define(Character.valueOf('#'), input).pattern("###").pattern("###").group("wooden_trapdoor").unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(recipeConsumer);
    }

    public static void shapedWoodenStairs(RecipeOutput recipeConsumer, ItemLike stairs, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)stairs, (int)4).define(Character.valueOf('#'), input).pattern("#  ").pattern("## ").pattern("###").unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(recipeConsumer);
    }

    public static void shapedWoodenStairs(RecipeOutput recipeConsumer, ItemLike stairs, ItemLike input, String name) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)stairs, (int)4).define(Character.valueOf('#'), input).pattern("#  ").pattern("## ").pattern("###").unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(recipeConsumer, ArsNouveau.prefix(name));
    }

    private static void shapelessWoodenButton(RecipeOutput recipeConsumer, ItemLike button, ItemLike input) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)button).requires(input).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(recipeConsumer);
    }

    private static void strippedLogToWood(RecipeOutput recipeConsumer, ItemLike stripped, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)3).define(Character.valueOf('#'), stripped).pattern("##").pattern("##").group("bark").unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(recipeConsumer);
    }

    private static void shapedWoodenDoor(RecipeOutput recipeConsumer, ItemLike door, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)door, (int)3).define(Character.valueOf('#'), input).pattern("##").pattern("##").pattern("##").group("wooden_door").unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(recipeConsumer);
    }

    private static void shapedWoodenFence(RecipeOutput recipeConsumer, ItemLike fence, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)fence, (int)3).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('W'), input).pattern("W#W").pattern("W#W").group("wooden_fence").unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(recipeConsumer);
    }

    private static void shapedWoodenFenceGate(RecipeOutput recipeConsumer, ItemLike fenceGate, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)fenceGate).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('W'), input).pattern("#W#").pattern("#W#").group("wooden_fence_gate").unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(recipeConsumer);
    }

    private static void shapedWoodenPressurePlate(RecipeOutput recipeConsumer, ItemLike pressurePlate, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)pressurePlate).define(Character.valueOf('#'), input).pattern("##").group("wooden_pressure_plate").unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(recipeConsumer);
    }

    private static void shapedWoodenSlab(RecipeOutput recipeConsumer, ItemLike slab, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (int)6).define(Character.valueOf('#'), input).pattern("###").group("wooden_slab").unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(recipeConsumer);
    }

    private static void shapedWoodenSlab(RecipeOutput recipeConsumer, ItemLike slab, ItemLike input, String name) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (int)6).define(Character.valueOf('#'), input).pattern("###").group("wooden_slab").unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(recipeConsumer, ArsNouveau.prefix(name));
    }

    public ShapelessRecipeBuilder shapelessBuilder(ItemLike result) {
        return this.shapelessBuilder(result, 1);
    }

    public ShapelessRecipeBuilder shapelessBuilder(ItemLike result, int resultCount) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)resultCount).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK}));
    }

    public static void makeStonecutter(RecipeOutput consumer, ItemLike input, ItemLike output, String reg) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(consumer, ArsNouveau.prefix(reg + "_" + STONECUTTER_COUNTER));
        ++STONECUTTER_COUNTER;
    }
}

