/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.registry.BuddingConversionRegistry;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.api.util.SummonUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.compat.PatchouliHandler;
import com.hollingsworth.arsnouveau.common.crafting.recipes.BuddingConversionRecipe;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.entity.goal.GoBackHomeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.amethyst_golem.ConvertBuddingGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.amethyst_golem.DepositAmethystGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.amethyst_golem.GrowClusterGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.amethyst_golem.HarvestClusterGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.amethyst_golem.PickupAmethystGoal;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathingStuckHandler;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AmethystGolem
extends PathfinderMob
implements GeoEntity,
IDispellable,
ITooltipProvider,
IWandable {
    public static final EntityDataAccessor<Optional<BlockPos>> HOME = SynchedEntityData.defineId(AmethystGolem.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    public static final EntityDataAccessor<Boolean> IMBUEING = SynchedEntityData.defineId(AmethystGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> STOMPING = SynchedEntityData.defineId(AmethystGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<BlockPos> IMBUE_POS = SynchedEntityData.defineId(AmethystGolem.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public final List<BuddingConversionRecipe> recipes = BuddingConversionRegistry.getRecipes();
    public int growCooldown;
    public int convertCooldown;
    public int pickupCooldown;
    public int harvestCooldown;
    public List<BlockPos> buddingBlocks = new ArrayList<BlockPos>();
    public List<BlockPos> amethystBlocks = new ArrayList<BlockPos>();
    public int scanCooldown;
    public MinecoloniesAdvancedPathNavigate pathNavigate;
    public PathNavigation minecraftPathNav;
    public AmethystGolemGoalState goalState;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AmethystGolem(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
    }

    public MinecoloniesAdvancedPathNavigate getNavigation() {
        if (this.pathNavigate == null) {
            this.pathNavigate = new MinecoloniesAdvancedPathNavigate((Mob)this, this.level);
            this.minecraftPathNav = this.navigation;
            this.navigation = this.pathNavigate;
            this.pathNavigate.setCanFloat(true);
            this.pathNavigate.setSwimSpeedFactor(2.0);
            this.pathNavigate.getPathingOptions().setEnterDoors(true);
            this.pathNavigate.getPathingOptions().setCanOpenDoors(true);
            this.pathNavigate.setStuckHandler(PathingStuckHandler.createStuckHandler());
        }
        return this.pathNavigate;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new GoBackHomeGoal((Mob)this, this::getHome, 10, () -> true));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new ConvertBuddingGoal(this, () -> this.convertCooldown <= 0 && this.getHome() != null && this.getHeldStack().isEmpty()));
        this.goalSelector.addGoal(4, (Goal)new GrowClusterGoal(this, () -> this.growCooldown <= 0 && this.getHome() != null && this.getHeldStack().isEmpty()));
        this.goalSelector.addGoal(5, (Goal)new HarvestClusterGoal(this, () -> this.harvestCooldown <= 0 && this.getHome() != null && !this.isImbueing() && this.getHeldStack().isEmpty()));
        this.goalSelector.addGoal(2, (Goal)new PickupAmethystGoal(this, () -> this.getHome() != null && this.pickupCooldown <= 0));
        this.goalSelector.addGoal(2, (Goal)new DepositAmethystGoal(this, () -> this.getHome() != null && !this.getHeldStack().isEmpty()));
    }

    public void tick() {
        super.tick();
        SummonUtil.healOverTime((LivingEntity)this);
        if (this.harvestCooldown > 0) {
            --this.harvestCooldown;
        }
        if (this.growCooldown > 0) {
            --this.growCooldown;
        }
        if (this.convertCooldown > 0) {
            --this.convertCooldown;
        }
        if (this.scanCooldown > 0) {
            --this.scanCooldown;
        }
        if (this.pickupCooldown > 0) {
            --this.pickupCooldown;
        }
        if (!this.level.isClientSide && this.scanCooldown == 0 && this.getHome() != null) {
            this.scanCooldown = 3600;
            this.scanBlocks();
        }
        if (this.level.isClientSide && this.isImbueing() && this.getImbuePos() != null) {
            Vec3 vec = new Vec3((double)this.getImbuePos().getX() + 0.5, (double)this.getImbuePos().getY(), (double)this.getImbuePos().getZ() + 0.5);
            this.level.addParticle(GlowParticleData.createData(new ParticleColor(255, 50, 150)), (double)((float)vec.x) - Math.sin((double)ClientInfo.ticksInGame / 8.0), (double)((float)vec.y) + Math.sin((double)ClientInfo.ticksInGame / 5.0) / 8.0 + 0.5, (double)((float)vec.z) - Math.cos((double)ClientInfo.ticksInGame / 8.0), 0.0, 0.0, 0.0);
        }
    }

    public void setHeldStack(ItemStack stack) {
        this.setItemSlot(EquipmentSlot.MAINHAND, stack);
    }

    public ItemStack getHeldStack() {
        return this.getMainHandItem();
    }

    public boolean isStomping() {
        return (Boolean)this.entityData.get(STOMPING);
    }

    public void setStomping(boolean imbueing) {
        this.entityData.set(STOMPING, (Object)imbueing);
    }

    public boolean isImbueing() {
        return (Boolean)this.entityData.get(IMBUEING);
    }

    public void setImbueing(boolean imbueing) {
        this.entityData.set(IMBUEING, (Object)imbueing);
    }

    public BlockPos getImbuePos() {
        return (BlockPos)this.entityData.get(IMBUE_POS);
    }

    public void setImbuePos(BlockPos pos) {
        this.entityData.set(IMBUE_POS, (Object)pos);
    }

    public void scanBlocks() {
        BlockPos pos = this.getHome().immutable();
        this.amethystBlocks = new ArrayList<BlockPos>();
        this.buddingBlocks = new ArrayList<BlockPos>();
        for (BlockPos b : BlockPos.betweenClosed((BlockPos)pos.below(3).south(5).east(5), (BlockPos)pos.above(10).north(5).west(5))) {
            BlockState bs = this.level.getBlockState(b);
            if (bs.isAir()) continue;
            for (BuddingConversionRecipe recipe : this.recipes) {
                if (!recipe.matches(bs)) continue;
                this.amethystBlocks.add(b.immutable());
                break;
            }
            if (!bs.is(BlockTagProvider.BUDDING_BLOCKS)) continue;
            this.buddingBlocks.add(b.immutable());
        }
    }

    protected void playStepSound(BlockPos pPos, BlockState pBlock) {
        SoundEvent soundtype = SoundEvents.AMETHYST_CLUSTER_STEP;
        this.playSound(soundtype, (float)(Math.random() * (double)0.45f), (float)(Math.random() * 1.0));
    }

    @Override
    public void onFinishedConnectionFirst(@javax.annotation.Nullable BlockPos storedPos, @javax.annotation.Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos != null) {
            this.setHome(storedPos);
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.home_set"));
        }
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.getHome() != null) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.gathering_at", (Object[])new Object[]{this.getHome().toShortString()}));
        }
    }

    public void die(DamageSource source) {
        if (!this.level.isClientSide) {
            ItemStack stack = new ItemStack((ItemLike)ItemsRegistry.AMETHYST_GOLEM_CHARM.get());
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), stack));
            if (this.getHeldStack() != null) {
                this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), this.getHeldStack()));
            }
        }
        super.die(source);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return SummonUtil.canSummonTakeDamage(pSource) && super.hurt(pSource, pAmount);
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.isRemoved()) {
            return false;
        }
        if (!this.level.isClientSide) {
            ItemStack stack = new ItemStack((ItemLike)ItemsRegistry.AMETHYST_GOLEM_CHARM.get());
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), stack.copy()));
            stack = this.getHeldStack();
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), stack));
            ParticleUtil.spawnPoof((ServerLevel)this.level, this.blockPosition());
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return true;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        NBTUtil.storeBlockPos(tag, "home", this.getHome());
        tag.putInt("grow", this.growCooldown);
        tag.putInt("convert", this.convertCooldown);
        tag.putInt("harvest", this.harvestCooldown);
        tag.putInt("pickup", this.pickupCooldown);
        if (this.getHeldStack() != null && !this.getHeldStack().isEmpty()) {
            Tag itemTag = this.getHeldStack().save((HolderLookup.Provider)this.level.registryAccess());
            tag.put("held", itemTag);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (NBTUtil.hasBlockPos(tag, "home")) {
            this.setHome(NBTUtil.getBlockPos(tag, "home"));
        }
        this.growCooldown = tag.getInt("grow");
        this.convertCooldown = tag.getInt("convert");
        this.harvestCooldown = tag.getInt("harvest");
        this.pickupCooldown = tag.getInt("pickup");
        this.setHeldStack(ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)tag.getCompound("held")));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "run_controller", 1, e -> {
            AnimationController controller = e.getController();
            if (this.isStomping()) {
                controller.setAnimation(RawAnimation.begin().thenPlay("harvest2"));
                return PlayState.CONTINUE;
            }
            if (this.isImbueing() || this.level.isClientSide && PatchouliHandler.isPatchouliWorld()) {
                controller.setAnimation(RawAnimation.begin().thenPlay("tending_master"));
                return PlayState.CONTINUE;
            }
            if (e.isMoving()) {
                String anim = this.getHeldStack().isEmpty() ? "run" : "run_carry";
                controller.setAnimation(RawAnimation.begin().thenPlay(anim));
                return PlayState.CONTINUE;
            }
            if (!this.getHeldStack().isEmpty()) {
                controller.setAnimation(RawAnimation.begin().thenPlay("carry_idle"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        data.add(new AnimationController((GeoAnimatable)this, "attack_controller", 5, e -> PlayState.CONTINUE));
    }

    public void setHome(BlockPos home) {
        this.entityData.set(HOME, Optional.of(home));
    }

    @Nullable
    public BlockPos getHome() {
        return ((Optional)this.entityData.get(HOME)).orElse(null);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(HOME, Optional.empty());
        pBuilder.define(IMBUEING, (Object)false);
        pBuilder.define(IMBUE_POS, (Object)BlockPos.ZERO);
        pBuilder.define(STOMPING, (Object)false);
    }

    public boolean removeWhenFarAway(double p_213397_1_) {
        return false;
    }

    protected int getBaseExperienceReward() {
        return 0;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    public static enum AmethystGolemGoalState {
        NONE,
        CONVERT,
        GROW,
        HARVEST,
        PICKUP,
        DEPOSIT;

    }
}

