/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.common.entity.EnchantedFallingBlock;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class Cinder
extends EnchantedFallingBlock {
    public LivingEntity shooter;

    public Cinder(EntityType<? extends Cinder> type, Level worldIn) {
        super(type, worldIn);
    }

    public Cinder(Level worldIn, double x, double y, double z, BlockState fallingBlockState, SpellResolver resolver) {
        super((EntityType<? extends ColoredProjectile>)((EntityType)ModEntities.CINDER.get()), worldIn, x, y, z, fallingBlockState, resolver);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), ParticleUtil.inRange(-0.05f, 0.05f), ParticleUtil.inRange(0.01f, 0.05f), ParticleUtil.inRange(-0.05f, 0.05f));
        }
    }

    @Override
    public void callOnBrokenAfterFall(Block p_149651_, BlockPos p_149652_) {
        super.callOnBrokenAfterFall(p_149651_, p_149652_);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            world.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.position.x, this.position.y + 0.5, this.position.z, 10, 0.0, ParticleUtil.inRange(-0.1, 0.1), 0.0, 0.03);
            world.playSound(null, BlockPos.containing((Position)this.position), SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 0.05f, 0.8f);
        }
    }

    @Override
    public void doPostHurtEffects(LivingEntity livingentity) {
        super.doPostHurtEffects(livingentity);
    }

    @Override
    protected boolean canHitEntity(@NotNull Entity entity) {
        return super.canHitEntity(entity) || entity.getType().is(EntityTags.SPELL_CAN_HIT);
    }

    @Override
    @NotNull
    public EntityType<?> getType() {
        return (EntityType)ModEntities.CINDER.get();
    }
}

