/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.tile.MageBlockTile;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.common.entity.EnchantedMageblock;
import com.hollingsworth.arsnouveau.common.entity.EnchantedSkull;
import com.hollingsworth.arsnouveau.common.event.timed.IRewindable;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.spell.rewind.BlockToEntityRewind;
import com.hollingsworth.arsnouveau.common.spell.rewind.EntityToBlockRewind;
import com.hollingsworth.arsnouveau.common.spell.rewind.RewindAttachment;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EnchantedFallingBlock
extends ColoredProjectile
implements GeoEntity {
    public BlockState blockState = Blocks.SAND.defaultBlockState();
    public int time;
    public boolean dropItem = true;
    public boolean cancelDrop;
    public boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    public int knockback = 2;
    @Nullable
    public CompoundTag blockData;
    public SpellContext context;
    public float baseDamage;
    public SpellResolver resolver;
    public SpellStats spellStats;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.defineId(EnchantedFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private IntOpenHashSet piercingIgnoreEntityIds = new IntOpenHashSet(5);

    public EnchantedFallingBlock(EntityType<? extends ColoredProjectile> p_31950_, Level p_31951_) {
        super(p_31950_, p_31951_);
        this.blocksBuilding = true;
    }

    protected EnchantedFallingBlock(EntityType<? extends ColoredProjectile> p_31950_, Level p_31951_, double p_31952_, double p_31953_, double p_31954_) {
        this(p_31950_, p_31951_);
        this.setPos(p_31952_, p_31953_, p_31954_);
        this.blocksBuilding = true;
    }

    public EnchantedFallingBlock(EntityType<? extends ColoredProjectile> p_31950_, Level world, double v, double y, double v1, BlockState blockState, SpellResolver resolver) {
        this(p_31950_, world);
        this.blockState = blockState;
        this.blocksBuilding = true;
        this.setPos(v, y, v1);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = v;
        this.yo = y;
        this.zo = v1;
        this.setStartPos(this.blockPosition());
        this.resolver = resolver;
    }

    public EnchantedFallingBlock(Level world, double v, double y, double v1, BlockState blockState, SpellResolver resolver) {
        this((EntityType<? extends ColoredProjectile>)((EntityType)ModEntities.ENCHANTED_FALLING_BLOCK.get()), world, v, y, v1, blockState, resolver);
    }

    public EnchantedFallingBlock(Level world, BlockPos pos, BlockState blockState, SpellResolver resolver) {
        this(world, pos.getX(), pos.getY(), pos.getZ(), blockState, resolver);
    }

    @Deprecated(forRemoval=true)
    public EnchantedFallingBlock(Level world, double v, double y, double v1, BlockState blockState) {
        this((EntityType<? extends ColoredProjectile>)((EntityType)ModEntities.ENCHANTED_FALLING_BLOCK.get()), world, v, y, v1, blockState, null);
    }

    @Deprecated(forRemoval=true)
    public EnchantedFallingBlock(Level world, BlockPos pos, BlockState blockState) {
        this(world, pos.getX(), pos.getY(), pos.getZ(), blockState, null);
    }

    public static boolean canFall(Level level, BlockPos pos, Entity owner, SpellStats spellStats) {
        if (level.isEmptyBlock(pos) || !level.getFluidState(pos).isEmpty() || level.getBlockState(pos).is(BlockTagProvider.RELOCATION_NOT_SUPPORTED) || level.getBlockEntity(pos) != null && !(level.getBlockEntity(pos) instanceof MageBlockTile) && !(level.getBlockEntity(pos) instanceof SkullBlockEntity)) {
            return false;
        }
        return BlockUtil.canBlockBeHarvested(spellStats, level, pos) && BlockUtil.destroyRespectsClaim(owner, level, pos);
    }

    @Nullable
    public static EnchantedFallingBlock fall(Level level, BlockPos pos, Entity owner, SpellContext context, SpellResolver resolver, SpellStats spellStats) {
        EnchantedFallingBlock fallingblockentity;
        if (!EnchantedFallingBlock.canFall(level, pos, owner, spellStats)) {
            return null;
        }
        BlockState blockState = level.getBlockState(pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MageBlockTile) {
            MageBlockTile tile = (MageBlockTile)blockEntity;
            fallingblockentity = new EnchantedMageblock(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.FALSE) : blockState);
            fallingblockentity.blockData = tile.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            fallingblockentity.setColor(tile.color);
        } else {
            blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof SkullBlockEntity) {
                SkullBlockEntity tile = (SkullBlockEntity)blockEntity;
                fallingblockentity = new EnchantedSkull(level, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.FALSE) : blockState);
                fallingblockentity.blockData = tile.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            } else {
                fallingblockentity = new EnchantedFallingBlock(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.FALSE) : blockState, resolver);
            }
        }
        level.addFreshEntity((Entity)fallingblockentity);
        fallingblockentity.setOwner(owner);
        fallingblockentity.context = context;
        fallingblockentity.baseDamage = (float)(9.0 + spellStats.getDamageModifier());
        fallingblockentity.dropItem = !blockState.is(BlockTagProvider.GRAVITY_BLACKLIST);
        fallingblockentity.spellStats = spellStats;
        if (resolver.hasFocus((Item)ItemsRegistry.SHAPERS_FOCUS.get())) {
            fallingblockentity.hurtEntities = true;
        }
        if (context != null) {
            RewindAttachment rewindAttachment = RewindAttachment.get(context);
            rewindAttachment.addRewindEvent(level.getGameTime(), new BlockToEntityRewind(pos, blockState));
        }
        level.setBlock(pos, blockState.getFluidState().createLegacyBlock(), 3);
        return fallingblockentity;
    }

    @NotNull
    public EntityType<?> getType() {
        return (EntityType)ModEntities.ENCHANTED_FALLING_BLOCK.get();
    }

    public boolean canCollideWith(@NotNull Entity pEntity) {
        return super.canCollideWith(pEntity) && !(pEntity instanceof FallingBlockEntity) && !(pEntity instanceof EnchantedFallingBlock) && pEntity != this.getOwner();
    }

    protected boolean canHitEntity(@NotNull Entity p_37250_) {
        return super.canHitEntity(p_37250_) && p_37250_ != this.getOwner() && !this.piercingIgnoreEntityIds.contains(p_37250_.getId());
    }

    public void tick() {
        EntityHitResult hitEntity;
        super.tick();
        if (this.blockState.isAir()) {
            this.discard();
            return;
        }
        Block block = this.blockState.getBlock();
        ++this.time;
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        if ((hitEntity = this.findHitEntity(this.position, this.position.add(this.getDeltaMovement()))) != null) {
            this.onHitEntity(hitEntity);
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.level.isClientSide) {
            BlockHitResult blockhitresult;
            BlockPos blockpos = this.blockPosition();
            boolean isConcrete = this.blockState.getBlock() instanceof ConcretePowderBlock;
            boolean isConcreteInWater = isConcrete && this.level.getFluidState(blockpos).is(FluidTags.WATER);
            double d0 = this.getDeltaMovement().lengthSqr();
            if (isConcrete && d0 > 1.0 && (blockhitresult = this.level.clip(new ClipContext(new Vec3(this.xo, this.yo, this.zo), this.position(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this))).getType() != HitResult.Type.MISS && this.level.getFluidState(blockhitresult.getBlockPos()).is(FluidTags.WATER)) {
                blockpos = blockhitresult.getBlockPos();
                isConcreteInWater = true;
            }
            if (!this.onGround() && !isConcreteInWater) {
                if (!(this.level.isClientSide || (this.time <= 100 || blockpos.getY() > this.level.getMinBuildHeight() && blockpos.getY() <= this.level.getMaxBuildHeight()) && this.time <= 600)) {
                    if (this.dropItem && this.level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                        this.spawnAtLocation((ItemLike)block);
                    }
                    this.discard();
                }
            } else {
                IRewindable rewindable;
                EnchantedFallingBlock enchantedFallingBlock = this;
                if (enchantedFallingBlock instanceof IRewindable && !(rewindable = (IRewindable)((Object)enchantedFallingBlock)).isRewinding()) {
                    this.groundBlock(false);
                }
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
    }

    public BlockPos groundBlock(boolean ignoreAir) {
        boolean canSurvive;
        Block block = this.blockState.getBlock();
        BlockPos blockpos = this.blockPosition();
        BlockState blockstate = this.level.getBlockState(blockpos);
        boolean isConcrete = this.blockState.getBlock() instanceof ConcretePowderBlock;
        boolean isConcreteInWater = isConcrete && this.level.getFluidState(blockpos).is(FluidTags.WATER);
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
        if (blockstate.is(Blocks.MOVING_PISTON)) {
            return null;
        }
        if (this.cancelDrop) {
            this.discard();
            this.callOnBrokenAfterFall(block, blockpos);
            return null;
        }
        boolean canBeReplaced = blockstate.canBeReplaced((BlockPlaceContext)new DirectionalPlaceContext(this.level, blockpos, Direction.DOWN, ItemStack.EMPTY, Direction.UP));
        boolean isFreeBelow = FallingBlock.isFree((BlockState)this.level.getBlockState(blockpos.below())) && (!isConcrete || !isConcreteInWater);
        boolean bl = canSurvive = this.blockState.canSurvive((LevelReader)this.level, blockpos) && (!isFreeBelow || ignoreAir);
        if (canBeReplaced && canSurvive) {
            if (this.blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && this.level.getFluidState(blockpos).getType() == Fluids.WATER) {
                this.blockState = (BlockState)this.blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.TRUE);
            }
            if (this.level.setBlock(blockpos, this.blockState, 3)) {
                BlockEntity blockEntity;
                BlockEntity blockentity;
                ((ServerLevel)this.level).getChunkSource().chunkMap.broadcast((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockpos, this.level.getBlockState(blockpos)));
                this.discard();
                if (block instanceof Fallable) {
                    Fallable fallable = (Fallable)block;
                    fallable.onLand(this.level, blockpos, this.blockState, blockstate, new FallingBlockEntity(this.level, this.getX(), this.getY(), this.getZ(), this.blockState));
                } else if (this.context != null && this.resolver != null) {
                    RewindAttachment.get(this.context).addRewindEvent(this.level.getGameTime(), new EntityToBlockRewind(this, blockpos, this.blockState));
                    ShapersFocus.tryPropagateBlockSpell(new BlockHitResult(new Vec3((double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ()), Direction.DOWN, blockpos, false), this.level, this.getOwner(), this.context, this.resolver);
                }
                if (this.blockData != null && this.blockState.hasBlockEntity() && (blockentity = this.level.getBlockEntity(blockpos)) != null) {
                    try {
                        blockentity.loadWithComponents(this.blockData, (HolderLookup.Provider)this.level.registryAccess());
                        if (blockentity instanceof SkullBlockEntity) {
                            SkullBlockEntity sk = (SkullBlockEntity)blockentity;
                            if (this.blockData != null && this.blockData.contains("SkullOwner")) {
                                sk.setOwner((ResolvableProfile)ANCodecs.decode(ResolvableProfile.CODEC, (Tag)this.blockData.getCompound("SkullOwner")));
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    blockentity.setChanged();
                }
                if ((blockEntity = this.level.getBlockEntity(blockpos)) instanceof MageBlockTile) {
                    MageBlockTile mbt = (MageBlockTile)blockEntity;
                    mbt.color = this.getParticleColor();
                    mbt.setChanged();
                }
                return blockpos;
            }
            if (this.dropItem && this.level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                this.discard();
                this.callOnBrokenAfterFall(block, blockpos);
                ItemStack itemstack = new ItemStack((ItemLike)block);
                if (this.blockData != null && this.getBlockState().is(Blocks.PLAYER_HEAD)) {
                    ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)this.blockData.get("profile")).resultOrPartial().ifPresent(profile -> itemstack.set(DataComponents.PROFILE, profile));
                }
                this.spawnAtLocation(itemstack);
                return null;
            }
        } else {
            this.discard();
            if (this.dropItem && this.level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                this.callOnBrokenAfterFall(block, blockpos);
                ItemStack itemstack = new ItemStack((ItemLike)block);
                if (this.blockData != null && this.getBlockState().is(Blocks.PLAYER_HEAD)) {
                    ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)this.blockData.get("profile")).resultOrPartial().ifPresent(profile -> itemstack.set(DataComponents.PROFILE, profile));
                }
                this.spawnAtLocation(itemstack);
            }
        }
        return null;
    }

    public float getStateDamageBonus() {
        float destroySpeed = 1.0f;
        try {
            destroySpeed = this.blockState.getDestroySpeed((BlockGetter)this.level, this.blockPosition());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return destroySpeed;
    }

    protected void onHitEntity(@NotNull EntityHitResult pResult) {
        DamageSource damagesource;
        if (!this.hurtEntities) {
            return;
        }
        super.onHitEntity(pResult);
        Entity entity = pResult.getEntity();
        float f = (float)this.getDeltaMovement().length();
        int i = Mth.ceil((double)Mth.clamp((double)(Math.min((double)f, 2.5) * (double)this.baseDamage + (double)this.getStateDamageBonus()), (double)0.0, (double)2.147483647E9));
        this.piercingIgnoreEntityIds.add(entity.getId());
        Entity owner = this.getOwner();
        if (owner == null) {
            damagesource = this.level.damageSources().thrown((Entity)this, owner);
        } else {
            damagesource = this.level.damageSources().thrown((Entity)this, owner);
            if (owner instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)owner;
                livingOwner.setLastHurtMob(entity);
            }
        }
        boolean isEnderman = entity.getType() == EntityType.ENDERMAN;
        int k = entity.getRemainingFireTicks();
        if (this.isOnFire() && !isEnderman) {
            entity.igniteForTicks(5);
        }
        if (entity.hurt(damagesource, (float)i)) {
            if (isEnderman) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vec3 vec3;
                LivingEntity livingentity = (LivingEntity)entity;
                if (this.knockback > 0 && (vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)this.knockback * 0.6)).lengthSqr() > 0.0) {
                    livingentity.push(vec3.x, 0.1, vec3.z);
                }
                this.doPostHurtEffects(livingentity);
            }
            this.playSound(this.blockState.getSoundType().getBreakSound(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        } else {
            entity.setRemainingFireTicks(k);
        }
    }

    public void doPostHurtEffects(LivingEntity livingentity) {
    }

    public void fillCrashReportCategory(@NotNull CrashReportCategory pCategory) {
        super.fillCrashReportCategory(pCategory);
        pCategory.setDetail("Immitating BlockState", (Object)this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(@NotNull ServerEntity p_352287_) {
        return new ClientboundAddEntityPacket((Entity)this, p_352287_, Block.getId((BlockState)this.getBlockState()));
    }

    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public void recreateFromPacket(@NotNull ClientboundAddEntityPacket pPacket) {
        super.recreateFromPacket(pPacket);
        this.blockState = Block.stateById((int)pPacket.getData());
        this.blocksBuilding = true;
        double d0 = pPacket.getX();
        double d1 = pPacket.getY();
        double d2 = pPacket.getZ();
        this.setPos(d0, d1, d2);
        this.setStartPos(this.blockPosition());
    }

    public void callOnBrokenAfterFall(Block p_149651_, BlockPos p_149652_) {
        if (p_149651_ instanceof Fallable) {
            ((Fallable)p_149651_).onBrokenAfterFall(this.level, p_149652_, new FallingBlockEntity(this.level, this.getX(), this.getY(), this.getZ(), this.blockState));
        }
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        DamageSource damagesource;
        if (!this.hurtEntities) {
            return false;
        }
        int i = Mth.ceil((float)(pFallDistance - 1.0f));
        if (i < 0) {
            return false;
        }
        Predicate predicate = EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE);
        Block block = this.blockState.getBlock();
        if (block instanceof Fallable) {
            Fallable fallable = (Fallable)block;
            damagesource = fallable.getFallDamageSource((Entity)this);
        } else {
            damagesource = this.level.damageSources().fallingBlock((Entity)this);
        }
        float f = Math.min(Mth.floor((float)((float)i * this.fallDamagePerDistance)), this.fallDamageMax);
        this.level.getEntities((Entity)this, this.getBoundingBox(), predicate).forEach(p_149649_ -> p_149649_.hurt(damagesource, f));
        boolean flag = this.blockState.is(BlockTags.ANVIL);
        if (flag && f > 0.0f && this.random.nextFloat() < 0.05f + (float)i * 0.05f) {
            BlockState blockstate = AnvilBlock.damage((BlockState)this.blockState);
            if (blockstate == null) {
                this.cancelDrop = true;
            } else {
                this.blockState = blockstate;
            }
        }
        return false;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.blockState));
        pCompound.putInt("Time", this.time);
        pCompound.putBoolean("DropItem", this.dropItem);
        pCompound.putBoolean("HurtEntities", this.hurtEntities);
        pCompound.putFloat("FallHurtAmount", this.fallDamagePerDistance);
        pCompound.putInt("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            pCompound.put("TileEntityData", (Tag)this.blockData);
        }
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.blockState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)pCompound.getCompound("BlockState"));
        this.time = pCompound.getInt("Time");
        if (pCompound.contains("HurtEntities", 99)) {
            this.hurtEntities = pCompound.getBoolean("HurtEntities");
            this.fallDamagePerDistance = pCompound.getFloat("FallHurtAmount");
            this.fallDamageMax = pCompound.getInt("FallHurtMax");
        } else if (this.blockState.is(BlockTags.ANVIL)) {
            this.hurtEntities = true;
        }
        if (pCompound.contains("DropItem", 99)) {
            this.dropItem = pCompound.getBoolean("DropItem");
        }
        if (pCompound.contains("TileEntityData", 10)) {
            this.blockData = pCompound.getCompound("TileEntityData");
        }
        if (this.blockState.isAir()) {
            this.blockState = Blocks.SAND.defaultBlockState();
        }
    }

    public void setHurtsEntities(float p_149657_, int p_149658_) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = p_149657_;
        this.fallDamageMax = p_149658_;
    }

    public boolean isAttackable() {
        return false;
    }

    public void setStartPos(BlockPos pOrigin) {
        this.entityData.set(DATA_START_POS, (Object)pOrigin);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.entityData.get(DATA_START_POS);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_START_POS, (Object)BlockPos.ZERO);
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    }
}

