/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityHomingProjectileSpell
extends EntityProjectileSpell {
    List<Predicate<LivingEntity>> ignore;
    LivingEntity target;

    public EntityHomingProjectileSpell(EntityType<? extends EntityProjectileSpell> entityType, Level world) {
        super(entityType, world);
    }

    public EntityHomingProjectileSpell(Level world, SpellResolver resolver) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.SPELL_PROJ_HOM.get()), world, resolver);
    }

    @Override
    public EntityType<?> getType() {
        return (EntityType)ModEntities.SPELL_PROJ_HOM.get();
    }

    public void setIgnored(List<Predicate<LivingEntity>> ignore) {
        this.ignore = ignore;
    }

    public List<Predicate<LivingEntity>> getIgnored() {
        return this.ignore;
    }

    @Override
    public void tickNextPosition() {
        if (!this.isRemoved()) {
            if (this.target != null && (!this.target.isAlive() || this.target.distanceToSqr((Entity)this) > 50.0)) {
                this.target = null;
            }
            if (this.target == null && this.tickCount % 3 == 0) {
                List entities = this.getOwner() instanceof Player ? this.level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(4.0), this::shouldTarget) : this.level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(4.0), this::shouldTarget);
                if (entities.isEmpty() && this.target == null) {
                    super.tickNextPosition();
                } else if (!entities.isEmpty()) {
                    this.target = entities.stream().filter(e -> e.distanceToSqr((Entity)this) < 75.0).min(Comparator.comparingDouble(e -> e.distanceToSqr((Entity)this))).orElse(this.target);
                }
            }
            if (this.target != null) {
                this.homeTo(this.target.blockPosition());
            } else {
                super.tickNextPosition();
            }
        }
    }

    private void homeTo(BlockPos dest) {
        double posX = this.getX();
        double posY = this.getY();
        double posZ = this.getZ();
        double motionX = this.getDeltaMovement().x;
        double motionY = this.getDeltaMovement().y;
        double motionZ = this.getDeltaMovement().z;
        if (dest.getX() != 0 || dest.getY() != 0 || dest.getZ() != 0) {
            double targetX = (double)dest.getX() + 0.5;
            double targetY = (double)dest.getY() + 0.75;
            double targetZ = (double)dest.getZ() + 0.5;
            Vec3 targetVector = new Vec3(targetX - posX, targetY - posY, targetZ - posZ);
            double length = targetVector.length();
            targetVector = targetVector.scale(0.3 / length);
            double weight = 0.0;
            if (length <= 3.0) {
                weight = (3.0 - length) * 0.3;
            }
            motionX = (0.9 - weight) * motionX + (0.1 + weight) * targetVector.x;
            motionY = (0.9 - weight) * motionY + (0.1 + weight) * targetVector.y;
            motionZ = (0.9 - weight) * motionZ + (0.1 + weight) * targetVector.z;
        }
        this.setPos(posX += motionX, posY += motionY, posZ += motionZ);
        this.setDeltaMovement(motionX, motionY, motionZ);
    }

    @Override
    protected boolean canHitEntity(Entity entity) {
        boolean b = super.canHitEntity(entity);
        if (entity instanceof LivingEntity) {
            b &= this.shouldTarget((LivingEntity)entity);
        }
        return b;
    }

    private boolean shouldTarget(LivingEntity e) {
        if (this.ignore == null) {
            return false;
        }
        for (Predicate<LivingEntity> p : this.getIgnored()) {
            if (!p.test(e)) continue;
            return false;
        }
        return true;
    }
}

