/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.client.IVariantColorProvider;
import com.hollingsworth.arsnouveau.api.entity.ChangeableBehavior;
import com.hollingsworth.arsnouveau.api.entity.IDecoratable;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.item.NBTComponent;
import com.hollingsworth.arsnouveau.api.registry.BehaviorRegistry;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SummonUtil;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.compat.PatchouliHandler;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.debug.EntityDebugger;
import com.hollingsworth.arsnouveau.common.entity.debug.IDebugger;
import com.hollingsworth.arsnouveau.common.entity.debug.IDebuggerProvider;
import com.hollingsworth.arsnouveau.common.entity.goal.AvoidEntityGoalMC;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.UntamedFindItem;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.MovementHandler;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathingStuckHandler;
import com.hollingsworth.arsnouveau.common.items.data.StarbuncleCharmData;
import com.hollingsworth.arsnouveau.common.items.summon_charms.StarbuncleCharm;
import com.hollingsworth.arsnouveau.common.network.ITagSyncable;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketSyncTag;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import com.hollingsworth.arsnouveau.setup.reward.Rewards;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Starbuncle
extends PathfinderMob
implements GeoEntity,
IDecoratable,
IDispellable,
ITooltipProvider,
IWandable,
IDebuggerProvider,
ITagSyncable,
IVariantColorProvider<Starbuncle> {
    public EntityDebugger debugger = new EntityDebugger((Entity)this);
    public StarbuncleGoalState goalState = StarbuncleGoalState.NONE;
    private MinecoloniesAdvancedPathNavigate pathNavigate;
    public static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.defineId(Starbuncle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> COLOR = SynchedEntityData.defineId(Starbuncle.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> PATH_BLOCK = SynchedEntityData.defineId(Starbuncle.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<ItemStack> HEAD_COSMETIC = SynchedEntityData.defineId(Starbuncle.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final EntityDataAccessor<CompoundTag> BEHAVIOR_TAG = SynchedEntityData.defineId(Starbuncle.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private int backOff;
    private int bedBackoff;
    public int tamingTime;
    private int lastAABBCalc;
    private AABB cachedAAB;
    public BlockPos jukeboxPos;
    public boolean partyCarby;
    public PathNavigation minecraftPathNav;
    public StarbuncleCharmData.Mutable data = new StarbuncleCharmData.Mutable();
    public ChangeableBehavior dynamicBehavior = new StarbyTransportBehavior(this, new CompoundTag());
    public boolean canSleep;
    public boolean sleeping;
    AnimatableInstanceCache manager = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean setBehaviors;
    public static String[] carbyColors = (String[])Arrays.stream(DyeColor.values()).map(DyeColor::getName).toArray(String[]::new);

    public Starbuncle(EntityType<? extends Starbuncle> entityCarbuncleEntityType, Level world) {
        super(entityCarbuncleEntityType, world);
        this.dynamicBehavior = new StarbyTransportBehavior(this, new CompoundTag());
        this.reloadGoals();
        this.moveControl = new MovementHandler((Mob)this);
        this.setPathfindingMalus(PathType.DANGER_OTHER, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, 0.0f);
    }

    public Starbuncle(Level world, boolean tamed) {
        this((EntityType<? extends Starbuncle>)((EntityType)ModEntities.STARBUNCLE_TYPE.get()), world);
        this.setTamed(tamed);
    }

    public MinecoloniesAdvancedPathNavigate getNavigation() {
        if (this.pathNavigate == null) {
            this.pathNavigate = new MinecoloniesAdvancedPathNavigate((Mob)this, this.level);
            this.minecraftPathNav = this.navigation;
            this.navigation = this.pathNavigate;
            this.pathNavigate.setCanFloat(true);
            this.pathNavigate.setSwimSpeedFactor(2.0);
            this.pathNavigate.getPathingOptions().setEnterDoors(true);
            this.pathNavigate.getPathingOptions().setCanOpenDoors(true);
            if (this.isTamed()) {
                this.pathNavigate.setStuckHandler(PathingStuckHandler.createStuckHandler().withTeleportOnFullStuck().withTeleportSteps(5));
            }
            this.pathNavigate.getPathingOptions().setCanFitInOneCube(true);
            this.pathNavigate.getPathingOptions().onPathCost = 0.1;
            this.pathNavigate.getPathingOptions().withRoadState(this::isOnRoad);
        }
        return this.pathNavigate;
    }

    public Boolean isOnRoad(BlockState state) {
        return state.getBlock() instanceof DirtPathBlock || this.data.pathBlock != null && this.data.pathBlock == state.getBlock();
    }

    public void setBehavior(ChangeableBehavior behavior) {
        this.dynamicBehavior = behavior;
        this.data.behaviorKey = behavior.getRegistryName();
        this.getEntityData().set(BEHAVIOR_TAG, (Object)this.dynamicBehavior.toTag(new CompoundTag()));
        this.reloadGoals();
        this.syncBehavior();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animatableManager) {
        animatableManager.add(new AnimationController((GeoAnimatable)this, "walkController", 1, event -> {
            if (event.isMoving() || this.level.isClientSide && PatchouliHandler.isPatchouliWorld()) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("run"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        animatableManager.add(new AnimationController((GeoAnimatable)this, "danceController", 1, event -> {
            if (!this.isTamed() && this.getHeldStack().is(Tags.Items.NUGGETS_GOLD) || this.partyCarby && this.jukeboxPos != null && BlockUtil.distanceFrom(this.position, this.jukeboxPos) <= 8.0) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("dance"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        animatableManager.add(new AnimationController((GeoAnimatable)this, "sleepController", 1, this::lambda$registerControllers$2));
        animatableManager.add(new AnimationController((GeoAnimatable)this, "idleController", 1, this::lambda$registerControllers$3));
    }

    public void getNextItemFromPassengers() {
        Starbuncle starbuncle;
        Entity entity = this.getFirstPassenger();
        if (entity instanceof Starbuncle && !(starbuncle = (Starbuncle)entity).getHeldStack().isEmpty()) {
            this.setHeldStack(starbuncle.getHeldStack().copyAndClear());
            starbuncle.getNextItemFromPassengers();
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.manager;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return SummonUtil.canSummonTakeDamage(pSource) && super.hurt(pSource, pAmount);
    }

    public boolean isTamed() {
        return (Boolean)this.entityData.get(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.entityData.set(TAMED, (Object)tamed);
    }

    public String pathBlockDesc() {
        return (String)this.entityData.get(PATH_BLOCK);
    }

    public void setPathBlockDesc(String name) {
        this.entityData.set(PATH_BLOCK, (Object)name);
    }

    public void attemptTame() {
        if (!this.isTamed() && this.getHeldStack().is(Tags.Items.NUGGETS_GOLD)) {
            ++this.tamingTime;
            if (this.tamingTime > 60 && !this.level.isClientSide) {
                ItemStack stack = new ItemStack((ItemLike)ItemsRegistry.STARBUNCLE_SHARD.get(), 1 + this.level.random.nextInt(2));
                if (this.data.adopter != null && !this.data.adopter.isEmpty()) {
                    stack.setCount(1);
                    stack.set(DataComponentRegistry.STARBUNCLE_DATA, (Object)this.data.immutable());
                }
                this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY() + 0.5, this.getZ(), stack));
                this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ILLUSIONER_MIRROR_MOVE, SoundSource.NEUTRAL, 1.0f, 1.0f);
                ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)ANCriteriaTriggers.POOF_MOB.get(), (ServerLevel)this.level, this.getOnPos(), 10);
                this.remove(Entity.RemovalReason.DISCARDED);
            } else if (this.tamingTime > 55 && this.level.isClientSide) {
                for (int i = 0; i < 10; ++i) {
                    double d0 = this.getX();
                    double d1 = this.getY() + 0.1;
                    double d2 = this.getZ();
                    this.level.addParticle((ParticleOptions)ParticleTypes.END_ROD, d0, d1, d2, ((double)(this.level.random.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.level.random.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.level.random.nextFloat() * 1.0f) - 0.5) / 3.0);
                }
            }
        }
    }

    public void tick() {
        try {
            super.tick();
        }
        catch (NoClassDefFoundError error) {
            System.out.println("Starbuncle threaded pathing failed.");
            System.out.println(this);
            return;
        }
        if (this.dynamicBehavior != null) {
            this.dynamicBehavior.tick();
        }
        if (this.level.isClientSide && this.level.getGameTime() % 5L == 0L) {
            this.canSleep = this.getBlockStateOn().is(BlockTagProvider.SUMMON_SLEEPABLE);
        }
        SummonUtil.healOverTime((LivingEntity)this);
        if (!this.level.isClientSide && this.level.getGameTime() % 10L == 0L && this.getName().getString().toLowerCase(Locale.ROOT).equals("jeb_")) {
            this.entityData.set(COLOR, (Object)carbyColors[this.level.random.nextInt(carbyColors.length)]);
        }
        if (!this.level.isClientSide) {
            ++this.lastAABBCalc;
            if (this.backOff > 0) {
                --this.backOff;
            }
            if (this.bedBackoff > 0) {
                --this.bedBackoff;
            }
        }
        if (!this.level.isClientSide && this.dynamicBehavior != null && this.level.getGameTime() % 100L == 0L) {
            this.dynamicBehavior.syncTag();
        }
        if (this.dead) {
            return;
        }
        if (!this.level.isClientSide && this.getStarbuncleWithSpace() != null) {
            for (ItemEntity itementity : this.level.getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(1.0))) {
                if (!itementity.isAlive() || itementity.getItem().isEmpty() || itementity.hasPickUpDelay()) continue;
                this.pickUpItem(itementity);
                if (this.getHeldStack() == null || this.getHeldStack().isEmpty()) continue;
                break;
            }
        }
        this.attemptTame();
    }

    @Override
    public void onWanded(Player playerEntity) {
        boolean removeAcc = this.dynamicBehavior.clearOrRemove();
        this.dynamicBehavior.onWanded(playerEntity);
        this.data.pathBlock = null;
        this.data.bedPos = null;
        if (!this.getCosmeticItem().isEmpty() && removeAcc) {
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), this.getCosmeticItem().split(1)));
            if (!(this.dynamicBehavior instanceof StarbyTransportBehavior)) {
                this.dynamicBehavior = new StarbyTransportBehavior(this, new CompoundTag());
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.default_behavior"));
                this.syncBehavior();
            }
            this.setCosmeticItem(ItemStack.EMPTY);
        }
        PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.cleared"));
    }

    @Override
    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        return this.dynamicBehavior == null ? new ArrayList() : this.dynamicBehavior.getWandHighlight(list);
    }

    public void syncBehavior() {
        Networking.sendToNearbyClient(this.level, (Entity)this, (CustomPacketPayload)new PacketSyncTag(this.dynamicBehavior.toTag(new CompoundTag()), this.getId()));
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @org.jetbrains.annotations.Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        Entity entity;
        if (this.isPassenger() && (entity = this.getRootVehicle()) instanceof Starbuncle) {
            Starbuncle baseStarby = (Starbuncle)entity;
            baseStarby.dynamicBehavior.onFinishedConnectionFirst(storedPos, side, storedEntity, playerEntity);
            return;
        }
        this.dynamicBehavior.onFinishedConnectionFirst(storedPos, side, storedEntity, playerEntity);
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @org.jetbrains.annotations.Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        Entity entity;
        if (this.isPassenger() && (entity = this.getRootVehicle()) instanceof Starbuncle) {
            Starbuncle baseStarby = (Starbuncle)entity;
            baseStarby.dynamicBehavior.onFinishedConnectionLast(storedPos, side, storedEntity, playerEntity);
            return;
        }
        this.dynamicBehavior.onFinishedConnectionLast(storedPos, side, storedEntity, playerEntity);
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.STEP_HEIGHT, (double)1.1f);
    }

    public boolean canCollideWith(Entity pEntity) {
        if (pEntity instanceof Player) {
            return false;
        }
        return super.canCollideWith(pEntity);
    }

    public boolean isPushable() {
        return false;
    }

    protected void pushEntities() {
    }

    public void pickUpItem(ItemEntity itemEntity) {
        if (!this.getHeldStack().isEmpty() && this.getStarbuncleWithSpace() == null) {
            return;
        }
        if (!this.isTamed() && itemEntity.getItem().is(Tags.Items.NUGGETS_GOLD)) {
            this.setHeldStack(itemEntity.getItem().split(1));
            return;
        }
        this.dynamicBehavior.pickUpItem(itemEntity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRecordPlayingNearby(BlockPos pos, boolean hasSound) {
        super.setRecordPlayingNearby(pos, hasSound);
        this.jukeboxPos = pos;
        this.partyCarby = hasSound;
    }

    protected void reloadGoals() {
        if (this.level.isClientSide()) {
            return;
        }
        this.goalSelector.availableGoals.clear();
        for (WrappedGoal goal : this.getGoals()) {
            this.goalSelector.addGoal(goal.getPriority(), goal.getGoal());
        }
    }

    public List<WrappedGoal> getGoals() {
        ArrayList<WrappedGoal> list = new ArrayList<WrappedGoal>();
        list.add(new WrappedGoal(0, (Goal)new FloatGoal((Mob)this)));
        if (!this.isTamed()) {
            list.add(new WrappedGoal(1, (Goal)new UntamedFindItem(this)));
            list.add(new WrappedGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 0.02f)));
            list.add(new WrappedGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f)));
            list.add(new WrappedGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2)));
            list.add(new WrappedGoal(2, new AvoidEntityGoalMC<Player>(this, Player.class, 16.0f, 1.2)));
            list.add(new WrappedGoal(0, (Goal)new FloatGoal((Mob)this)));
        } else {
            list.addAll(this.dynamicBehavior.goals);
        }
        return list;
    }

    protected float getWaterSlowDown() {
        return 0.875f;
    }

    public void die(DamageSource source) {
        if (!this.level.isClientSide && this.isTamed()) {
            this.dropData();
        }
        super.die(source);
    }

    public void dropData() {
        ItemStack stack = new ItemStack((ItemLike)ItemsRegistry.STARBUNCLE_CHARM.get());
        stack.set(DataComponentRegistry.STARBUNCLE_DATA, (Object)this.data.immutable());
        this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), stack));
        if (this.getHeldStack() != null) {
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), this.getHeldStack()));
        }
    }

    public AABB getAABB() {
        if (this.cachedAAB == null || this.lastAABBCalc >= 60) {
            this.cachedAAB = new AABB(this.blockPosition()).inflate(8.0);
            this.lastAABBCalc = 0;
        }
        return this.cachedAAB;
    }

    protected void updateControlFlags() {
        boolean flag = true;
        boolean flag1 = !(this.getVehicle() instanceof Boat);
        this.goalSelector.setControlFlag(Goal.Flag.MOVE, flag);
        this.goalSelector.setControlFlag(Goal.Flag.JUMP, flag && flag1);
        this.goalSelector.setControlFlag(Goal.Flag.LOOK, flag);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND || player.getCommandSenderWorld().isClientSide || !this.isTamed()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getItemInHand(hand);
        Item item = player.getMainHandItem().getItem();
        if (item instanceof StarbuncleCharm) {
            StarbuncleCharm starbuncleCharm = (StarbuncleCharm)item;
            Starbuncle carbuncle = new Starbuncle(this.level, true);
            carbuncle.data = ((StarbuncleCharmData)player.getMainHandItem().getOrDefault(DataComponentRegistry.STARBUNCLE_DATA, (Object)new StarbuncleCharmData())).mutable();
            this.level.addFreshEntity((Entity)carbuncle);
            carbuncle.restoreFromTag();
            carbuncle.startRiding((Entity)this);
            stack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        if (player.getMainHandItem().is(Tags.Items.DYES)) {
            DyeColor color = DyeColor.getColor((ItemStack)stack);
            if (color == null || ((String)this.entityData.get(COLOR)).equals(color.getName()) || !Arrays.asList(carbyColors).contains(color.getName())) {
                return InteractionResult.SUCCESS;
            }
            this.setColor(color.getName());
            player.getMainHandItem().shrink(1);
            return InteractionResult.SUCCESS;
        }
        item = player.getMainHandItem().getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.data.pathBlock = blockItem.getBlock();
            this.setPathBlockDesc(Component.translatable((String)this.data.pathBlock.getDescriptionId()).getString());
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.starbuncle.path"));
        }
        return this.dynamicBehavior.mobInteract(player, hand);
    }

    public EntityType<?> getType() {
        return (EntityType)ModEntities.STARBUNCLE_TYPE.get();
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(TAMED, (Object)false);
        pBuilder.define(COLOR, (Object)DyeColor.ORANGE.getName());
        pBuilder.define(PATH_BLOCK, (Object)"");
        pBuilder.define(HEAD_COSMETIC, (Object)ItemStack.EMPTY);
        pBuilder.define(BEHAVIOR_TAG, (Object)new CompoundTag());
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void setHeldStack(ItemStack stack) {
        this.setItemSlot(EquipmentSlot.MAINHAND, stack == null ? ItemStack.EMPTY : stack);
    }

    public ItemStack getHeldStack() {
        return this.getMainHandItem();
    }

    public Starbuncle getStarbuncleWithSpace() {
        if (this.getHeldStack().isEmpty()) {
            return this;
        }
        for (Entity e : this.getIndirectPassengers()) {
            Starbuncle starbuncle;
            if (!(e instanceof Starbuncle) || !(starbuncle = (Starbuncle)e).getHeldStack().isEmpty()) continue;
            return starbuncle;
        }
        return null;
    }

    @Override
    public ItemStack getCosmeticItem() {
        return (ItemStack)this.entityData.get(HEAD_COSMETIC);
    }

    @Override
    public void setCosmeticItem(ItemStack stack) {
        if (!((ItemStack)this.entityData.get(HEAD_COSMETIC)).isEmpty()) {
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), (ItemStack)this.entityData.get(HEAD_COSMETIC)));
        }
        this.entityData.set(HEAD_COSMETIC, (Object)stack);
        this.data.cosmetic = stack;
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.isRemoved()) {
            return false;
        }
        if (!this.level.isClientSide && this.isTamed()) {
            this.dropData();
            ParticleUtil.spawnPoof((ServerLevel)this.level, this.blockPosition());
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return this.isTamed();
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.data = ((StarbuncleCharmData)NBTComponent.fromTag(StarbuncleCharmData.CODEC.codec(), (Tag)(tag.contains("starbuncleData") ? tag.getCompound("starbuncleData") : new CompoundTag()))).mutable();
        this.dynamicBehavior = BehaviorRegistry.create(this.data.behaviorKey, (Entity)this, this.data.behaviorTag);
        this.setHeldStack(ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)tag.getCompound("held")));
        this.backOff = tag.getInt("backoff");
        this.entityData.set(TAMED, (Object)tag.getBoolean("tamed"));
        if (!this.setBehaviors) {
            this.goalSelector.availableGoals = new LinkedHashSet();
            this.reloadGoals();
            this.setBehaviors = true;
            this.restoreFromTag();
            if (this.dynamicBehavior != null && !this.level.isClientSide) {
                this.dynamicBehavior.syncTag();
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.data.behaviorTag = this.dynamicBehavior.toTag(new CompoundTag());
        tag.put("starbuncleData", this.data.immutable().toTag(this.level));
        if (!this.getHeldStack().isEmpty()) {
            Tag itemTag = this.getHeldStack().save((HolderLookup.Provider)this.level.registryAccess());
            tag.put("held", itemTag);
        }
        tag.putInt("backoff", this.backOff);
        tag.putBoolean("tamed", ((Boolean)this.entityData.get(TAMED)).booleanValue());
    }

    public void restoreFromTag() {
        if (this.data.color != null) {
            this.entityData.set(COLOR, (Object)this.data.color);
        }
        if (this.data.pathBlock != null) {
            this.setPathBlockDesc(Component.translatable((String)this.data.pathBlock.getDescriptionId()).getString());
        }
        if (this.data.cosmetic != null && !this.data.cosmetic.isEmpty()) {
            this.entityData.set(HEAD_COSMETIC, (Object)this.data.cosmetic);
        }
        this.setCustomName(this.data.name);
        if (this.data.behaviorTag != null) {
            this.dynamicBehavior = BehaviorRegistry.create(this.data.behaviorKey, (Entity)this, this.data.behaviorTag);
            this.entityData.set(BEHAVIOR_TAG, (Object)this.dynamicBehavior.toTag(new CompoundTag()));
            this.reloadGoals();
        } else if (this.isTamed()) {
            this.dynamicBehavior = new StarbyTransportBehavior(this, new CompoundTag());
            this.entityData.set(BEHAVIOR_TAG, (Object)this.dynamicBehavior.toTag(new CompoundTag()));
            this.reloadGoals();
        }
        if (!this.level.isClientSide && this.dynamicBehavior != null) {
            this.dynamicBehavior.syncTag();
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (pKey == BEHAVIOR_TAG) {
            this.dynamicBehavior = BehaviorRegistry.create(this.data.behaviorKey, (Entity)this, (CompoundTag)this.entityData.get(BEHAVIOR_TAG));
        }
    }

    public void setCustomName(@Nullable Component pName) {
        super.setCustomName(pName);
        this.data.name = pName;
    }

    public int getBedBackoff() {
        return this.bedBackoff;
    }

    public void setBedBackoff(int bedBackoff) {
        this.bedBackoff = bedBackoff;
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        Entity entity;
        if (!this.isTamed()) {
            return;
        }
        if (this.isPassenger() && (entity = this.getRootVehicle()) instanceof Starbuncle) {
            Starbuncle baseStarby = (Starbuncle)entity;
            baseStarby.getTooltip(tooltip);
            return;
        }
        if (this.dynamicBehavior != null) {
            this.dynamicBehavior.getTooltip(tooltip::add);
        }
        if (this.pathBlockDesc() != null && !this.pathBlockDesc().isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.starbuncle.pathing", (Object[])new Object[]{this.entityData.get(PATH_BLOCK)}));
        }
    }

    public int getBaseExperienceReward() {
        return 0;
    }

    public void setColor(String color) {
        this.data.color = color;
        this.entityData.set(COLOR, (Object)this.data.color);
    }

    @Override
    public void setColor(String color, Starbuncle object) {
        this.setColor(color);
    }

    @Override
    public String getColor(Starbuncle object) {
        return (String)this.entityData.get(COLOR);
    }

    public String getColor() {
        return (String)this.entityData.get(COLOR);
    }

    @Override
    public ResourceLocation getTexture(Starbuncle entity) {
        if (entity.getName().getString().equals("Gootastic")) {
            return ArsNouveau.prefix("textures/entity/starbuncle_goo.png");
        }
        String color = this.getColor(entity);
        if (color.isEmpty()) {
            color = DyeColor.ORANGE.getName();
        }
        return ArsNouveau.prefix("textures/entity/starbuncle_" + color.toLowerCase() + ".png");
    }

    @org.jetbrains.annotations.Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @org.jetbrains.annotations.Nullable SpawnGroupData pSpawnData) {
        RandomSource randomSource = pLevel.getRandom();
        if (randomSource.nextFloat() <= 0.1f && !Rewards.starbuncles.isEmpty()) {
            try {
                Rewards.ContributorStarby contributorStarby = Rewards.starbuncles.get(randomSource.nextInt(Rewards.starbuncles.size()));
                this.setColor(contributorStarby.color);
                this.setCustomName((Component)Component.literal((String)contributorStarby.name));
                this.data.bio = contributorStarby.bio;
                this.data.adopter = contributorStarby.adopter;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.setColor(carbyColors[randomSource.nextInt(carbyColors.length)]);
        }
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    public int getBackOff() {
        return this.backOff;
    }

    public void setBackOff(int backOff) {
        this.backOff = backOff;
    }

    @Override
    public IDebugger getDebugger() {
        return this.debugger;
    }

    public void addGoalDebug(Goal goal, DebugEvent debugEvent) {
        this.addGoalDebug((Object)goal, debugEvent);
    }

    public void addGoalDebug(Object goal, DebugEvent debugEvent) {
        this.addGoalDebug(goal, debugEvent, false);
    }

    public void addGoalDebug(Object goal, DebugEvent debugEvent, boolean storeDuplicate) {
        debugEvent.id = goal.getClass().getSimpleName() + "_" + debugEvent.id;
        this.addDebugEvent(debugEvent, storeDuplicate);
    }

    @Override
    public void onTagSync(CompoundTag tag) {
        if (this.level.isClientSide) {
            this.dynamicBehavior = BehaviorRegistry.create(this.data.behaviorKey, (Entity)this, tag);
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ PlayState lambda$registerControllers$3(AnimationState event) {
        if (this.canSleep) ** GOTO lbl-1000
        var4_2 = this.getVehicle();
        if (var4_2 instanceof Starbuncle) {
            vehicle = (Starbuncle)var4_2;
            ** if (!vehicle.sleeping) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v0 = true;
            ** GOTO lbl10
        }
lbl-1000:
        // 2 sources

        {
            v0 = shouldSleep = false;
        }
lbl10:
        // 2 sources

        if (!event.isMoving() && !shouldSleep) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ PlayState lambda$registerControllers$2(AnimationState event) {
        if (this.canSleep) ** GOTO lbl-1000
        var4_2 = this.getVehicle();
        if (var4_2 instanceof Starbuncle) {
            vehicle = (Starbuncle)var4_2;
            ** if (!vehicle.sleeping) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v0 = true;
            ** GOTO lbl10
        }
lbl-1000:
        // 2 sources

        {
            v0 = shouldSleep = false;
        }
lbl10:
        // 2 sources

        if (!event.isMoving() && shouldSleep) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("resting"));
            this.sleeping = true;
            return PlayState.CONTINUE;
        }
        this.sleeping = false;
        return PlayState.STOP;
    }

    @Deprecated
    public static enum StarbuncleGoalState {
        FORAGING,
        HUNTING_ITEM,
        TAKING_ITEM,
        STORING_ITEM,
        RESTING,
        NONE;

    }
}

