/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.familiar;

import com.hollingsworth.arsnouveau.api.client.IVariantTextureProvider;
import com.hollingsworth.arsnouveau.api.entity.IDecoratable;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.event.FamiliarSummonEvent;
import com.hollingsworth.arsnouveau.api.familiar.IFamiliar;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.entity.goal.familiar.FamOwnerHurtByTargetGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.familiar.FamOwnerHurtTargetGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.familiar.FamiliarFollowGoal;
import com.hollingsworth.arsnouveau.common.items.data.PersistentFamiliarData;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FamiliarEntity
extends PathfinderMob
implements GeoEntity,
IFamiliar,
IDispellable,
IDecoratable,
IVariantTextureProvider<FamiliarEntity> {
    public double manaReserveModifier = 0.15;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static final EntityDataAccessor<String> COLOR = SynchedEntityData.defineId(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<ItemStack> COSMETIC = SynchedEntityData.defineId(FamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static Set<FamiliarEntity> FAMILIAR_SET = Collections.newSetFromMap(new WeakHashMap());
    public boolean terminatedFamiliar;
    public ResourceLocation holderID;
    public PersistentFamiliarData persistentData = new PersistentFamiliarData();
    public AnimationController<?> controller;
    public AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FamiliarEntity(EntityType<? extends PathfinderMob> p_i48575_1_, Level p_i48575_2_) {
        super(p_i48575_1_, p_i48575_2_);
        if (!this.level.isClientSide) {
            FAMILIAR_SET.add(this);
        }
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        return super.mobInteract(player, hand);
    }

    public boolean removeWhenFarAway(double p_213397_1_) {
        return false;
    }

    public double getManaReserveModifier() {
        return this.manaReserveModifier;
    }

    public void setCustomName(@Nullable Component pName) {
        super.setCustomName(pName);
        this.persistentData = this.persistentData.setName(pName);
        this.syncTag();
    }

    public boolean isAlive() {
        return super.isAlive() && !this.terminatedFamiliar && (this.level.isClientSide || FAMILIAR_SET.contains(this));
    }

    public void tick() {
        super.tick();
        if (this.terminatedFamiliar) {
            this.remove(Entity.RemovalReason.DISCARDED);
            FAMILIAR_SET.remove(this);
        }
        if (this.level.getGameTime() % 20L == 0L && !this.level.isClientSide && (this.getOwnerID() == null || ((ServerLevel)this.level).getEntity(this.getOwnerID()) == null || this.terminatedFamiliar)) {
            this.remove(Entity.RemovalReason.DISCARDED);
            this.terminatedFamiliar = true;
            FAMILIAR_SET.remove(this);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.DROWN) || source.is(DamageTypes.FLY_INTO_WALL) || source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.FALL)) {
            return false;
        }
        if (source.getEntity() == null) {
            return false;
        }
        if (source.getEntity() == this.getOwner()) {
            return false;
        }
        return super.hurt(source, amount);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new FamiliarFollowGoal(this, 2.0, 6.0f, 4.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new FamOwnerHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new FamOwnerHurtTargetGoal(this));
    }

    public PlayState walkPredicate(AnimationState<? extends FamiliarEntity> event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        this.controller = new AnimationController((GeoAnimatable)this, "walkController", 1, this::walkPredicate);
        data.add(this.controller);
    }

    public boolean canTeleport() {
        return this.getOwner() != null && this.getOwner().onGround();
    }

    @Override
    @Nullable
    public LivingEntity getOwner() {
        if (this.level.isClientSide || this.getOwnerID() == null) {
            return null;
        }
        return (LivingEntity)((ServerLevel)this.level).getEntity(this.getOwnerID());
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(OWNER_UUID, Optional.empty());
        pBuilder.define(COLOR, (Object)"");
        pBuilder.define(COSMETIC, (Object)ItemStack.EMPTY);
    }

    @Override
    public ResourceLocation getHolderID() {
        return this.holderID;
    }

    @Override
    public void setHolderID(ResourceLocation id) {
        this.holderID = id;
    }

    @Override
    @Nullable
    public UUID getOwnerID() {
        return ((Optional)this.getEntityData().get(OWNER_UUID)).orElse(null);
    }

    @Override
    public void setOwnerID(UUID uuid) {
        this.getEntityData().set(OWNER_UUID, Optional.of(uuid));
    }

    @Override
    @NotNull
    public ItemStack getCosmeticItem() {
        return (ItemStack)this.entityData.get(COSMETIC);
    }

    public void setCosmeticItem(ItemStack stack, boolean shouldDrop) {
        if (!((ItemStack)this.entityData.get(COSMETIC)).isEmpty() && shouldDrop) {
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), (ItemStack)this.entityData.get(COSMETIC)));
        }
        this.entityData.set(COSMETIC, (Object)stack);
        this.persistentData = this.persistentData.setCosmetic(stack);
        this.syncTag();
    }

    @Override
    public void setCosmeticItem(ItemStack stack) {
        this.setCosmeticItem(stack, true);
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FLYING_SPEED, ((Attribute)Attributes.FLYING_SPEED.value()).getDefaultValue()).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public boolean canTrample(@NotNull BlockState state, @NotNull BlockPos pos, float fallDistance) {
        return false;
    }

    protected boolean canRide(@NotNull Entity p_184228_1_) {
        return false;
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (!this.level().isClientSide && this.getOwner() != null && this.getOwner().equals((Object)caster)) {
            this.remove(Entity.RemovalReason.DISCARDED);
            ParticleUtil.spawnPoof((ServerLevel)this.level(), this.blockPosition());
            return true;
        }
        return false;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.getOwnerID() != null) {
            tag.putUUID("ownerID", this.getOwnerID());
        }
        tag.putBoolean("terminated", this.terminatedFamiliar);
        tag.put("familiarData", this.getPersistentFamiliarData().toTag(this.level));
        if (this.holderID != null) {
            tag.putString("holderID", this.holderID.toString());
        }
        tag.putString("color", (String)this.entityData.get(COLOR));
        if (!((ItemStack)this.entityData.get(COSMETIC)).isEmpty()) {
            Tag cosmeticTag = ((ItemStack)this.entityData.get(COSMETIC)).save((HolderLookup.Provider)this.level.registryAccess());
            tag.put("cosmetic", cosmeticTag);
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.hasUUID("ownerID")) {
            this.setOwnerID(tag.getUUID("ownerID"));
        }
        this.terminatedFamiliar = tag.getBoolean("terminated");
        this.holderID = ResourceLocation.tryParse((String)tag.getString("holderID"));
        this.persistentData = this.deserializePersistentData(tag.getCompound("familiarData"));
        this.entityData.set(COLOR, (Object)tag.getString("color"));
        this.entityData.set(COSMETIC, (Object)ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)tag.getCompound("cosmetic")));
        this.syncAfterPersistentFamiliarInit();
    }

    @Override
    public void onFamiliarSpawned(FamiliarSummonEvent event) {
        if (this.level.isClientSide) {
            return;
        }
        IFamiliar.super.onFamiliarSpawned(event);
        if (!event.getEntity().equals((Object)this) && event.owner.equals((Object)this.getOwner())) {
            this.terminatedFamiliar = true;
        }
    }

    public String getColor() {
        return (String)this.entityData.get(COLOR);
    }

    public void setColor(DyeColor color) {
        this.setColor(color.getName());
    }

    public void setColor(String color) {
        this.entityData.set(COLOR, (Object)color);
        this.persistentData = this.persistentData.setColor(color);
        this.syncTag();
    }

    public void setTagData(@Nullable CompoundTag tag) {
        this.persistentData = this.deserializePersistentData(tag != null && tag.contains("familiarData") ? tag.getCompound("familiarData") : new CompoundTag());
        this.syncAfterPersistentFamiliarInit();
    }

    public void syncTag() {
        ANPlayerDataCap cap = CapabilityRegistry.getPlayerDataCap(this.getOwner());
        if (cap != null && this.persistentData != null) {
            cap.getFamiliarData((ResourceLocation)this.getHolderID()).entityTag.put("familiarData", this.persistentData.toTag(this.level));
        }
    }

    public PersistentFamiliarData deserializePersistentData(CompoundTag tag) {
        return PersistentFamiliarData.fromTag((Tag)tag);
    }

    public PersistentFamiliarData getPersistentFamiliarData() {
        return this.persistentData;
    }

    public void syncAfterPersistentFamiliarInit() {
        this.setCustomName(this.persistentData.name());
        if (this.persistentData.color() != null) {
            this.setColor(this.persistentData.color());
        }
        if (this.persistentData.cosmetic() != null) {
            this.setCosmeticItem(this.persistentData.cosmetic(), false);
        }
    }
}

