/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.amethyst_golem;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.AmethystGolem;
import java.util.function.Supplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class DepositAmethystGoal
extends Goal {
    public AmethystGolem golem;
    public Supplier<Boolean> canUse;
    int usingTicks;
    boolean isDone;

    public DepositAmethystGoal(AmethystGolem golem, Supplier<Boolean> canUse) {
        this.golem = golem;
        this.canUse = canUse;
    }

    public boolean canContinueToUse() {
        return this.golem.getHome() != null && !this.isDone;
    }

    public void tick() {
        super.tick();
        --this.usingTicks;
        if (this.usingTicks <= 0) {
            this.isDone = true;
            this.deposit();
            return;
        }
        if (this.golem.getHome() == null) {
            return;
        }
        if (BlockUtil.distanceFrom(this.golem.blockPosition(), this.golem.getHome()) <= 2.0) {
            this.isDone = true;
            this.deposit();
        }
        this.golem.getNavigation().tryMoveToBlockPos(this.golem.getHome(), 1.0);
    }

    public void deposit() {
        IItemHandler iItemHandler = (IItemHandler)this.golem.level.getCapability(Capabilities.ItemHandler.BLOCK, this.golem.getHome(), null);
        if (iItemHandler != null) {
            ItemStack oldStack = new ItemStack((ItemLike)this.golem.getHeldStack().getItem(), this.golem.getHeldStack().getCount());
            ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)this.golem.getHeldStack(), (boolean)false);
            if (left.equals(oldStack)) {
                return;
            }
            this.golem.setHeldStack(left);
        }
    }

    public void start() {
        this.isDone = false;
        this.usingTicks = 80;
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.DEPOSIT;
    }

    public void stop() {
        super.stop();
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.NONE;
    }

    public boolean isInterruptable() {
        return false;
    }

    public boolean canUse() {
        if (this.golem.getHome() == null || this.golem.getHeldStack().isEmpty()) {
            return false;
        }
        return this.canUse.get() != false && this.golem.level.getCapability(Capabilities.ItemHandler.BLOCK, this.golem.getHome(), null) != null;
    }
}

