/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.entity.ChangeableBehavior;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.NonHoggingLook;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class StarbyBehavior
extends ChangeableBehavior {
    public Starbuncle starbuncle;

    public StarbyBehavior(Starbuncle entity, CompoundTag tag) {
        super((Entity)entity, tag);
        this.starbuncle = entity;
        this.goals.add(new WrappedGoal(8, (Goal)new LookAtPlayerGoal((Mob)this.starbuncle, Player.class, 3.0f, 0.01f)));
        this.goals.add(new WrappedGoal(8, (Goal)new NonHoggingLook(this.starbuncle, Mob.class, 3.0f, 0.01f)));
        this.goals.add(new WrappedGoal(1, (Goal)new OpenDoorGoal((Mob)this.starbuncle, true)));
    }

    public boolean canGoToBed() {
        return true;
    }

    public boolean isBedPowered() {
        if (this.starbuncle.data.bedPos == null || !this.starbuncle.level.isLoaded(this.starbuncle.data.bedPos)) {
            return false;
        }
        BlockState state = this.starbuncle.level.getBlockState(this.starbuncle.data.bedPos);
        if (!state.is(BlockTagProvider.SUMMON_SLEEPABLE)) {
            return false;
        }
        return state.hasProperty((Property)BlockStateProperties.POWERED) && (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false;
    }

    @Nullable
    public BlockPos getBedPos() {
        if (this.starbuncle.data.bedPos == null || !this.starbuncle.level.isLoaded(this.starbuncle.data.bedPos)) {
            return null;
        }
        return this.starbuncle.data.bedPos;
    }

    public boolean isBedValid(BlockPos bedPos) {
        return this.starbuncle.level.isLoaded(bedPos) && this.starbuncle.level.getBlockState(new BlockPos((Vec3i)bedPos)).is(BlockTagProvider.SUMMON_SLEEPABLE);
    }

    public boolean isOnBed() {
        return this.starbuncle.level.getBlockState(BlockPos.containing((Position)this.starbuncle.position)).is(BlockTagProvider.SUMMON_SLEEPABLE);
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionFirst(storedPos, side, storedEntity, playerEntity);
        if (storedPos != null && playerEntity.level.getBlockState(storedPos).is(BlockTagProvider.SUMMON_SLEEPABLE)) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.set_bed"));
            this.starbuncle.data.bedPos = storedPos.immutable();
        }
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix("starby");
    }

    @Override
    public void syncTag() {
        this.starbuncle.syncBehavior();
    }

    @Override
    public ItemStack getStackForRender() {
        return this.starbuncle.getHeldStack();
    }
}

