/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToBedGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.PotionStoreGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.PotionTakeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyListBehavior;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class StarbyPotionBehavior
extends StarbyListBehavior {
    public static final ResourceLocation POTION_ID = ArsNouveau.prefix("starby_potion");
    @Nullable
    private PotionContents heldPotion = PotionContents.EMPTY;
    private int amount;

    public StarbyPotionBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        if (tag.contains("potionData")) {
            this.heldPotion = (PotionContents)ANCodecs.decode(PotionContents.CODEC, tag.get("potionData"));
        }
        this.amount = tag.getInt("amount");
        this.goals.add(new WrappedGoal(4, (Goal)new GoToBedGoal(this.starbuncle, this)));
        this.goals.add(new WrappedGoal(3, (Goal)new PotionTakeGoal(entity, this)));
        this.goals.add(new WrappedGoal(3, (Goal)new PotionStoreGoal(entity, this)));
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionFirst(storedPos, face, storedEntity, playerEntity);
        if (storedPos != null && this.level.getBlockEntity(storedPos) instanceof PotionJarTile) {
            this.addToPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.potion_to"));
        }
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionLast(storedPos, face, storedEntity, playerEntity);
        if (storedPos != null && this.level.getBlockEntity(storedPos) instanceof PotionJarTile) {
            this.addFromPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.potion_from"));
        }
    }

    @Nullable
    public BlockPos getJarForTake() {
        for (BlockPos pos : this.FROM_LIST) {
            if (!this.isPositionValidTake(pos)) continue;
            return pos;
        }
        return null;
    }

    public boolean isPositionValidTake(BlockPos p) {
        if (p == null) {
            return false;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(p);
        if (blockEntity instanceof PotionJarTile) {
            PotionJarTile jar = (PotionJarTile)blockEntity;
            return jar.getAmount() >= 100 && this.getJarForStorage(jar.getData()) != null;
        }
        return false;
    }

    @Nullable
    public BlockPos getJarForStorage(PotionContents data) {
        for (BlockPos pos : this.TO_LIST) {
            if (!(this.level.getBlockEntity(pos) instanceof PotionJarTile) || !this.isPositionValidStore(pos, data)) continue;
            return pos;
        }
        return null;
    }

    public boolean isPositionValidStore(BlockPos p, PotionContents data) {
        PotionJarTile jar;
        if (p == null || data == null) {
            return false;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(p);
        return blockEntity instanceof PotionJarTile && (jar = (PotionJarTile)blockEntity).canAccept(data, 100);
    }

    public PotionContents getHeldPotion() {
        return this.heldPotion == null ? PotionContents.EMPTY : this.heldPotion;
    }

    public void setHeldPotion(PotionContents data) {
        this.heldPotion = data;
        this.syncTag();
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    @Override
    public void getTooltip(Consumer<Component> tooltip) {
        super.getTooltip(tooltip);
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.storing_potions", (Object[])new Object[]{this.TO_LIST.size()}));
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.taking_potions", (Object[])new Object[]{this.FROM_LIST.size()}));
    }

    @Override
    public CompoundTag toTag(CompoundTag tag) {
        if (this.heldPotion != null) {
            tag.put("potionData", ANCodecs.encode(PotionContents.CODEC, this.heldPotion));
        }
        tag.putInt("amount", this.amount);
        return super.toTag(tag);
    }

    @Override
    public ItemStack getStackForRender() {
        if (this.heldPotion != null && this.heldPotion != PotionContents.EMPTY) {
            ItemStack render = new ItemStack((ItemLike)Items.POTION);
            render.set(DataComponents.POTION_CONTENTS, (Object)this.heldPotion);
            return render;
        }
        return super.getStackForRender();
    }

    @Override
    public ResourceLocation getRegistryName() {
        return POTION_ID;
    }
}

