/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.pathfinding;

import com.hollingsworth.arsnouveau.common.entity.pathfinding.ModNode;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.pathjobs.AbstractPathJob;
import com.hollingsworth.arsnouveau.common.util.Log;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public final class Pathfinding {
    private static final BlockingQueue<Runnable> jobQueue = new LinkedBlockingDeque<Runnable>();
    private static ThreadPoolExecutor executor;

    public static ThreadPoolExecutor getExecutor() {
        if (executor == null) {
            executor = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, jobQueue, new MinecoloniesThreadFactory());
        }
        return executor;
    }

    public static void shutdown() {
        Pathfinding.getExecutor().shutdownNow();
        jobQueue.clear();
        executor = null;
    }

    private Pathfinding() {
    }

    public static void enqueue(AbstractPathJob job) {
        job.getResult().startJob(Pathfinding.getExecutor());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void debugDraw(double frame, PoseStack matrixStack) {
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void debugDrawNode(ModNode n, float r, float g, float b, PoseStack matrixStack) {
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderDebugText(ModNode n, PoseStack matrixStack) {
    }

    public static class MinecoloniesThreadFactory
    implements ThreadFactory {
        public static int id;

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "AN stolen Minecolonies Pathfinding Worker #" + id++);
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((thread1, throwable) -> Log.getLogger().error("AN stolen Minecolonies Pathfinding Thread errored! ", throwable));
            thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
            return thread;
        }
    }
}

