/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.camera.ICameraMountable;
import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.data.ScryPosData;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class BlankParchmentItem
extends ModItem
implements IScribeable {
    public BlankParchmentItem(Item.Properties properties) {
        super(properties);
    }

    public BlankParchmentItem() {
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        if (pContext.getLevel().isClientSide) {
            return super.useOn(pContext);
        }
        if (pContext.getLevel().getBlockEntity(pContext.getClickedPos()) instanceof ICameraMountable) {
            ItemStack stack = new ItemStack((ItemLike)ItemsRegistry.SCRYER_SCROLL.get());
            stack.set(DataComponentRegistry.SCRY_DATA, (Object)new ScryPosData(pContext.getClickedPos()));
            if (!pContext.getPlayer().addItem(stack)) {
                pContext.getLevel().addFreshEntity((Entity)new ItemEntity(pContext.getLevel(), pContext.getPlayer().getX(), pContext.getPlayer().getY(), pContext.getPlayer().getZ(), stack));
            }
            pContext.getItemInHand().shrink(1);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(pContext);
    }

    @Override
    public boolean onScribe(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack thisStack) {
        ItemStack spellParchment = new ItemStack((ItemLike)ItemsRegistry.SPELL_PARCHMENT.get());
        Item item = spellParchment.getItem();
        if (item instanceof IScribeable) {
            IScribeable scribeable = (IScribeable)item;
            boolean success = scribeable.onScribe(world, pos, player, handIn, spellParchment);
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof ScribesTile) {
                ScribesTile scribesTile = (ScribesTile)blockEntity;
                if (success) {
                    scribesTile.setStack(spellParchment);
                }
            }
            return success;
        }
        return false;
    }
}

