/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.mana.IManaDiscountEquipment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.gui.SpellTooltip;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.data.TomeCasterData;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CasterTome
extends ModItem
implements ICasterTool,
IManaDiscountEquipment {
    public CasterTome(Item.Properties properties) {
        super(properties);
    }

    public CasterTome() {
        super(ItemsRegistry.defaultItemProperties().component(DataComponentRegistry.TOME_CASTER, (Object)new TomeCasterData()));
    }

    @Override
    public boolean onScribe(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack tableStack) {
        return player.isCreative() && ICasterTool.super.onScribe(world, pos, player, handIn, tableStack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        AbstractCaster caster = this.getSpellCaster(stack);
        Spell spell = caster.getSpell();
        return caster.castSpell(worldIn, (LivingEntity)playerIn, handIn, (Component)Component.empty(), spell);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        AbstractCaster caster = this.getSpellCaster(stack);
        if (((Boolean)Config.GLYPH_TOOLTIPS.get()).booleanValue() || Screen.hasShiftDown()) {
            if (caster.isSpellHidden()) {
                tooltip2.add((Component)Component.literal((String)caster.getHiddenRecipe()).withStyle(Style.EMPTY.withFont(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"alt")).withColor(ChatFormatting.GOLD)));
            }
            if (!caster.getFlavorText().isEmpty()) {
                tooltip2.add((Component)Component.literal((String)caster.getFlavorText()).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE)));
            }
        } else {
            this.getInformation(stack, context, tooltip2, flagIn);
        }
        tooltip2.add((Component)Component.translatable((String)"tooltip.ars_nouveau.caster_tome"));
        super.appendHoverText(stack, context, tooltip2, flagIn);
    }

    @Override
    public int getManaDiscount(ItemStack i, Spell spell) {
        return spell.getCost() / 2;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        AbstractCaster caster = this.getSpellCaster(pStack);
        if (!Screen.hasShiftDown() && ((Boolean)Config.GLYPH_TOOLTIPS.get()).booleanValue() && !caster.isSpellHidden() && !caster.getSpell().isEmpty()) {
            return Optional.of(new SpellTooltip(caster));
        }
        return Optional.empty();
    }
}

