/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.block.IPedestalMachine;
import com.hollingsworth.arsnouveau.api.scrying.TagScryer;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.ritual.RitualScrying;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DowsingRod
extends ModItem {
    public DowsingRod(Item.Properties properties) {
        super(properties);
        this.withTooltip((Component)Component.translatable((String)"tooltip.ars_nouveau.dowsing_rod"));
    }

    public DowsingRod() {
        this(ItemsRegistry.defaultItemProperties().durability(4));
    }

    public InteractionResult useOn(UseOnContext pContext) {
        BlockEntity blockEntity;
        if (pContext.getLevel() instanceof ServerLevel && (blockEntity = pContext.getLevel().getBlockEntity(pContext.getClickedPos())) instanceof IPedestalMachine) {
            IPedestalMachine ipm = (IPedestalMachine)blockEntity;
            ipm.lightPedestal(pContext.getLevel());
            return InteractionResult.SUCCESS;
        }
        return super.useOn(pContext);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack heldStack = pPlayer.getItemInHand(pUsedHand);
        heldStack.setDamageValue(pPlayer.getItemInHand(pUsedHand).getDamageValue() + 1);
        if (heldStack.getDamageValue() >= this.getMaxDamage(heldStack)) {
            heldStack.shrink(1);
        }
        if (!pLevel.isClientSide) {
            pPlayer.addEffect(new MobEffectInstance(ModPotions.MAGIC_FIND_EFFECT, 1200));
            TagScryer tagScryer = new TagScryer(BlockTagProvider.DOWSING_ROD);
            RitualScrying.grantScrying((ServerPlayer)pPlayer, 1200, tagScryer);
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }
}

