/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class Glyph
extends ModItem {
    public AbstractSpellPart spellPart;

    public Glyph(AbstractSpellPart part) {
        super(new Item.Properties());
        this.spellPart = part;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        if (worldIn.isClientSide) {
            return super.use(worldIn, playerIn, handIn);
        }
        if (!Config.isGlyphEnabled(this.spellPart.getRegistryName())) {
            playerIn.sendSystemMessage((Component)Component.translatable((String)"ars_nouveau.spell.disabled"));
            return super.use(worldIn, playerIn, handIn);
        }
        ANPlayerDataCap playerDataCap = CapabilityRegistry.getPlayerDataCap((LivingEntity)playerIn);
        if (playerDataCap != null) {
            if (playerDataCap.knowsGlyph(this.spellPart) || GlyphRegistry.getDefaultStartingSpells().contains(this.spellPart)) {
                playerIn.sendSystemMessage((Component)Component.literal((String)"You already know this spell!"));
                return super.use(worldIn, playerIn, handIn);
            }
            if (playerDataCap.unlockGlyph(this.spellPart)) {
                CapabilityRegistry.EventHandler.syncPlayerCap(playerIn);
                playerIn.getItemInHand(handIn).shrink(1);
                playerIn.sendSystemMessage((Component)Component.literal((String)("Unlocked " + this.spellPart.getName())));
            }
        }
        return super.use(worldIn, playerIn, handIn);
    }

    @NotNull
    public Component getName(@NotNull ItemStack pStack) {
        return Component.translatable((String)"ars_nouveau.glyph_of", (Object[])new Object[]{this.spellPart.getLocaleName()});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        if (this.spellPart == null) {
            return;
        }
        if (!Config.isGlyphEnabled(this.spellPart.getRegistryName())) {
            tooltip2.add((Component)Component.translatable((String)"tooltip.ars_nouveau.glyph_disabled"));
        } else if (this.spellPart != null) {
            tooltip2.add((Component)Component.translatable((String)"tooltip.ars_nouveau.glyph_level", (Object[])new Object[]{this.spellPart.getConfigTier().value}).setStyle(Style.EMPTY.withColor(ChatFormatting.BLUE)));
            tooltip2.add((Component)Component.translatable((String)"ars_nouveau.schools"));
            for (SpellSchool s : this.spellPart.spellSchools) {
                tooltip2.add(s.getTextComponent());
            }
        }
        if (Minecraft.getInstance().player == null) {
            return;
        }
        ANPlayerDataCap playerDataCap = CapabilityRegistry.getPlayerDataCap((LivingEntity)Minecraft.getInstance().player);
        if (playerDataCap != null) {
            if (playerDataCap.knowsGlyph(this.spellPart) || GlyphRegistry.getDefaultStartingSpells().contains(this.spellPart)) {
                tooltip2.add((Component)Component.translatable((String)"tooltip.ars_nouveau.glyph_known").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN)));
            } else {
                tooltip2.add((Component)Component.translatable((String)"tooltip.ars_nouveau.glyph_unknown").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED)));
            }
        }
        tooltip2.add((Component)Component.translatable((String)" "));
        if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)Minecraft.getInstance().options.keyShift.getKey().getValue())) {
            tooltip2.add(this.spellPart.getBookDescLang());
        } else {
            tooltip2.add((Component)Component.translatable((String)"tooltip.ars_nouveau.hold_shift", (Object[])new Object[]{Minecraft.getInstance().options.keyShift.getKey().getDisplayName()}));
        }
    }
}

