/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.data;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.entity.ChangeableBehavior;
import com.hollingsworth.arsnouveau.api.item.NBTComponent;
import com.hollingsworth.arsnouveau.api.registry.BehaviorRegistry;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.block.Block;

public class StarbuncleCharmData
implements NBTComponent<StarbuncleCharmData>,
TooltipProvider {
    public static MapCodec<StarbuncleCharmData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(StarbuncleCharmData::getName), (App)Codec.STRING.optionalFieldOf("color", (Object)DyeColor.ORANGE.getName()).forGetter(StarbuncleCharmData::getColor), (App)BlockPos.CODEC.optionalFieldOf("bed").forGetter(StarbuncleCharmData::getBedPos), (App)ItemStack.CODEC.optionalFieldOf("cosmetic").forGetter(StarbuncleCharmData::getCosmetic), (App)ResourceLocation.CODEC.optionalFieldOf("behavior", (Object)StarbyTransportBehavior.TRANSPORT_ID).forGetter(StarbuncleCharmData::getBehavior), (App)CompoundTag.CODEC.optionalFieldOf("behaviorTag", (Object)new CompoundTag()).forGetter(StarbuncleCharmData::getBehaviorTag), (App)Codec.STRING.optionalFieldOf("adopter", (Object)"").forGetter(StarbuncleCharmData::getAdopter), (App)Codec.STRING.optionalFieldOf("bio", (Object)"").forGetter(StarbuncleCharmData::getBio)).apply((Applicative)instance, StarbuncleCharmData::new));
    public static StreamCodec<RegistryFriendlyByteBuf, StarbuncleCharmData> STREAM_CODEC = ANCodecs.composite(ComponentSerialization.STREAM_CODEC.apply(ByteBufCodecs::optional), StarbuncleCharmData::getName, ByteBufCodecs.STRING_UTF8, StarbuncleCharmData::getColor, BlockPos.STREAM_CODEC.apply(ByteBufCodecs::optional), StarbuncleCharmData::getBedPos, ItemStack.STREAM_CODEC.apply(ByteBufCodecs::optional), StarbuncleCharmData::getCosmetic, ResourceLocation.STREAM_CODEC, StarbuncleCharmData::getBehavior, ByteBufCodecs.COMPOUND_TAG, StarbuncleCharmData::getBehaviorTag, ByteBufCodecs.STRING_UTF8, StarbuncleCharmData::getAdopter, ByteBufCodecs.STRING_UTF8, StarbuncleCharmData::getBio, StarbuncleCharmData::new);
    private final Optional<Component> name;
    private final String color;
    private final Optional<ItemStack> cosmetic;
    private final Block pathBlock;
    private final Optional<BlockPos> bedPos;
    private final ResourceLocation behavior;
    private final CompoundTag behaviorTag;
    private final String adopter;
    private final String bio;

    public StarbuncleCharmData(Optional<Component> name, String color, Optional<BlockPos> bedPos, Optional<ItemStack> cosmetic, ResourceLocation behavior, CompoundTag behaviorTag, String adopter, String bio) {
        this(name, color, null, bedPos, cosmetic, behavior, behaviorTag, adopter, bio);
    }

    public StarbuncleCharmData(Optional<Component> name, String color, Block pathBlock, Optional<BlockPos> bedPos, Optional<ItemStack> cosmetic, ResourceLocation behavior, CompoundTag behaviorTag, String adopter, String bio) {
        this.name = name;
        this.color = color;
        this.cosmetic = cosmetic;
        this.pathBlock = pathBlock;
        this.bedPos = bedPos;
        this.behavior = behavior;
        this.adopter = adopter;
        this.bio = bio;
        this.behaviorTag = behaviorTag;
    }

    public StarbuncleCharmData() {
        this(Optional.empty(), DyeColor.ORANGE.getName(), null, Optional.empty(), Optional.empty(), StarbyTransportBehavior.TRANSPORT_ID, new CompoundTag(), "", "");
    }

    @Override
    public Codec<StarbuncleCharmData> getCodec() {
        return CODEC.codec();
    }

    public Mutable mutable() {
        return new Mutable(this.name.orElse(null), this.color, this.cosmetic.orElse(null), this.pathBlock, this.bedPos.orElse(null), this.behavior, this.behaviorTag, this.adopter, this.bio);
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltip2, TooltipFlag pTooltipFlag) {
        if (!this.name.isEmpty()) {
            tooltip2.accept(this.name.get());
        }
        if (this.adopter != null) {
            tooltip2.accept((Component)Component.translatable((String)"ars_nouveau.adopter", (Object[])new Object[]{this.adopter}).withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
        }
        if (this.bio != null) {
            tooltip2.accept((Component)Component.literal((String)this.bio).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_PURPLE)));
        }
        if (this.behavior != null) {
            try {
                ChangeableBehavior behavior = BehaviorRegistry.create(this.behavior, (Entity)new Starbuncle(ArsNouveau.proxy.getClientWorld(), true), this.behaviorTag);
                if (behavior != null) {
                    behavior.getTooltip(tooltip2);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StarbuncleCharmData that = (StarbuncleCharmData)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.color, that.color) && Objects.equals(this.pathBlock, that.pathBlock) && Objects.equals(this.bedPos, that.bedPos) && Objects.equals(this.behavior, that.behavior) && Objects.equals(this.adopter, that.adopter) && Objects.equals(this.bio, that.bio) && ItemStack.isSameItemSameComponents((ItemStack)this.cosmetic.orElse(ItemStack.EMPTY), (ItemStack)that.cosmetic.orElse(ItemStack.EMPTY)) && Objects.equals(this.behaviorTag, that.behaviorTag);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.color, this.cosmetic, this.pathBlock, this.bedPos, this.behavior, this.adopter, this.bio, this.behaviorTag);
    }

    public String getColor() {
        return this.color;
    }

    public Optional<Component> getName() {
        return this.name;
    }

    public Optional<ItemStack> getCosmetic() {
        return this.cosmetic;
    }

    public Block getPathBlock() {
        return this.pathBlock;
    }

    public Optional<BlockPos> getBedPos() {
        return this.bedPos;
    }

    public ResourceLocation getBehavior() {
        return this.behavior;
    }

    public CompoundTag getBehaviorTag() {
        return this.behaviorTag;
    }

    public String getAdopter() {
        return this.adopter;
    }

    public String getBio() {
        return this.bio;
    }

    public static class Mutable {
        public Component name;
        public String color;
        public ItemStack cosmetic;
        public Block pathBlock;
        public BlockPos bedPos;
        public ResourceLocation behaviorKey;
        public CompoundTag behaviorTag;
        public String adopter;
        public String bio;

        public Mutable(Component name, String color, ItemStack cosmetic, Block pathBlock, BlockPos bedPos, ResourceLocation behaviorKey, CompoundTag behaviorTag, String adopter, String bio) {
            this.name = name;
            this.color = color;
            this.cosmetic = cosmetic;
            this.behaviorKey = behaviorKey;
            this.pathBlock = pathBlock;
            this.bedPos = bedPos;
            this.behaviorTag = behaviorTag;
            this.adopter = adopter;
            this.bio = bio;
        }

        public Mutable() {
            this(null, DyeColor.ORANGE.getName(), null, null, null, StarbyTransportBehavior.TRANSPORT_ID, new CompoundTag(), "", "");
        }

        public StarbuncleCharmData immutable() {
            return new StarbuncleCharmData(Optional.ofNullable(this.name), this.color, this.pathBlock, Optional.ofNullable(this.bedPos), Optional.ofNullable(this.cosmetic), this.behaviorKey, this.behaviorTag, this.adopter, this.bio);
        }
    }
}

