/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.data;

import com.hollingsworth.arsnouveau.common.crafting.recipes.CheatSerializer;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;

public record WarpScrollData(BlockPos pos, String dimension, Vec2 rotation, boolean crossDim) implements TooltipProvider
{
    public static final Codec<WarpScrollData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(WarpScrollData::pos), (App)Codec.STRING.optionalFieldOf("dimension", null).forGetter(WarpScrollData::dimension), (App)ANCodecs.VEC2.fieldOf("rotation").forGetter(WarpScrollData::rotation), (App)Codec.BOOL.optionalFieldOf("crossDim", (Object)false).forGetter(WarpScrollData::crossDim)).apply((Applicative)instance, WarpScrollData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WarpScrollData> STREAM_CODEC = CheatSerializer.create(CODEC);

    public WarpScrollData setPos(@Nullable BlockPos pos, @Nullable String dimension) {
        return new WarpScrollData(pos, dimension, this.rotation, this.crossDim);
    }

    public WarpScrollData setRotation(Vec2 rotation) {
        return new WarpScrollData(this.pos, this.dimension, rotation, this.crossDim);
    }

    public boolean canTeleportWithDim(String dimension) {
        return this.dimension.equals(dimension) || this.crossDim;
    }

    public boolean canTeleportWithDim(Level level) {
        return this.canTeleportWithDim(level.dimension().location().toString());
    }

    public boolean isValid() {
        return this.pos != null && this.dimension != null && this.rotation != null;
    }

    public void addToTooltip(Item.TooltipContext pContext, Consumer<Component> pTooltipAdder, TooltipFlag pTooltipFlag) {
        String dimId;
        if (!this.isValid()) {
            pTooltipAdder.accept((Component)Component.translatable((String)"ars_nouveau.warp_scroll.no_location"));
            return;
        }
        pTooltipAdder.accept((Component)Component.translatable((String)"ars_nouveau.position", (Object[])new Object[]{this.pos.getX(), this.pos.getY(), this.pos.getZ()}));
        if (this.crossDim && (dimId = this.dimension()) != null) {
            ResourceLocation resourceLocation = ResourceLocation.tryParse((String)dimId);
            pTooltipAdder.accept((Component)Component.translatable((String)(resourceLocation.getPath() + "." + resourceLocation.getNamespace() + ".name")));
        }
        if (!((Boolean)ServerConfig.ENABLE_WARP_PORTALS.get()).booleanValue()) {
            pTooltipAdder.accept((Component)Component.translatable((String)"ars_nouveau.warp_scroll.disabled_warp_portal").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarpScrollData that = (WarpScrollData)o;
        return this.crossDim == that.crossDim && Objects.equals(this.pos, that.pos) && Objects.equals(this.rotation, that.rotation) && Objects.equals(this.dimension, that.dimension);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pos, this.dimension, this.rotation, this.crossDim);
    }
}

