/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mob_jar;

import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.MultiInsertReference;
import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.api.util.InvUtil;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class AllayBehavior
extends JarBehavior<Allay> {
    @Override
    public void use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, MobJarTile tile) {
        super.use(state, world, pos, player, handIn, hit, tile);
    }

    @Override
    public void tick(MobJarTile tile) {
        super.tick(tile);
        if (tile.getLevel().isClientSide) {
            Allay allay = (Allay)this.entityFromJar(tile);
            ++allay.tickCount;
            allay.holdingItemAnimationTicks0 = allay.holdingItemAnimationTicks;
            allay.holdingItemAnimationTicks = allay.hasItemInHand() ? Mth.clamp((float)(allay.holdingItemAnimationTicks + 1.0f), (float)0.0f, (float)5.0f) : Mth.clamp((float)(allay.holdingItemAnimationTicks - 1.0f), (float)0.0f, (float)5.0f);
            if (allay.isDancing()) {
                allay.dancingAnimationTicks += 1.0f;
                allay.spinningAnimationTicks0 = allay.spinningAnimationTicks;
                allay.spinningAnimationTicks = allay.isSpinning() ? (allay.spinningAnimationTicks += 1.0f) : (allay.spinningAnimationTicks -= 1.0f);
                allay.spinningAnimationTicks = Mth.clamp((float)allay.spinningAnimationTicks, (float)0.0f, (float)15.0f);
            } else {
                allay.dancingAnimationTicks = 0.0f;
                allay.spinningAnimationTicks = 0.0f;
                allay.spinningAnimationTicks0 = 0.0f;
            }
        } else {
            Level level = tile.getLevel();
            if (level.getGameTime() % 40L == 0L) {
                Allay allay = (Allay)this.entityFromJar(tile);
                ItemStack heldStack = allay.getItemInHand(InteractionHand.MAIN_HAND);
                List<FilterableItemHandler> inventories = InvUtil.adjacentInventories(level, tile.getBlockPos());
                if (inventories.isEmpty()) {
                    return;
                }
                if (heldStack.getItem() instanceof ItemScroll) {
                    for (FilterableItemHandler filterableItemHandler : inventories) {
                        filterableItemHandler.addFilterScroll(heldStack);
                    }
                }
                InventoryManager manager = new InventoryManager(inventories);
                for (ItemEntity entity : level.getEntitiesOfClass(ItemEntity.class, new AABB(tile.getBlockPos()).inflate(5.0))) {
                    MultiInsertReference reference;
                    if (!entity.isAlive() || entity.getItem().isEmpty() || !heldStack.isEmpty() && !(heldStack.getItem() instanceof ItemScroll) && !ItemStack.isSameItem((ItemStack)entity.getItem(), (ItemStack)heldStack) || (reference = manager.insertStackWithReference(entity.getItem())).isEmpty()) continue;
                    ItemStack remainder = reference.getRemainder();
                    entity.setItem(remainder);
                    level.playSound(null, tile.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.8f, 1.0f);
                    return;
                }
            }
        }
    }

    @Override
    public boolean shouldUsePartialTicks(MobJarTile pBlockEntity) {
        return true;
    }

    @Override
    public Vec3 translate(MobJarTile pBlockEntity) {
        return new Vec3(0.0, 0.2, 0.0);
    }

    @Override
    public void getTooltip(MobJarTile tile, List<Component> tooltips) {
        super.getTooltip(tile, tooltips);
        Allay allay = (Allay)this.entityFromJar(tile);
        Item item = allay.getMainHandItem().getItem();
        if (item instanceof ItemScroll) {
            ItemScroll scroll = (ItemScroll)item;
            scroll.appendHoverText(allay.getMainHandItem(), Item.TooltipContext.of((Level)tile.getLevel()), tooltips, (TooltipFlag)TooltipFlag.Default.NORMAL);
        }
    }
}

