/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.common.capability.ManaData;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.setup.registry.AttachmentsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PacketUpdateMana
extends AbstractPacket {
    CompoundTag tag;
    public static final CustomPacketPayload.Type<PacketUpdateMana> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("update_mana"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateMana> CODEC = StreamCodec.ofMember(PacketUpdateMana::toBytes, PacketUpdateMana::new);

    public PacketUpdateMana(CompoundTag tag) {
        this.tag = tag;
    }

    public PacketUpdateMana(RegistryFriendlyByteBuf buf) {
        this.tag = buf.readNbt();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.tag);
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        ManaData data = new ManaData();
        data.deserializeNBT((HolderLookup.Provider)player.registryAccess(), this.tag);
        player.setData(AttachmentsRegistry.MANA_ATTACHMENT, (Object)data);
        ManaCap cap = CapabilityRegistry.getMana((LivingEntity)ArsNouveau.proxy.getPlayer());
        if (cap != null) {
            cap.setManaData(data);
        }
        ClientInfo.reservedOverlayMana = data.getReservedMana();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

