/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.container.AbstractStorageTerminalScreen;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class ServerToClientStoragePacket
extends AbstractPacket {
    public CompoundTag tag;
    public static final CustomPacketPayload.Type<ServerToClientStoragePacket> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("server_to_client_storage"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerToClientStoragePacket> CODEC = StreamCodec.ofMember(ServerToClientStoragePacket::toBytes, ServerToClientStoragePacket::new);

    public ServerToClientStoragePacket(CompoundTag tag) {
        this.tag = tag;
    }

    public ServerToClientStoragePacket(RegistryFriendlyByteBuf pb) {
        this.tag = pb.readNbt();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf pb) {
        pb.writeNbt((Tag)this.tag);
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        Screen screen = minecraft.screen;
        if (screen instanceof AbstractStorageTerminalScreen) {
            AbstractStorageTerminalScreen terminalScreen = (AbstractStorageTerminalScreen)screen;
            terminalScreen.receive(this.tag);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

