/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class RitualAwakening
extends AbstractRitual {
    EntityType<? extends LivingEntity> entity = null;
    BlockPos foundPos;

    public void destroyTree(Level world, Set<BlockPos> set) {
        for (BlockPos p : set) {
            BlockUtil.destroyBlockSafelyWithoutSound(world, p, false);
        }
    }

    public void findTargets(Level world) {
        for (BlockPos p : BlockPos.withinManhattan((BlockPos)this.getPos(), (int)3, (int)1, (int)3)) {
            Set<BlockPos> blazing = SpellUtil.DFSBlockstates(world, p, 350, b -> b.getBlock() == BlockRegistry.BLAZING_LOG.get() || b.getBlock() == BlockRegistry.BLAZING_LEAVES.get());
            if (blazing.size() >= 50) {
                this.entity = (EntityType)ModEntities.ENTITY_BLAZING_WEALD.get();
                this.foundPos = p;
                this.destroyTree(world, blazing);
                return;
            }
            Set<BlockPos> flourishing = SpellUtil.DFSBlockstates(world, p, 350, b -> b.getBlock() == BlockRegistry.FLOURISHING_LOG.get() || b.getBlock() == BlockRegistry.FLOURISHING_LEAVES.get());
            if (flourishing.size() >= 50) {
                this.entity = (EntityType)ModEntities.ENTITY_FLOURISHING_WEALD.get();
                this.foundPos = p;
                this.destroyTree(world, flourishing);
                return;
            }
            Set<BlockPos> vexing = SpellUtil.DFSBlockstates(world, p, 350, b -> b.getBlock() == BlockRegistry.VEXING_LOG.get() || b.getBlock() == BlockRegistry.VEXING_LEAVES.get());
            if (vexing.size() >= 50) {
                this.entity = (EntityType)ModEntities.ENTITY_VEXING_WEALD.get();
                this.foundPos = p;
                this.destroyTree(world, vexing);
                return;
            }
            Set<BlockPos> cascading = SpellUtil.DFSBlockstates(world, p, 350, b -> b.getBlock() == BlockRegistry.CASCADING_LOG.get() || b.getBlock() == BlockRegistry.CASCADING_LEAVE.get());
            if (cascading.size() >= 50) {
                this.entity = (EntityType)ModEntities.ENTITY_CASCADING_WEALD.get();
                this.foundPos = p;
                this.destroyTree(world, cascading);
                return;
            }
            if (world.getBlockState(p).getBlock() != Blocks.BUDDING_AMETHYST) continue;
            world.setBlock(p, Blocks.AIR.defaultBlockState(), 3);
            this.entity = (EntityType)ModEntities.AMETHYST_GOLEM.get();
            this.foundPos = p;
            return;
        }
    }

    @Override
    protected void tick() {
        Level world = this.getWorld();
        if (world.isClientSide) {
            BlockPos pos = this.getPos();
            for (int i2 = 0; i2 < 10; ++i2) {
                Vec3 particlePos = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).add(0.5, 0.0, 0.5);
                particlePos = particlePos.add(ParticleUtil.pointInSphere().multiply(5.0, 5.0, 5.0));
                world.addParticle(ParticleLineData.createData(this.getCenterColor()), particlePos.x(), particlePos.y(), particlePos.z(), (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
            }
        }
        if (!world.isClientSide && world.getGameTime() % 20L == 0L) {
            if (this.isBookwyrms()) {
                int numBookwyrms;
                int progress = this.getProgress();
                if (progress < (numBookwyrms = this.getConsumedItems().stream().filter(i -> i.getItem() instanceof WritableBookItem).mapToInt(ItemStack::getCount).sum())) {
                    ItemStack charm = new ItemStack(ItemsRegistry.BOOKWYRM_CHARM);
                    ItemEntity itemEntity = new ItemEntity(world, (double)this.getPos().getX() + 0.5, (double)(this.getPos().getY() + 1), (double)this.getPos().getZ() + 0.5, charm);
                    float range = 0.1f;
                    itemEntity.setDeltaMovement(ParticleUtil.inRange(-range, range), ParticleUtil.inRange(0.4, 0.6), ParticleUtil.inRange(-range, range));
                    this.getWorld().playSound(null, this.getPos(), SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS, 1.0f, 1.0f);
                    world.addFreshEntity((Entity)itemEntity);
                } else {
                    this.setFinished();
                }
            } else if (this.getProgress() > 5) {
                this.findTargets(world);
                if (this.entity != null) {
                    ParticleUtil.spawnPoof((ServerLevel)world, this.foundPos);
                    LivingEntity walker = (LivingEntity)this.entity.create(world);
                    walker.setPos((double)this.foundPos.getX() + 0.5, (double)this.foundPos.getY(), (double)this.foundPos.getZ() + 0.5);
                    world.addFreshEntity((Entity)walker);
                    this.setFinished();
                }
            }
            this.incrementProgress();
        }
    }

    public boolean isBookwyrms() {
        return this.getConsumedItems().stream().anyMatch(i -> i.getItem() instanceof WritableBookItem);
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        return super.canConsumeItem(stack) || stack.getItem() instanceof WritableBookItem;
    }

    @Override
    public ParticleColor getCenterColor() {
        return new ParticleColor(50, 200, 50);
    }

    @Override
    public String getLangName() {
        return "Awakening";
    }

    @Override
    public String getLangDescription() {
        return "Awakens nearby Archwood trees into Weald Walkers and Budding Amethyst into Amethyst Golems. Weald Walkers can be given a position in the world to guard against hostile mobs. They will heal over time, and turn into Weald Waddlers if they die. To create a Weald Walker, perform this ritual near the base of an Archwood Tree. Augmenting with Book and Quills will create Bookwyrm Charms.";
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix(RitualLib.AWAKENING);
    }
}

