/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.EntityRitualProjectile;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class RitualDig
extends AbstractRitual {
    @Override
    public void onStart(@Nullable Player player) {
        super.onStart(player);
        if (this.tile == null) {
            return;
        }
        EntityRitualProjectile ritualProjectile = new EntityRitualProjectile(this.getWorld(), this.getPos().above());
        ritualProjectile.setPos(ritualProjectile.getX() + 0.5, ritualProjectile.getY(), ritualProjectile.getZ() + 0.5);
        ritualProjectile.tilePos = this.getPos();
        this.getWorld().addFreshEntity((Entity)ritualProjectile);
    }

    public boolean canBlockBeHarvested(BlockPos pos) {
        return this.getWorld().getBlockState(pos).getDestroySpeed((BlockGetter)this.getWorld(), pos) >= 0.0f && SpellUtil.isCorrectHarvestLevel(5, this.getWorld().getBlockState(pos));
    }

    public void breakBlock(BlockPos pos) {
        if (!this.canBlockBeHarvested(pos) || !BlockUtil.destroyRespectsClaim((Entity)ANFakePlayer.getPlayer((ServerLevel)this.getWorld()), this.getWorld(), pos)) {
            return;
        }
        BlockState state = this.getWorld().getBlockState(pos);
        ItemStack stack = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
        state.getBlock().playerDestroy(this.getWorld(), (Player)ANFakePlayer.getPlayer((ServerLevel)this.getWorld()), pos, this.getWorld().getBlockState(pos), this.getWorld().getBlockEntity(pos), stack);
        BlockUtil.destroyBlockSafely(this.getWorld(), pos, false, (LivingEntity)ANFakePlayer.getPlayer((ServerLevel)this.getWorld()));
    }

    @Override
    public void tick() {
        Level world = this.tile.getLevel();
        if (world.getGameTime() % 20L == 0L && !world.isClientSide) {
            BlockPos pos = this.tile.getBlockPos().north().below(this.getContext().progress);
            if (world.isOutsideBuildHeight(pos)) {
                this.onEnd();
                return;
            }
            this.breakBlock(pos);
            this.breakBlock(pos.south().south());
            this.breakBlock(pos.south().east());
            this.breakBlock(pos.south().west());
            ++this.getContext().progress;
        }
    }

    @Override
    public ParticleColor getCenterColor() {
        return new ParticleColor(this.rand.nextInt(50), this.rand.nextInt(255), this.rand.nextInt(20));
    }

    @Override
    public String getLangDescription() {
        return "Digs four adjacent holes to bedrock, dropping any blocks.";
    }

    @Override
    public String getLangName() {
        return "Burrowing";
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix(RitualLib.DIG);
    }
}

