/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.entity.WildenChimera;
import com.hollingsworth.arsnouveau.common.entity.WildenGuardian;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.entity.WildenStalker;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class RitualWildenSummoning
extends AbstractRitual {
    @Override
    protected void tick() {
        WildenChimera.spawnPhaseParticles(this.getPos().above(), this.getWorld(), 1);
        if (this.getWorld().getGameTime() % 20L == 0L) {
            this.incrementProgress();
        }
        if (this.getWorld().getGameTime() % 60L == 0L && !this.getWorld().isClientSide) {
            if (!this.isBossSpawn()) {
                int wild = this.rand.nextInt(3);
                BlockPos summonPos = this.getPos().above().east(this.rand.nextInt(3) - this.rand.nextInt(6)).north(this.rand.nextInt(3) - this.rand.nextInt(6));
                Monster mobEntity = switch (wild) {
                    case 0 -> new WildenStalker(this.getWorld());
                    case 1 -> new WildenGuardian(this.getWorld());
                    default -> new WildenHunter(this.getWorld());
                };
                this.summon((Mob)mobEntity, summonPos);
                if (this.getProgress() >= 15) {
                    this.setFinished();
                }
            } else if (this.getProgress() >= 8) {
                WildenChimera chimera = new WildenChimera(this.getWorld());
                this.summon((Mob)chimera, this.getPos().above());
                for (BlockPos b : BlockPos.betweenClosed((BlockPos)this.getPos().east(5).north(5).above(), (BlockPos)this.getPos().west(5).south(5).above(5))) {
                    if (!EventHooks.canEntityGrief((Level)this.getWorld(), (Entity)chimera) || this.getWorld().getBlockState(b).getDestroySpeed((BlockGetter)this.getWorld(), b) < 0.0f || !SpellUtil.isCorrectHarvestLevel(4, this.getWorld().getBlockState(b))) continue;
                    BlockUtil.destroyBlockSafelyWithoutSound(this.getWorld(), b, true);
                }
                this.setFinished();
            }
        }
    }

    public boolean isBossSpawn() {
        return this.didConsumeItem(ItemsRegistry.WILDEN_HORN) && this.didConsumeItem(ItemsRegistry.WILDEN_WING) && this.didConsumeItem(ItemsRegistry.WILDEN_SPIKE);
    }

    public void summon(Mob mob, BlockPos pos) {
        mob.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        mob.level.addFreshEntity((Entity)mob);
    }

    @Override
    public String getLangName() {
        return "Summon Wilden";
    }

    @Override
    public String getLangDescription() {
        return "Without augments, this ritual will summon a random variety of Wilden monsters for a short duration. When augmented with a Wilden Spike, Wilden Horn, and a Wilden Wing, this ritual will summon the Wilden Chimera, a challenging and destructive monster. Note: If summoning the chimera, this ritual will destroy blocks around the brazier.";
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        return stack.is(ItemTagProvider.WILDEN_DROP_TAG);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix(RitualLib.WILDEN_SUMMON);
    }
}

