/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.item.inv.ExtractedStack;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.LootUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.block.IntangibleAirBlock;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import com.hollingsworth.arsnouveau.common.util.HolderHelper;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class EffectExchange
extends AbstractEffect {
    public static EffectExchange INSTANCE = new EffectExchange();

    private EffectExchange() {
        super(GlyphLib.EffectExchangeID, "Exchange");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        LivingEntity living;
        Entity entity = rayTraceResult.getEntity();
        Vec3 origLoc = shooter.position;
        if (!EventHooks.onEnderTeleport((LivingEntity)shooter, (double)entity.getX(), (double)entity.getY(), (double)entity.getZ()).isCanceled()) {
            shooter.teleportTo(entity.getX(), entity.getY(), entity.getZ());
        }
        if (!(entity instanceof LivingEntity) || !EventHooks.onEnderTeleport((LivingEntity)(living = (LivingEntity)entity), (double)origLoc.x(), (double)origLoc.y(), (double)origLoc.z()).isCanceled()) {
            entity.teleportTo(origLoc.x(), origLoc.y(), origLoc.z());
        }
    }

    @Override
    public void onResolveBlock(BlockHitResult result, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, result.getBlockPos(), result, spellStats.getAoeMultiplier(), spellStats.getBuffCount(AugmentPierce.INSTANCE));
        BlockState origState = world.getBlockState(result.getBlockPos());
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)world);
        Block firstBlock = null;
        InventoryManager manager = spellContext.getCaster().getInvManager();
        for (BlockPos pos1 : posList) {
            Item item;
            BlockState state = world.getBlockState(pos1);
            if (!this.canBlockBeHarvested(spellStats, world, pos1) || origState.getBlock() != state.getBlock() || !world.getBlockState(pos1).isAir() && world.getBlockState(pos1).getBlock() instanceof IntangibleAirBlock || !BlockUtil.destroyRespectsClaim((Entity)this.getPlayer(shooter, (ServerLevel)world), world, pos1)) continue;
            Block finalFirstBlock = firstBlock;
            ExtractedStack extractedStack = spellStats.isRandomized() ? manager.extractRandomItem(i -> i.getItem() instanceof BlockItem, 1) : manager.extractItem(i -> {
                Item patt0$temp = i.getItem();
                if (patt0$temp instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)patt0$temp;
                    if (finalFirstBlock == null) {
                        return true;
                    }
                    return blockItem.getBlock() == finalFirstBlock;
                }
                return false;
            }, 1);
            if (extractedStack.isEmpty()) continue;
            if (firstBlock == null && (item = extractedStack.stack.getItem()) instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                firstBlock = blockItem.getBlock();
            }
            this.attemptPlace(extractedStack.getStack(), world, pos1, result, shooter, (Player)fakePlayer, spellContext, resolver);
            extractedStack.replaceAndReturnOrDrop(extractedStack.getStack(), world, shooter.getOnPos());
        }
    }

    public void attemptPlace(ItemStack stack, Level world, BlockPos pos1, BlockHitResult result, LivingEntity shooter, Player fakePlayer, SpellContext spellContext, SpellResolver resolver) {
        Player player;
        BlockItem item = (BlockItem)stack.getItem();
        ItemStack tool = LootUtil.getDefaultFakeTool();
        tool.enchant(HolderHelper.unwrap(world, Enchantments.SILK_TOUCH), 1);
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, stack);
        BlockPlaceContext context = BlockPlaceContext.at((BlockPlaceContext)new BlockPlaceContext(new UseOnContext(fakePlayer, InteractionHand.MAIN_HAND, result)), (BlockPos)pos1.relative(result.getDirection().getOpposite()), (Direction)result.getDirection());
        BlockState placeState = item.getBlock().getStateForPlacement(context);
        if (placeState != null && placeState.getBlock() == world.getBlockState(pos1).getBlock()) {
            return;
        }
        if (!BlockUtil.breakExtraBlock((ServerLevel)world, pos1, tool, shooter.getUUID(), true)) {
            return;
        }
        if (placeState == null) {
            return;
        }
        world.setBlock(pos1, placeState, 3);
        item.getBlock().setPlacedBy(world, pos1, placeState, shooter, stack);
        BlockItem.updateCustomBlockEntityTag((Level)world, (Player)(shooter instanceof Player ? (player = (Player)shooter) : fakePlayer), (BlockPos)pos1, (ItemStack)stack);
        stack.shrink(1);
        ShapersFocus.tryPropagateBlockSpell(new BlockHitResult(new Vec3((double)pos1.getX(), (double)pos1.getY(), (double)pos1.getZ()), result.getDirection(), pos1, false), world, (Entity)shooter, spellContext, resolver);
    }

    @Override
    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentPierce.INSTANCE, AugmentAOE.INSTANCE, AugmentRandomize.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "When used on blocks, exchanges the blocks in the players hotbar for the blocks hit as if they were mined with silk touch. Can be augmented with AOE, and Amplify is required for swapping blocks of higher hardness. When used on entities, the locations of the caster and the entity hit are swapped.";
    }

    @Override
    public int getDefaultManaCost() {
        return 50;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

