/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.item.inv.InteractType;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class EffectName
extends AbstractEffect {
    public static EffectName INSTANCE = new EffectName();

    private EffectName() {
        super(GlyphLib.EffectNameID, "Name");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Component newName = this.getName(world, shooter, spellStats, spellContext, resolver);
        Entity entity = rayTraceResult.getEntity();
        entity.setCustomName(newName);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.setPersistenceRequired();
        } else if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            item.getItem().set(DataComponents.CUSTOM_NAME, (Object)newName);
        }
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (this.isRealPlayer((Entity)shooter) && player.equals((Object)entity)) {
                ItemStack offhand = player.getOffhandItem();
                offhand.set(DataComponents.CUSTOM_NAME, (Object)newName);
            }
        }
    }

    public Component getName(Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Player player;
        ItemStack stack;
        MutableComponent newName = null;
        InventoryManager manager = spellContext.getCaster().getInvManager();
        SlotReference slotRef = manager.findItem(i -> i.getItem() == Items.NAME_TAG, InteractType.EXTRACT);
        if (slotRef.getHandler() != null) {
            ItemStack stack2 = slotRef.getHandler().getStackInSlot(slotRef.getSlot());
            newName = stack2.getDisplayName().plainCopy();
        }
        if (newName == null && this.isRealPlayer((Entity)shooter) && shooter instanceof Player && (stack = StackUtil.getHeldCasterToolOrEmpty(player = (Player)shooter)) != ItemStack.EMPTY) {
            AbstractCaster<?> caster = SpellCasterRegistry.from(stack);
            newName = Component.literal((String)caster.getSpellName());
        }
        return newName;
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Component name = this.getName(world, shooter, spellStats, spellContext, resolver);
        BlockPos pos = rayTraceResult.getBlockPos();
        BlockState state = world.getBlockState(pos);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity head = (SkullBlockEntity)blockEntity;
            head.setOwner(new ResolvableProfile(Optional.of(name.getString()), Optional.empty(), new PropertyMap()));
            world.sendBlockUpdated(pos, state, state, 3);
            head.setChanged();
            return;
        }
        if (blockEntity instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity nameable = (BaseContainerBlockEntity)blockEntity;
            nameable.name = name;
            world.sendBlockUpdated(pos, state, state, 3);
            nameable.setChanged();
            return;
        }
        for (Entity entity : world.getEntities(null, new AABB(pos).inflate(0.08))) {
            entity.setCustomName(name);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.setPersistenceRequired();
                continue;
            }
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity item = (ItemEntity)entity;
            item.getItem().set(DataComponents.CUSTOM_NAME, (Object)name);
        }
    }

    @Override
    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }

    @Override
    public int getDefaultManaCost() {
        return 25;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }

    @Override
    public String getBookDescription() {
        return "Names an entity after the set Spell Name. Targeting a block will name nearby entities or name inventory blocks directly if possible. Targeting with Self will name the held offhand item. Can be overridden with a name tag in the hotbar.";
    }
}

