/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.attribute.IChemicalAttributeContainer;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.IHasTranslationKey;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class ChemicalStack<CHEMICAL extends Chemical<CHEMICAL>>
implements IHasTextComponent,
IHasTranslationKey,
IChemicalAttributeContainer<ChemicalStack<CHEMICAL>> {
    public static final Codec<ChemicalStack<?>> BOXED_CODEC = ChemicalType.CODEC.dispatch("chemical_type", ChemicalType::getTypeFor, type -> switch (type) {
        default -> throw new MatchException(null, null);
        case ChemicalType.GAS -> GasStack.MAP_CODEC;
        case ChemicalType.INFUSION -> InfusionStack.MAP_CODEC;
        case ChemicalType.PIGMENT -> PigmentStack.MAP_CODEC;
        case ChemicalType.SLURRY -> SlurryStack.MAP_CODEC;
    });
    public static final Codec<ChemicalStack<?>> BOXED_OPTIONAL_CODEC = NeoForgeExtraCodecs.withAlternative(BOXED_CODEC, (Codec)ChemicalType.CODEC.xmap(type -> switch (type) {
        default -> throw new MatchException(null, null);
        case ChemicalType.GAS -> GasStack.EMPTY;
        case ChemicalType.INFUSION -> InfusionStack.EMPTY;
        case ChemicalType.PIGMENT -> PigmentStack.EMPTY;
        case ChemicalType.SLURRY -> SlurryStack.EMPTY;
    }, ChemicalType::getTypeFor));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChemicalStack<?>> BOXED_STREAM_CODEC = ChemicalType.STREAM_CODEC.cast().dispatch(ChemicalType::getTypeFor, type -> switch (type) {
        default -> throw new MatchException(null, null);
        case ChemicalType.GAS -> GasStack.STREAM_CODEC;
        case ChemicalType.INFUSION -> InfusionStack.STREAM_CODEC;
        case ChemicalType.PIGMENT -> PigmentStack.STREAM_CODEC;
        case ChemicalType.SLURRY -> SlurryStack.STREAM_CODEC;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, ChemicalStack<?>> BOXED_OPTIONAL_STREAM_CODEC = ChemicalType.STREAM_CODEC.cast().dispatch(ChemicalType::getTypeFor, type -> switch (type) {
        default -> throw new MatchException(null, null);
        case ChemicalType.GAS -> GasStack.OPTIONAL_STREAM_CODEC;
        case ChemicalType.INFUSION -> InfusionStack.OPTIONAL_STREAM_CODEC;
        case ChemicalType.PIGMENT -> PigmentStack.OPTIONAL_STREAM_CODEC;
        case ChemicalType.SLURRY -> SlurryStack.OPTIONAL_STREAM_CODEC;
    });
    private final CHEMICAL chemical;
    private long amount;

    protected static <CHEMICAL extends Chemical<CHEMICAL>> Codec<CHEMICAL> chemicalNonEmptyCodec(Registry<CHEMICAL> registry) {
        return registry.byNameCodec().validate(chemical -> chemical.isEmptyType() ? DataResult.error(() -> "Chemical must not be mekanism:empty") : DataResult.success((Object)chemical));
    }

    protected static <CHEMICAL extends Chemical<CHEMICAL>> Codec<Holder<CHEMICAL>> chemicalNonEmptyHolderCodec(Registry<CHEMICAL> registry) {
        return registry.holderByNameCodec().validate(chemical -> ((Chemical)chemical.value()).isEmptyType() ? DataResult.error(() -> "Chemical must not be mekanism:empty") : DataResult.success((Object)chemical));
    }

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> MapCodec<STACK> codec(Codec<CHEMICAL> nonEmptyCodec, BiFunction<CHEMICAL, Long, STACK> constructor) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)nonEmptyCodec.fieldOf("id").forGetter(ChemicalStack::getChemical), (App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("amount").forGetter(ChemicalStack::getAmount)).apply((Applicative)instance, constructor));
    }

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Codec<STACK> fixedAmountCodec(Codec<CHEMICAL> chemicalNonEmptyCodec, BiFunction<CHEMICAL, Long, STACK> constructor, long amount) {
        return RecordCodecBuilder.create(instance -> instance.group((App)chemicalNonEmptyCodec.fieldOf("id").forGetter(ChemicalStack::getChemical)).apply((Applicative)instance, holder -> (ChemicalStack)constructor.apply(holder, amount)));
    }

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Codec<STACK> optionalCodec(Codec<STACK> codec, STACK empty) {
        return ExtraCodecs.optionalEmptyMap(codec).xmap(optional -> optional.orElse(empty), stack -> stack.isEmpty() ? Optional.empty() : Optional.of(stack));
    }

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> StreamCodec<RegistryFriendlyByteBuf, STACK> optionalStreamCodec(ResourceKey<? extends Registry<CHEMICAL>> registry, final BiFunction<CHEMICAL, Long, STACK> constructor, final STACK empty) {
        final StreamCodec chemicalStreamCodec = ByteBufCodecs.registry(registry);
        return new StreamCodec<RegistryFriendlyByteBuf, STACK>(){

            public STACK decode(RegistryFriendlyByteBuf buffer) {
                long amount = buffer.readVarLong();
                if (amount <= 0L) {
                    return empty;
                }
                Chemical chemical = (Chemical)chemicalStreamCodec.decode((Object)buffer);
                return (ChemicalStack)constructor.apply(chemical, amount);
            }

            public void encode(RegistryFriendlyByteBuf buffer, STACK stack) {
                buffer.writeVarLong(((ChemicalStack)stack).getAmount());
                if (!((ChemicalStack)stack).isEmpty()) {
                    chemicalStreamCodec.encode((Object)buffer, ((ChemicalStack)stack).getChemical());
                }
            }
        };
    }

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> StreamCodec<RegistryFriendlyByteBuf, STACK> streamCodec(final StreamCodec<RegistryFriendlyByteBuf, STACK> optionalStreamCodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, STACK>(){

            public STACK decode(RegistryFriendlyByteBuf buffer) {
                ChemicalStack stack = (ChemicalStack)optionalStreamCodec.decode((Object)buffer);
                if (stack.isEmpty()) {
                    throw new DecoderException("Empty ChemicalStack not allowed");
                }
                return stack;
            }

            public void encode(RegistryFriendlyByteBuf buffer, STACK stack) {
                if (((ChemicalStack)stack).isEmpty()) {
                    throw new EncoderException("Empty ChemicalStack not allowed");
                }
                optionalStreamCodec.encode((Object)buffer, stack);
            }
        };
    }

    protected ChemicalStack(Holder<CHEMICAL> chemical, long amount) {
        this((Chemical)chemical.value(), amount);
    }

    protected ChemicalStack(CHEMICAL chemical, long amount) {
        Objects.requireNonNull(chemical, "Cannot create a ChemicalStack from a null chemical");
        this.chemical = chemical;
        this.amount = amount;
    }

    protected ChemicalStack(@Nullable Void unused) {
        this.chemical = null;
    }

    protected abstract CHEMICAL getEmptyChemical();

    public abstract ChemicalStack<CHEMICAL> copy();

    public abstract ChemicalStack<CHEMICAL> copyWithAmount(long var1);

    public abstract ChemicalStack<CHEMICAL> split(long var1);

    public abstract ChemicalStack<CHEMICAL> copyAndClear();

    public final CHEMICAL getChemical() {
        return this.isEmpty() ? this.getEmptyChemical() : this.chemical;
    }

    public Holder<CHEMICAL> getChemicalHolder() {
        return ((Chemical)this.getChemical()).getAsHolder();
    }

    public boolean is(TagKey<CHEMICAL> tag) {
        return this.getChemicalHolder().is(tag);
    }

    public boolean is(CHEMICAL chemical) {
        return this.getChemical() == chemical;
    }

    public boolean is(Predicate<Holder<CHEMICAL>> predicate) {
        return predicate.test(this.getChemicalHolder());
    }

    public boolean is(Holder<CHEMICAL> holder) {
        return this.is((Chemical)holder.value());
    }

    public boolean is(HolderSet<CHEMICAL> holderSet) {
        return holderSet.contains(this.getChemicalHolder());
    }

    public Stream<TagKey<CHEMICAL>> getTags() {
        return this.getChemicalHolder().tags();
    }

    public abstract Tag save(HolderLookup.Provider var1, Tag var2);

    public abstract Tag save(HolderLookup.Provider var1);

    public Tag saveOptional(HolderLookup.Provider lookupProvider) {
        return this.isEmpty() ? new CompoundTag() : this.save(lookupProvider);
    }

    public ResourceLocation getTypeRegistryName() {
        return ((Chemical)this.getChemical()).getRegistryName();
    }

    public int getChemicalTint() {
        return ((Chemical)this.getChemical()).getTint();
    }

    public int getChemicalColorRepresentation() {
        return ((Chemical)this.getChemical()).getColorRepresentation();
    }

    public boolean isEmpty() {
        return this.chemical == null || ((Chemical)this.chemical).isEmptyType() || this.amount <= 0L;
    }

    public long getAmount() {
        return this.isEmpty() ? 0L : this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void limitSize(long amount) {
        if (!this.isEmpty() && this.getAmount() > amount) {
            this.setAmount(amount);
        }
    }

    public void grow(long amount) {
        this.setAmount(this.amount + amount);
    }

    public void shrink(long amount) {
        this.setAmount(this.amount - amount);
    }

    @Override
    public boolean has(Class<? extends ChemicalAttribute> type) {
        return ((Chemical)this.getChemical()).has(type);
    }

    public boolean isRadioactive() {
        return ((Chemical)this.getChemical()).isRadioactive();
    }

    @Override
    @Nullable
    public <ATTRIBUTE extends ChemicalAttribute> ATTRIBUTE get(Class<ATTRIBUTE> type) {
        return ((Chemical)this.getChemical()).get(type);
    }

    @Override
    public Collection<ChemicalAttribute> getAttributes() {
        return ((Chemical)this.getChemical()).getAttributes();
    }

    @Override
    public Collection<Class<? extends ChemicalAttribute>> getAttributeTypes() {
        return ((Chemical)this.getChemical()).getAttributeTypes();
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.getChemical().hashCode();
        code = 31 * code + Long.hashCode(this.getAmount());
        return code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChemicalStack other = (ChemicalStack)o;
        return this.getChemical() == other.getChemical() && this.getAmount() == other.getAmount();
    }

    public String toString() {
        return "[" + String.valueOf(this.getChemical()) + ", " + this.amount + "]";
    }

    @Override
    public Component getTextComponent() {
        return ((Chemical)this.getChemical()).getTextComponent();
    }

    @Override
    public String getTranslationKey() {
        return ((Chemical)this.getChemical()).getTranslationKey();
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>> boolean isSameChemical(ChemicalStack<CHEMICAL> first, ChemicalStack<CHEMICAL> second) {
        return first.is(second.getChemical());
    }
}

