/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.functions.ConstantPredicates;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ChemicalTankBuilder<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> {
    public static final ChemicalTankBuilder<Gas, GasStack, IGasTank> GAS = new ChemicalTankBuilder(BasicGasTank::new);
    public static final ChemicalTankBuilder<InfuseType, InfusionStack, IInfusionTank> INFUSION = new ChemicalTankBuilder(BasicInfusionTank::new);
    public static final ChemicalTankBuilder<Pigment, PigmentStack, IPigmentTank> PIGMENT = new ChemicalTankBuilder(BasicPigmentTank::new);
    public static final ChemicalTankBuilder<Slurry, SlurryStack, ISlurryTank> SLURRY = new ChemicalTankBuilder(BasicSlurryTank::new);
    public final Predicate<@NotNull CHEMICAL> alwaysTrue = ConstantPredicates.alwaysTrue();
    public final Predicate<@NotNull CHEMICAL> alwaysFalse = ConstantPredicates.alwaysFalse();
    public final BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> alwaysTrueBi = ConstantPredicates.alwaysTrueBi();
    public final BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> internalOnly = ConstantPredicates.internalOnly();
    public final BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> notExternal = ConstantPredicates.notExternal();
    public final BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> manualOnly = (chemical, automationType) -> automationType == AutomationType.MANUAL;
    private final BasicTankCreator<CHEMICAL, STACK, TANK> tankCreator;

    private ChemicalTankBuilder(BasicTankCreator<CHEMICAL, STACK, TANK> tankCreator) {
        this.tankCreator = tankCreator;
    }

    public TANK createDummy(long capacity) {
        return this.createAllValid(capacity, null);
    }

    public TANK create(long capacity, @Nullable IContentsListener listener) {
        return this.createWithValidator(capacity, null, listener);
    }

    public TANK createWithValidator(long capacity, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        return this.tankCreator.create(capacity, this.alwaysTrueBi, this.alwaysTrueBi, this.alwaysTrue, attributeValidator, listener);
    }

    public TANK createAllValid(long capacity, @Nullable IContentsListener listener) {
        return this.createWithValidator(capacity, ChemicalAttributeValidator.ALWAYS_ALLOW, listener);
    }

    public TANK create(long capacity, Predicate<@NotNull CHEMICAL> canExtract, Predicate<@NotNull CHEMICAL> canInsert, @Nullable IContentsListener listener) {
        return this.create(capacity, canExtract, canInsert, this.alwaysTrue, listener);
    }

    public TANK create(long capacity, Predicate<@NotNull CHEMICAL> validator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return this.tankCreator.create(capacity, this.alwaysTrueBi, this.alwaysTrueBi, validator, null, listener);
    }

    public TANK input(long capacity, Predicate<@NotNull CHEMICAL> validator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return this.tankCreator.create(capacity, this.notExternal, this.alwaysTrueBi, validator, null, listener);
    }

    public TANK input(long capacity, Predicate<@NotNull CHEMICAL> canInsert, Predicate<@NotNull CHEMICAL> validator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return this.tankCreator.create(capacity, this.notExternal, (CHEMICAL stack, AutomationType automationType) -> canInsert.test(stack), validator, null, listener);
    }

    public TANK output(long capacity, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        return this.tankCreator.create(capacity, this.alwaysTrueBi, this.internalOnly, this.alwaysTrue, ChemicalAttributeValidator.ALWAYS_ALLOW, listener);
    }

    public TANK create(long capacity, Predicate<@NotNull CHEMICAL> canExtract, Predicate<@NotNull CHEMICAL> canInsert, Predicate<@NotNull CHEMICAL> validator, @Nullable IContentsListener listener) {
        return this.create(capacity, canExtract, canInsert, validator, null, listener);
    }

    public TANK create(long capacity, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canExtract, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canInsert, Predicate<@NotNull CHEMICAL> validator, @Nullable IContentsListener listener) {
        return this.create(capacity, canExtract, canInsert, validator, null, listener);
    }

    public TANK create(long capacity, Predicate<@NotNull CHEMICAL> canExtract, Predicate<@NotNull CHEMICAL> canInsert, Predicate<@NotNull CHEMICAL> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return this.createUnchecked(capacity, canExtract, canInsert, validator, attributeValidator, listener);
    }

    public TANK create(long capacity, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canExtract, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canInsert, Predicate<@NotNull CHEMICAL> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Chemical validity check cannot be null");
        return this.tankCreator.create(capacity, canExtract, canInsert, validator, attributeValidator, listener);
    }

    private TANK createUnchecked(long capacity, Predicate<@NotNull CHEMICAL> canExtract, Predicate<@NotNull CHEMICAL> canInsert, Predicate<@NotNull CHEMICAL> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        return this.tankCreator.create(capacity, (CHEMICAL stack, AutomationType automationType) -> automationType == AutomationType.MANUAL || canExtract.test(stack), (CHEMICAL stack, AutomationType automationType) -> canInsert.test(stack), validator, attributeValidator, listener);
    }

    @FunctionalInterface
    private static interface BasicTankCreator<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> {
        public TANK create(long var1, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> var3, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> var4, Predicate<@NotNull CHEMICAL> var5, @Nullable ChemicalAttributeValidator var6, @Nullable IContentsListener var7);
    }

    public static class BasicSlurryTank
    extends BasicChemicalTank<Slurry, SlurryStack>
    implements ISlurryHandler,
    ISlurryTank {
        protected BasicSlurryTank(long capacity, BiPredicate<@NotNull Slurry, @NotNull AutomationType> canExtract, BiPredicate<@NotNull Slurry, @NotNull AutomationType> canInsert, Predicate<@NotNull Slurry> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
            super(capacity, canExtract, canInsert, validator, attributeValidator, listener);
        }
    }

    public static class BasicPigmentTank
    extends BasicChemicalTank<Pigment, PigmentStack>
    implements IPigmentHandler,
    IPigmentTank {
        protected BasicPigmentTank(long capacity, BiPredicate<@NotNull Pigment, @NotNull AutomationType> canExtract, BiPredicate<@NotNull Pigment, @NotNull AutomationType> canInsert, Predicate<@NotNull Pigment> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
            super(capacity, canExtract, canInsert, validator, attributeValidator, listener);
        }
    }

    public static class BasicInfusionTank
    extends BasicChemicalTank<InfuseType, InfusionStack>
    implements IInfusionHandler,
    IInfusionTank {
        protected BasicInfusionTank(long capacity, BiPredicate<@NotNull InfuseType, @NotNull AutomationType> canExtract, BiPredicate<@NotNull InfuseType, @NotNull AutomationType> canInsert, Predicate<@NotNull InfuseType> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
            super(capacity, canExtract, canInsert, validator, attributeValidator, listener);
        }
    }

    public static class BasicGasTank
    extends BasicChemicalTank<Gas, GasStack>
    implements IGasHandler,
    IGasTank {
        protected BasicGasTank(long capacity, BiPredicate<@NotNull Gas, @NotNull AutomationType> canExtract, BiPredicate<@NotNull Gas, @NotNull AutomationType> canInsert, Predicate<@NotNull Gas> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
            super(capacity, canExtract, canInsert, validator, attributeValidator, listener);
        }
    }
}

