/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.ingredients.InfusionStackIngredient;
import mekanism.api.recipes.ingredients.PigmentStackIngredient;
import mekanism.api.recipes.ingredients.SlurryStackIngredient;
import mekanism.api.recipes.ingredients.chemical.IChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.IGasIngredient;
import mekanism.api.recipes.ingredients.chemical.IInfusionIngredient;
import mekanism.api.recipes.ingredients.chemical.IPigmentIngredient;
import mekanism.api.recipes.ingredients.chemical.ISlurryIngredient;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ChemicalType implements StringRepresentable
{
    GAS("gas", c -> c instanceof Gas),
    INFUSION("infuse_type", c -> c instanceof InfuseType),
    PIGMENT("pigment", c -> c instanceof Pigment),
    SLURRY("slurry", c -> c instanceof Slurry);

    private static final Map<String, ChemicalType> nameToType;
    public static final Codec<ChemicalType> CODEC;
    public static final IntFunction<ChemicalType> BY_ID;
    public static final StreamCodec<ByteBuf, ChemicalType> STREAM_CODEC;
    private final Predicate<Chemical<?>> instanceCheck;
    private final String name;

    private ChemicalType(String name, Predicate<Chemical<?>> instanceCheck) {
        this.name = name;
        this.instanceCheck = instanceCheck;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public boolean isInstance(Chemical<?> chemical) {
        return this.instanceCheck.test(chemical);
    }

    @Nullable
    public static ChemicalType fromString(String name) {
        return nameToType.get(name);
    }

    public static ChemicalType getTypeFor(Chemical<?> chemical) {
        if (chemical instanceof Gas) {
            return GAS;
        }
        if (chemical instanceof InfuseType) {
            return INFUSION;
        }
        if (chemical instanceof Pigment) {
            return PIGMENT;
        }
        if (chemical instanceof Slurry) {
            return SLURRY;
        }
        throw new IllegalStateException("Unknown chemical type");
    }

    public static ChemicalType getTypeFor(ChemicalStack<?> stack) {
        return ChemicalType.getTypeFor(stack.getChemical());
    }

    public static ChemicalType getTypeFor(ChemicalStackIngredient<?, ?, ?> ingredient) {
        ChemicalStackIngredient<?, ?, ?> chemicalStackIngredient = ingredient;
        Objects.requireNonNull(chemicalStackIngredient);
        ChemicalStackIngredient<?, ?, ?> chemicalStackIngredient2 = chemicalStackIngredient;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GasStackIngredient.class, InfusionStackIngredient.class, PigmentStackIngredient.class, SlurryStackIngredient.class}, chemicalStackIngredient2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                GasStackIngredient gas = (GasStackIngredient)chemicalStackIngredient2;
                yield GAS;
            }
            case 1 -> {
                InfusionStackIngredient infusion = (InfusionStackIngredient)chemicalStackIngredient2;
                yield INFUSION;
            }
            case 2 -> {
                PigmentStackIngredient pigment = (PigmentStackIngredient)chemicalStackIngredient2;
                yield PIGMENT;
            }
            case 3 -> {
                SlurryStackIngredient slurry = (SlurryStackIngredient)chemicalStackIngredient2;
                yield SLURRY;
            }
        };
    }

    public static ChemicalType getTypeFor(IChemicalIngredient<?, ?> ingredient) {
        IChemicalIngredient<?, ?> iChemicalIngredient = ingredient;
        Objects.requireNonNull(iChemicalIngredient);
        IChemicalIngredient<?, ?> iChemicalIngredient2 = iChemicalIngredient;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IGasIngredient.class, IInfusionIngredient.class, IPigmentIngredient.class, ISlurryIngredient.class}, iChemicalIngredient2, n)) {
            case 0 -> {
                IGasIngredient gas = (IGasIngredient)iChemicalIngredient2;
                yield GAS;
            }
            case 1 -> {
                IInfusionIngredient infusion = (IInfusionIngredient)iChemicalIngredient2;
                yield INFUSION;
            }
            case 2 -> {
                IPigmentIngredient pigment = (IPigmentIngredient)iChemicalIngredient2;
                yield PIGMENT;
            }
            case 3 -> {
                ISlurryIngredient slurry = (ISlurryIngredient)iChemicalIngredient2;
                yield SLURRY;
            }
            default -> throw new IllegalStateException("Chemical ingredient should implement an ingredient type");
        };
    }

    public static ChemicalType getTypeFor(IChemicalHandler<?, ?> handler) {
        if (handler instanceof IGasHandler) {
            return GAS;
        }
        if (handler instanceof IInfusionHandler) {
            return INFUSION;
        }
        if (handler instanceof IPigmentHandler) {
            return PIGMENT;
        }
        if (handler instanceof ISlurryHandler) {
            return SLURRY;
        }
        throw new IllegalStateException("Unknown chemical handler type");
    }

    public static ChemicalType getTypeFor(IChemicalTank<?, ?> tank) {
        if (tank instanceof IGasTank) {
            return GAS;
        }
        if (tank instanceof IInfusionTank) {
            return INFUSION;
        }
        if (tank instanceof IPigmentTank) {
            return PIGMENT;
        }
        if (tank instanceof ISlurryTank) {
            return SLURRY;
        }
        throw new IllegalStateException("Unknown chemical tank type");
    }

    static {
        ChemicalType[] values = ChemicalType.values();
        nameToType = new Object2ObjectArrayMap(values.length);
        for (ChemicalType type : values) {
            nameToType.put(type.getSerializedName(), type);
        }
        CODEC = StringRepresentable.fromEnum(ChemicalType::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ChemicalType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

