/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.infuse;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.providers.IInfuseTypeProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class InfusionStack
extends ChemicalStack<InfuseType> {
    public static final InfusionStack EMPTY = new InfusionStack(null);
    public static final Codec<InfuseType> INFUSE_TYPE_NON_EMPTY_CODEC = InfusionStack.chemicalNonEmptyCodec(MekanismAPI.INFUSE_TYPE_REGISTRY);
    public static final Codec<Holder<InfuseType>> INFUSE_TYPE_NON_EMPTY_HOLDER_CODEC = InfusionStack.chemicalNonEmptyHolderCodec(MekanismAPI.INFUSE_TYPE_REGISTRY);
    public static final MapCodec<InfusionStack> MAP_CODEC = InfusionStack.codec(INFUSE_TYPE_NON_EMPTY_CODEC, InfusionStack::new);
    public static final Codec<InfusionStack> CODEC = MAP_CODEC.codec();
    public static final Codec<InfusionStack> OPTIONAL_CODEC = InfusionStack.optionalCodec(CODEC, EMPTY);
    public static final StreamCodec<RegistryFriendlyByteBuf, InfusionStack> OPTIONAL_STREAM_CODEC = InfusionStack.optionalStreamCodec(MekanismAPI.INFUSE_TYPE_REGISTRY_NAME, InfusionStack::new, EMPTY);
    public static final StreamCodec<RegistryFriendlyByteBuf, InfusionStack> STREAM_CODEC = InfusionStack.streamCodec(OPTIONAL_STREAM_CODEC);

    public static Codec<InfusionStack> fixedAmountCodec(int amount) {
        return InfusionStack.fixedAmountCodec(INFUSE_TYPE_NON_EMPTY_CODEC, InfusionStack::new, amount);
    }

    public InfusionStack(IInfuseTypeProvider infuseTypeProvider, long amount) {
        super((InfuseType)infuseTypeProvider.getChemical(), amount);
    }

    public InfusionStack(Holder<InfuseType> infuseTypeHolder, long amount) {
        super(infuseTypeHolder, amount);
    }

    private InfusionStack(@Nullable Void unused) {
        super(unused);
    }

    public static Optional<InfusionStack> parse(HolderLookup.Provider lookupProvider, Tag tag) {
        return CODEC.parse((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(error -> MekanismAPI.logger.error("Tried to load invalid gas: '{}'", error));
    }

    public static InfusionStack parseOptional(HolderLookup.Provider lookupProvider, CompoundTag tag) {
        return tag.isEmpty() ? EMPTY : InfusionStack.parse(lookupProvider, (Tag)tag).orElse(EMPTY);
    }

    @Override
    protected InfuseType getEmptyChemical() {
        return MekanismAPI.EMPTY_INFUSE_TYPE;
    }

    public InfusionStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new InfusionStack((IInfuseTypeProvider)this.getChemical(), this.getAmount());
    }

    public InfusionStack copyWithAmount(long amount) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new InfusionStack((IInfuseTypeProvider)this.getChemical(), amount);
    }

    public InfusionStack split(long amount) {
        long i = Math.min(amount, this.getAmount());
        InfusionStack stack = this.copyWithAmount(i);
        this.shrink(i);
        return stack;
    }

    public InfusionStack copyAndClear() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        InfusionStack stack = this.copy();
        this.setAmount(0L);
        return stack;
    }

    @Override
    public Tag save(HolderLookup.Provider lookupProvider, Tag prefix) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty InfusionStack");
        }
        return (Tag)CODEC.encode((Object)this, (DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)prefix).getOrThrow();
    }

    @Override
    public Tag save(HolderLookup.Provider lookupProvider) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty InfusionStack");
        }
        return (Tag)CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }
}

