/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.pigment;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.providers.IPigmentProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class PigmentStack
extends ChemicalStack<Pigment> {
    public static final PigmentStack EMPTY = new PigmentStack(null);
    public static final Codec<Pigment> PIGMENT_NON_EMPTY_CODEC = PigmentStack.chemicalNonEmptyCodec(MekanismAPI.PIGMENT_REGISTRY);
    public static final Codec<Holder<Pigment>> PIGMENT_NON_EMPTY_HOLDER_CODEC = PigmentStack.chemicalNonEmptyHolderCodec(MekanismAPI.PIGMENT_REGISTRY);
    public static final MapCodec<PigmentStack> MAP_CODEC = PigmentStack.codec(PIGMENT_NON_EMPTY_CODEC, PigmentStack::new);
    public static final Codec<PigmentStack> CODEC = MAP_CODEC.codec();
    public static final Codec<PigmentStack> OPTIONAL_CODEC = PigmentStack.optionalCodec(CODEC, EMPTY);
    public static final StreamCodec<RegistryFriendlyByteBuf, PigmentStack> OPTIONAL_STREAM_CODEC = PigmentStack.optionalStreamCodec(MekanismAPI.PIGMENT_REGISTRY_NAME, PigmentStack::new, EMPTY);
    public static final StreamCodec<RegistryFriendlyByteBuf, PigmentStack> STREAM_CODEC = PigmentStack.streamCodec(OPTIONAL_STREAM_CODEC);

    public static Codec<PigmentStack> fixedAmountCodec(int amount) {
        return PigmentStack.fixedAmountCodec(PIGMENT_NON_EMPTY_CODEC, PigmentStack::new, amount);
    }

    public PigmentStack(IPigmentProvider pigmentProvider, long amount) {
        super((Pigment)pigmentProvider.getChemical(), amount);
    }

    public PigmentStack(Holder<Pigment> pigmentHolder, long amount) {
        super(pigmentHolder, amount);
    }

    private PigmentStack(@Nullable Void unused) {
        super(unused);
    }

    public static Optional<PigmentStack> parse(HolderLookup.Provider lookupProvider, Tag tag) {
        return CODEC.parse((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(error -> MekanismAPI.logger.error("Tried to load invalid gas: '{}'", error));
    }

    public static PigmentStack parseOptional(HolderLookup.Provider lookupProvider, CompoundTag tag) {
        return tag.isEmpty() ? EMPTY : PigmentStack.parse(lookupProvider, (Tag)tag).orElse(EMPTY);
    }

    @Override
    protected Pigment getEmptyChemical() {
        return MekanismAPI.EMPTY_PIGMENT;
    }

    public PigmentStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new PigmentStack((IPigmentProvider)this.getChemical(), this.getAmount());
    }

    public PigmentStack copyWithAmount(long amount) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new PigmentStack((IPigmentProvider)this.getChemical(), amount);
    }

    public PigmentStack split(long amount) {
        long i = Math.min(amount, this.getAmount());
        PigmentStack stack = this.copyWithAmount(i);
        this.shrink(i);
        return stack;
    }

    public PigmentStack copyAndClear() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        PigmentStack stack = this.copy();
        this.setAmount(0L);
        return stack;
    }

    @Override
    public Tag save(HolderLookup.Provider lookupProvider, Tag prefix) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty PigmentStack");
        }
        return (Tag)CODEC.encode((Object)this, (DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)prefix).getOrThrow();
    }

    @Override
    public Tag save(HolderLookup.Provider lookupProvider) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty PigmentStack");
        }
        return (Tag)CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }
}

