/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.slurry;

import com.mojang.serialization.Codec;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.slurry.SlurryBuilder;
import mekanism.api.providers.ISlurryProvider;
import net.minecraft.Util;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class Slurry
extends Chemical<Slurry>
implements ISlurryProvider {
    public static final Codec<Slurry> CODEC = MekanismAPI.SLURRY_REGISTRY.byNameCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, Slurry> STREAM_CODEC = ByteBufCodecs.registry(MekanismAPI.SLURRY_REGISTRY_NAME);
    @Nullable
    private final TagKey<Item> oreTag;

    public Slurry(SlurryBuilder builder) {
        super(builder);
        this.oreTag = builder.getOreTag();
    }

    public String toString() {
        return "[Slurry: " + String.valueOf(this.getRegistryName()) + "]";
    }

    @Override
    public final boolean isEmptyType() {
        return this == MekanismAPI.EMPTY_SLURRY;
    }

    @Override
    protected final DefaultedRegistry<Slurry> getRegistry() {
        return MekanismAPI.SLURRY_REGISTRY;
    }

    @Override
    protected String getDefaultTranslationKey() {
        return Util.makeDescriptionId((String)"slurry", (ResourceLocation)this.getRegistryName());
    }

    @Nullable
    public TagKey<Item> getOreTag() {
        return this.oreTag;
    }
}

