/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe.builder;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.basic.BasicActivatingRecipe;
import mekanism.api.recipes.basic.BasicCentrifugingRecipe;
import mekanism.api.recipes.ingredients.GasStackIngredient;

@NothingNullByDefault
public class GasToGasRecipeBuilder
extends MekanismRecipeBuilder<GasToGasRecipeBuilder> {
    private final Factory factory;
    private final GasStackIngredient input;
    private final GasStack output;

    protected GasToGasRecipeBuilder(GasStackIngredient input, GasStack output, Factory factory) {
        this.input = input;
        this.output = output;
        this.factory = factory;
    }

    public static GasToGasRecipeBuilder activating(GasStackIngredient input, GasStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This solar neutron activator recipe requires a non empty gas output.");
        }
        return new GasToGasRecipeBuilder(input, output, BasicActivatingRecipe::new);
    }

    public static GasToGasRecipeBuilder centrifuging(GasStackIngredient input, GasStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This Isotopic Centrifuge recipe requires a non empty gas output.");
        }
        return new GasToGasRecipeBuilder(input, output, BasicCentrifugingRecipe::new);
    }

    protected GasToGasRecipe asRecipe() {
        return this.factory.create(this.input, this.output);
    }

    @FunctionalInterface
    public static interface Factory {
        public GasToGasRecipe create(GasStackIngredient var1, GasStack var2);
    }
}

