/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.energy;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import net.minecraft.util.Mth;

@NothingNullByDefault
public interface IEnergyConversion {
    public boolean isEnabled();

    default public long convertFrom(long energy) {
        return MathUtils.clampToLong((double)energy * this.getConversion());
    }

    default public int convertToAsInt(long joules) {
        return MathUtils.clampToInt(this.convertTo(joules));
    }

    @Deprecated(forRemoval=true)
    default public long convertToAsLong(long joules) {
        return this.convertTo(joules);
    }

    default public long convertTo(long joules) {
        return MathUtils.clampToLong(this.convertToDouble(joules));
    }

    default public double convertToDouble(long joules) {
        if (joules == 0L) {
            return 0.0;
        }
        return (double)joules / this.getConversion();
    }

    default public boolean isOneToOne() {
        return Mth.equal((double)1.0, (double)this.getConversion());
    }

    public double getConversion();
}

