/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.functions;

import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import mekanism.api.AutomationType;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.TriPredicate;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ConstantPredicates {
    public static final BooleanSupplier ALWAYS_TRUE = () -> true;
    public static final LongSupplier ZERO_LONG = () -> 0L;
    private static final Predicate<Object> alwaysTrue = t -> true;
    private static final BiPredicate<Object, Object> alwaysTrueBi = (t, u) -> true;
    private static final TriPredicate<Object, Object, Object> alwaysTrueTri = (t, u, v) -> true;
    public static final Predicate<ItemStack> ITEM_EMPTY = ItemStack::isEmpty;
    public static final Predicate<FluidStack> FLUID_EMPTY = FluidStack::isEmpty;
    private static final Predicate<ChemicalStack<?>> CHEMICAL_EMPTY = ChemicalStack::isEmpty;
    private static final Predicate<Object> alwaysFalse = t -> false;
    private static final BiPredicate<Object, Object> alwaysFalseBi = (t, u) -> false;
    private static final TriPredicate<Object, Object, Object> alwaysFalseTri = (t, u, v) -> false;
    private static final BiPredicate<Object, @NotNull AutomationType> internalOnly = (t, automationType) -> automationType == AutomationType.INTERNAL;
    private static final BiPredicate<Object, @NotNull AutomationType> notExternal = (t, automationType) -> automationType != AutomationType.EXTERNAL;

    private ConstantPredicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return alwaysTrue;
    }

    public static <T, U> BiPredicate<T, U> alwaysTrueBi() {
        return alwaysTrueBi;
    }

    public static <T, U, V> TriPredicate<T, U, V> alwaysTrueTri() {
        return alwaysTrueTri;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return alwaysFalse;
    }

    public static <T, V> BiPredicate<T, V> alwaysFalseBi() {
        return alwaysFalseBi;
    }

    public static <T, U, V> TriPredicate<T, U, V> alwaysFalseTri() {
        return alwaysFalseTri;
    }

    public static <T> BiPredicate<T, @NotNull AutomationType> internalOnly() {
        return internalOnly;
    }

    public static <T> BiPredicate<T, @NotNull AutomationType> notExternal() {
        return notExternal;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Predicate<STACK> chemicalEmpty() {
        return CHEMICAL_EMPTY;
    }
}

