/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear;

import java.util.function.LongSupplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.ModuleData;
import mekanism.api.gear.config.ModuleConfig;
import mekanism.api.text.IHasTextComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IModule<MODULE extends ICustomModule<MODULE>> {
    public ModuleData<MODULE> getData();

    @Nullable
    public <TYPE> ModuleConfig<TYPE> getConfig(ResourceLocation var1);

    default public boolean getBooleanConfigOrFalse(ResourceLocation name) {
        ModuleConfig config = this.getConfig(name);
        return config != null && (Boolean)config.get() != false;
    }

    default public <TYPE> ModuleConfig<TYPE> getConfigOrThrow(ResourceLocation name) {
        ModuleConfig<TYPE> config = this.getConfig(name);
        if (config == null) {
            throw new IllegalArgumentException("Expected module to contain a config with name " + String.valueOf(name));
        }
        return config;
    }

    public MODULE getCustomInstance();

    public int getInstalledCount();

    public boolean isEnabled();

    public boolean handlesModeChange();

    public boolean handlesRadialModeChange();

    public boolean handlesAnyModeChange();

    public void displayModeChange(Player var1, Component var2, IHasTextComponent var3);

    public void toggleEnabled(IModuleContainer var1, ItemStack var2, Player var3, Component var4);

    @Nullable
    public IEnergyContainer getEnergyContainer(ItemStack var1);

    public long getContainerEnergy(ItemStack var1);

    public boolean hasEnoughEnergy(ItemStack var1, LongSupplier var2);

    public boolean hasEnoughEnergy(ItemStack var1, long var2);

    public boolean canUseEnergy(LivingEntity var1, ItemStack var2, long var3);

    public boolean canUseEnergy(LivingEntity var1, ItemStack var2, long var3, boolean var5);

    public boolean canUseEnergy(LivingEntity var1, @Nullable IEnergyContainer var2, long var3, boolean var5);

    public long useEnergy(LivingEntity var1, ItemStack var2, long var3);

    public long useEnergy(LivingEntity var1, ItemStack var2, long var3, boolean var5);

    public long useEnergy(LivingEntity var1, @Nullable IEnergyContainer var2, long var3, boolean var5);
}

