/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear;

import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mekanism.api.gear.config.ModuleConfig;

class ModuleConfigListCodec
implements Codec<List<ModuleConfig<?>>> {
    private final List<Codec<ModuleConfig<?>>> codecs;

    ModuleConfigListCodec(List<Codec<? extends ModuleConfig<?>>> codecs) {
        this.codecs = codecs;
    }

    public <T> DataResult<T> encode(List<ModuleConfig<?>> input, DynamicOps<T> ops, T prefix) {
        int size = input.size();
        if (this.codecs.size() != size) {
            return DataResult.error(() -> "List length: " + size + ", does not match the number of codecs we have: " + this.codecs.size());
        }
        ListBuilder builder = ops.listBuilder();
        for (int i = 0; i < size; ++i) {
            builder.add(this.codecs.get(i).encodeStart(ops, input.get(i)));
        }
        return builder.build(prefix);
    }

    public <T> DataResult<Pair<List<ModuleConfig<?>>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getList(input).setLifecycle(Lifecycle.stable()).flatMap(stream -> {
            DecoderState decoder = new DecoderState(ops);
            stream.accept(decoder::accept);
            return decoder.build();
        });
    }

    public String toString() {
        return "ModuleConfigListCodec[" + this.codecs.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    private class DecoderState<T> {
        private static final DataResult<Unit> INITIAL_RESULT = DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable());
        private final DynamicOps<T> ops;
        private final List<ModuleConfig<?>> elements = new ArrayList();
        private final Stream.Builder<T> failed = Stream.builder();
        private DataResult<Unit> result = INITIAL_RESULT;
        private int index;

        private DecoderState(DynamicOps<T> ops) {
            this.ops = ops;
        }

        public void accept(T value) {
            if (this.index >= ModuleConfigListCodec.this.codecs.size()) {
                this.failed.add(value);
                return;
            }
            Codec<ModuleConfig<?>> elementCodec = ModuleConfigListCodec.this.codecs.get(this.index++);
            DataResult elementResult = elementCodec.decode(this.ops, value);
            elementResult.error().ifPresent(error -> this.failed.add(value));
            elementResult.resultOrPartial().ifPresent(pair -> this.elements.add((ModuleConfig)pair.getFirst()));
            this.result = this.result.apply2stable((result, element) -> result, elementResult);
        }

        public DataResult<Pair<List<ModuleConfig<?>>, T>> build() {
            Object errors = this.ops.createList(this.failed.build());
            Pair pair = Pair.of(List.copyOf(this.elements), (Object)errors);
            return this.result.map(ignored -> pair).setPartial((Object)pair);
        }
    }
}

