/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public class BasicElectrolysisRecipe
extends ElectrolysisRecipe {
    protected final FluidStackIngredient input;
    protected final GasStack leftGasOutput;
    protected final GasStack rightGasOutput;
    protected final long energyMultiplier;

    public BasicElectrolysisRecipe(FluidStackIngredient input, long energyMultiplier, GasStack leftGasOutput, GasStack rightGasOutput) {
        this.input = Objects.requireNonNull(input, "Input cannot be null.");
        this.energyMultiplier = energyMultiplier;
        if (energyMultiplier < 1L) {
            throw new IllegalArgumentException("Energy multiplier must be at least one.");
        }
        Objects.requireNonNull(leftGasOutput, "Left output cannot be null");
        Objects.requireNonNull(rightGasOutput, "Right output cannot be null");
        if (leftGasOutput.isEmpty()) {
            throw new IllegalArgumentException("Left output cannot be empty.");
        }
        if (rightGasOutput.isEmpty()) {
            throw new IllegalArgumentException("Right output cannot be empty.");
        }
        this.leftGasOutput = leftGasOutput.copy();
        this.rightGasOutput = rightGasOutput.copy();
    }

    @Override
    public FluidStackIngredient getInput() {
        return this.input;
    }

    @Override
    public List<ElectrolysisRecipe.ElectrolysisRecipeOutput> getOutputDefinition() {
        return Collections.singletonList(new ElectrolysisRecipe.ElectrolysisRecipeOutput(this.leftGasOutput, this.rightGasOutput));
    }

    @Override
    public boolean test(FluidStack fluidStack) {
        return this.input.test(fluidStack);
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    public ElectrolysisRecipe.ElectrolysisRecipeOutput getOutput(FluidStack input) {
        return new ElectrolysisRecipe.ElectrolysisRecipeOutput(this.leftGasOutput.copy(), this.rightGasOutput.copy());
    }

    @Override
    public long getEnergyMultiplier() {
        return this.energyMultiplier;
    }

    public String getGroup() {
        return "electrolytic_separator";
    }

    public GasStack getLeftGasOutput() {
        return this.leftGasOutput;
    }

    public GasStack getRightGasOutput() {
        return this.rightGasOutput;
    }

    public RecipeSerializer<BasicElectrolysisRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.SEPARATING.get();
    }
}

