/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.basic.IBasicItemStackOutput;
import mekanism.api.recipes.ingredients.InfusionStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class BasicMetallurgicInfuserRecipe
extends MetallurgicInfuserRecipe
implements IBasicItemStackOutput {
    protected final ItemStackIngredient itemInput;
    protected final InfusionStackIngredient infusionInput;
    protected final ItemStack output;

    public BasicMetallurgicInfuserRecipe(ItemStackIngredient itemInput, InfusionStackIngredient infusionInput, ItemStack output) {
        this.itemInput = Objects.requireNonNull(itemInput, "Item input cannot be null.");
        this.infusionInput = Objects.requireNonNull(infusionInput, "Chemical input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
    }

    @Override
    public ItemStackIngredient getItemInput() {
        return this.itemInput;
    }

    @Override
    public InfusionStackIngredient getChemicalInput() {
        return this.infusionInput;
    }

    @Override
    @Contract(value="_, _ -> new", pure=true)
    public ItemStack getOutput(ItemStack inputItem, InfusionStack inputChemical) {
        return this.output.copy();
    }

    @Override
    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @Override
    public boolean test(ItemStack itemStack, InfusionStack gasStack) {
        return this.itemInput.test(itemStack) && this.infusionInput.test(gasStack);
    }

    @Override
    public List<@NotNull ItemStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    @Override
    public ItemStack getOutputRaw() {
        return this.output;
    }

    public RecipeSerializer<BasicMetallurgicInfuserRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.METALLURGIC_INFUSING.get();
    }
}

