/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.pigment.IEmptyPigmentProvider;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.chemical.IPigmentIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class PigmentStackIngredient
extends ChemicalStackIngredient<Pigment, PigmentStack, IPigmentIngredient>
implements IEmptyPigmentProvider {
    public static final Codec<PigmentStackIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.pigment().mapCodecNonEmpty().forGetter(ChemicalStackIngredient::ingredient), (App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("amount").forGetter(ChemicalStackIngredient::amount)).apply((Applicative)instance, PigmentStackIngredient::new));
    public static final Codec<PigmentStackIngredient> NESTED_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.pigment().codecNonEmpty().fieldOf("ingredient").forGetter(ChemicalStackIngredient::ingredient), (App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("amount").forGetter(ChemicalStackIngredient::amount)).apply((Applicative)instance, PigmentStackIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PigmentStackIngredient> STREAM_CODEC = StreamCodec.composite(IngredientCreatorAccess.pigment().streamCodec(), ChemicalStackIngredient::ingredient, (StreamCodec)ByteBufCodecs.VAR_LONG, ChemicalStackIngredient::amount, PigmentStackIngredient::new);

    public static PigmentStackIngredient of(IPigmentIngredient ingredient, long amount) {
        Objects.requireNonNull(ingredient, "PigmentStackIngredients cannot be created from a null ingredient.");
        if (ingredient.isEmpty()) {
            throw new IllegalArgumentException("PigmentStackIngredients cannot be created using the empty ingredient.");
        }
        return new PigmentStackIngredient(ingredient, amount);
    }

    private PigmentStackIngredient(IPigmentIngredient ingredient, long amount) {
        super(ingredient, amount);
    }
}

