/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.chemical;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.IChemicalIngredient;
import mekanism.api.recipes.ingredients.creator.IChemicalIngredientCreator;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class CompoundChemicalIngredient<CHEMICAL extends Chemical<CHEMICAL>, INGREDIENT extends IChemicalIngredient<CHEMICAL, INGREDIENT>>
extends ChemicalIngredient<CHEMICAL, INGREDIENT> {
    private final List<INGREDIENT> children;

    @ApiStatus.Internal
    protected static <INGREDIENT extends IChemicalIngredient<?, INGREDIENT>, COMPOUND extends CompoundChemicalIngredient<?, INGREDIENT>> MapCodec<COMPOUND> codec(IChemicalIngredientCreator<?, INGREDIENT> creator, Function<List<INGREDIENT>, COMPOUND> constructor) {
        return NeoForgeExtraCodecs.aliasedFieldOf(creator.listCodecMultipleElements(), (String[])new String[]{"children", "ingredients"}).xmap(constructor, CompoundChemicalIngredient::children);
    }

    @ApiStatus.Internal
    protected CompoundChemicalIngredient(List<INGREDIENT> children) {
        if (children.size() < 2) {
            throw new IllegalArgumentException("Compound chemical ingredients must have at least two children");
        }
        this.children = children;
    }

    @Override
    public final Stream<CHEMICAL> generateChemicals() {
        return this.children().stream().flatMap(IChemicalIngredient::generateChemicals).distinct();
    }

    @Override
    public final boolean test(CHEMICAL chemical) {
        for (IChemicalIngredient child : this.children()) {
            if (!child.test(chemical)) continue;
            return true;
        }
        return false;
    }

    public final List<INGREDIENT> children() {
        return this.children;
    }

    @Override
    public int hashCode() {
        return this.children.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.children.equals(((CompoundChemicalIngredient)obj).children);
    }
}

