/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.chemical;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.IGasIngredient;
import mekanism.api.recipes.ingredients.chemical.IInfusionIngredient;
import mekanism.api.recipes.ingredients.chemical.IPigmentIngredient;
import mekanism.api.recipes.ingredients.chemical.ISlurryIngredient;
import mekanism.api.recipes.ingredients.creator.IChemicalIngredientCreator;

@NothingNullByDefault
public sealed interface IChemicalIngredient<CHEMICAL extends Chemical<CHEMICAL>, INGREDIENT extends IChemicalIngredient<CHEMICAL, INGREDIENT>>
extends Predicate<CHEMICAL>
permits ChemicalIngredient, IGasIngredient, IInfusionIngredient, IPigmentIngredient, ISlurryIngredient {
    @Override
    public boolean test(CHEMICAL var1);

    default public List<CHEMICAL> getChemicals() {
        return this.generateChemicals().toList();
    }

    public Stream<CHEMICAL> generateChemicals();

    public IChemicalIngredientCreator<CHEMICAL, INGREDIENT> ingredientCreator();

    default public boolean isEmpty() {
        return this == this.ingredientCreator().empty();
    }

    default public boolean hasNoChemicals() {
        return this.getChemicals().isEmpty();
    }

    public MapCodec<? extends INGREDIENT> codec();
}

