/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.chemical;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.IChemicalIngredient;
import mekanism.api.recipes.ingredients.creator.IChemicalIngredientCreator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class IntersectionChemicalIngredient<CHEMICAL extends Chemical<CHEMICAL>, INGREDIENT extends IChemicalIngredient<CHEMICAL, INGREDIENT>>
extends ChemicalIngredient<CHEMICAL, INGREDIENT> {
    private final List<INGREDIENT> children;

    @ApiStatus.Internal
    protected static <INGREDIENT extends IChemicalIngredient<?, INGREDIENT>, INTERSECTION extends IntersectionChemicalIngredient<?, INGREDIENT>> MapCodec<INTERSECTION> codec(IChemicalIngredientCreator<?, INGREDIENT> creator, Function<List<INGREDIENT>, INTERSECTION> constructor) {
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)creator.listCodecMultipleElements().fieldOf("children").forGetter(IntersectionChemicalIngredient::children)).apply((Applicative)builder, constructor));
    }

    @ApiStatus.Internal
    protected IntersectionChemicalIngredient(List<INGREDIENT> children) {
        if (children.size() < 2) {
            throw new IllegalArgumentException("Intersection chemical ingredients require at least two ingredients");
        }
        this.children = children;
    }

    @Override
    public final boolean test(CHEMICAL chemical) {
        for (IChemicalIngredient child : this.children) {
            if (child.test(chemical)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Stream<CHEMICAL> generateChemicals() {
        return this.children.stream().flatMap(IChemicalIngredient::generateChemicals).distinct().filter(this);
    }

    public final List<INGREDIENT> children() {
        return this.children;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.children);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.children.equals(((IntersectionChemicalIngredient)obj).children);
    }
}

