/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.tier;

import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import mekanism.api.SupportsColorMap;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.FastColor;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public enum BaseTier implements StringRepresentable,
SupportsColorMap
{
    BASIC("Basic", new int[]{95, 255, 184}, MapColor.COLOR_LIGHT_GREEN),
    ADVANCED("Advanced", new int[]{255, 128, 106}, MapColor.TERRACOTTA_PINK),
    ELITE("Elite", new int[]{75, 248, 255}, MapColor.DIAMOND),
    ULTIMATE("Ultimate", new int[]{247, 135, 255}, MapColor.COLOR_MAGENTA),
    CREATIVE("Creative", new int[]{88, 88, 88}, MapColor.TERRACOTTA_CYAN);

    public static final IntFunction<BaseTier> BY_ID;
    public static final StreamCodec<ByteBuf, BaseTier> STREAM_CODEC;
    private final String name;
    private final MapColor mapColor;
    private TextColor textColor;
    private int[] rgbCode;
    private int argb;

    private BaseTier(String name, int[] rgbCode, MapColor mapColor) {
        this.name = name;
        this.mapColor = mapColor;
        this.setColorFromAtlas(rgbCode);
    }

    public String getSimpleName() {
        return this.name;
    }

    public String getLowerName() {
        return this.getSimpleName().toLowerCase(Locale.ROOT);
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    @Override
    public int getPackedColor() {
        return this.argb;
    }

    @Override
    public int[] getRgbCode() {
        return this.rgbCode;
    }

    @Override
    public void setColorFromAtlas(int[] color) {
        this.rgbCode = color;
        this.argb = FastColor.ARGB32.color((int)this.rgbCode[0], (int)this.rgbCode[1], (int)this.rgbCode[2]);
        this.textColor = TextColor.fromRgb((int)this.argb);
    }

    public TextColor getColor() {
        return this.textColor;
    }

    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])BaseTier.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

