/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import mekanism.api.text.ILangEntry;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.GuiTabElementType;
import mekanism.client.gui.element.tab.TabType;
import mekanism.client.render.lib.ColorAtlas;
import mekanism.common.MekanismLang;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.button.PacketTileButtonPress;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.util.MekanismUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuiBoilerTab
extends GuiTabElementType<TileEntityBoilerCasing, BoilerTab> {
    public GuiBoilerTab(IGuiWrapper gui, TileEntityBoilerCasing tile, BoilerTab type) {
        super(gui, tile, type);
    }

    public static enum BoilerTab implements TabType<TileEntityBoilerCasing>
    {
        MAIN("gases.png", MekanismLang.MAIN_TAB, PacketTileButtonPress.ClickedTileButton.TAB_MAIN, SpecialColors.TAB_MULTIBLOCK_MAIN),
        STAT("stats.png", MekanismLang.BOILER_STATS, PacketTileButtonPress.ClickedTileButton.TAB_STATS, SpecialColors.TAB_MULTIBLOCK_STATS);

        private final ColorAtlas.ColorRegistryObject colorRO;
        private final PacketTileButtonPress.ClickedTileButton button;
        private final ILangEntry description;
        private final String path;

        private BoilerTab(String path, ILangEntry description, PacketTileButtonPress.ClickedTileButton button, ColorAtlas.ColorRegistryObject colorRO) {
            this.path = path;
            this.description = description;
            this.button = button;
            this.colorRO = colorRO;
        }

        @Override
        public ResourceLocation getResource() {
            return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.path);
        }

        @Override
        public void onClick(TileEntityBoilerCasing tile) {
            PacketUtils.sendToServer(new PacketTileButtonPress(this.button, tile));
        }

        @Override
        public Component getDescription() {
            return this.description.translate();
        }

        @Override
        public ColorAtlas.ColorRegistryObject getTabColor() {
            return this.colorRO;
        }
    }
}

