/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.gauge.GaugeOverlay;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.IProgressInfoHandler;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.jei.ChemicalStackRenderer;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.jei.NOOPDrawable;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.MekanismLang;
import mekanism.common.util.text.TextUtils;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRecipeCategory<RECIPE>
extends AbstractContainerEventHandler
implements IRecipeCategory<RECIPE>,
IGuiWrapper {
    private final List<GuiElement> guiElements = new ArrayList<GuiElement>();
    private final Component component;
    private final IGuiHelper guiHelper;
    private final IDrawable background;
    private final RecipeType<RECIPE> recipeType;
    private final IDrawable icon;
    private final int xOffset;
    private final int yOffset;
    @Nullable
    private Map<GaugeOverlay, IDrawable> overlayLookup;
    @Nullable
    private ITickTimer timer;

    protected static IDrawable createIcon(IGuiHelper helper, IRecipeViewerRecipeType<?> recipeType) {
        ItemStack stack = recipeType.iconStack();
        if (stack.isEmpty()) {
            ResourceLocation icon = recipeType.icon();
            if (icon == null) {
                throw new IllegalStateException("Expected recipe type to have either an icon stack or an icon location");
            }
            return helper.drawableBuilder(icon, 0, 0, 18, 18).setTextureSize(18, 18).build();
        }
        return helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
    }

    protected BaseRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<RECIPE> recipeType) {
        this(helper, MekanismJEI.recipeType(recipeType), recipeType.getTextComponent(), BaseRecipeCategory.createIcon(helper, recipeType), recipeType.xOffset(), recipeType.yOffset(), recipeType.width(), recipeType.height());
    }

    protected BaseRecipeCategory(IGuiHelper helper, RecipeType<RECIPE> recipeType, Component component, IDrawable icon, int xOffset, int yOffset, int width, int height) {
        this.recipeType = recipeType;
        this.component = component;
        this.guiHelper = helper;
        this.icon = icon;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.background = new NOOPDrawable(width, height);
    }

    protected <ELEMENT extends GuiElement> ELEMENT addElement(ELEMENT element) {
        this.guiElements.add(element);
        return element;
    }

    @NotNull
    public List<GuiElement> children() {
        return this.guiElements;
    }

    @NotNull
    public ScreenRectangle getRectangle() {
        return new ScreenRectangle(this.getGuiLeft(), this.getGuiTop(), this.getXSize(), this.getYSize());
    }

    public boolean handleInput(RECIPE recipe, double mouseX, double mouseY, InputConstants.Key input) {
        return switch (input.getType()) {
            default -> throw new MatchException(null, null);
            case InputConstants.Type.KEYSYM -> this.keyPressed(input.getValue(), -1, 0);
            case InputConstants.Type.SCANCODE -> this.keyPressed(-1, input.getValue(), 0);
            case InputConstants.Type.MOUSE -> this.mouseClicked(mouseX, mouseY, input.getValue());
        };
    }

    protected GuiSlot addSlot(SlotType type, int x, int y) {
        return this.addElement(new GuiSlot(type, this, x - 1, y - 1));
    }

    protected GuiProgress addSimpleProgress(ProgressType type, int x, int y) {
        return this.addElement(new GuiProgress(this.getSimpleProgressTimer(), type, (IGuiWrapper)this, x, y));
    }

    protected GuiProgress addConstantProgress(ProgressType type, int x, int y) {
        return this.addElement(new GuiProgress(RecipeViewerUtils.CONSTANT_PROGRESS, type, (IGuiWrapper)this, x, y));
    }

    @Override
    public int getGuiLeft() {
        return this.xOffset;
    }

    @Override
    public int getGuiTop() {
        return this.yOffset;
    }

    @Override
    public int getXSize() {
        return this.background.getWidth();
    }

    @Override
    public int getYSize() {
        return this.background.getHeight();
    }

    public RecipeType<RECIPE> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return this.component;
    }

    public void draw(RECIPE recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)this.getGuiLeft(), (float)this.getGuiTop(), 0.0f);
        this.renderElements(recipe, recipeSlotsView, guiGraphics, (int)mouseX, (int)mouseY);
        pose.popPose();
    }

    protected void renderElements(RECIPE recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, int x, int y) {
        PoseStack pose = guiGraphics.pose();
        for (GuiElement guiElement : this.guiElements) {
            guiElement.renderShifted(guiGraphics, x, y, 0.0f);
        }
        for (GuiElement e : this.guiElements) {
            e.onDrawBackground(guiGraphics, x, y, 0.0f);
        }
        int zOffset = 200;
        for (GuiElement element : this.guiElements) {
            pose.pushPose();
            element.onRenderForeground(guiGraphics, x, y, zOffset, zOffset);
            pose.popPose();
        }
    }

    @Override
    public Font getFont() {
        return Minecraft.getInstance().font;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public abstract ResourceLocation getRegistryName(RECIPE var1);

    protected IProgressInfoHandler getSimpleProgressTimer() {
        if (this.timer == null) {
            this.timer = this.guiHelper.createTickTimer(20, 20, false);
        }
        return () -> (double)this.timer.getValue() / 20.0;
    }

    protected GuiBar.IBarInfoHandler getBarProgressTimer() {
        if (this.timer == null) {
            this.timer = this.guiHelper.createTickTimer(20, 20, false);
        }
        return new GuiBar.IBarInfoHandler(){

            @Override
            public Component getTooltip() {
                return MekanismLang.PROGRESS.translate(TextUtils.getPercent(this.getLevel()));
            }

            @Override
            public double getLevel() {
                return (double)BaseRecipeCategory.this.timer.getValue() / 20.0;
            }
        };
    }

    private IDrawable getOverlay(GuiGauge<?> gauge) {
        GaugeOverlay overlay;
        IDrawable drawable;
        if (this.overlayLookup == null) {
            this.overlayLookup = new EnumMap<GaugeOverlay, IDrawable>(GaugeOverlay.class);
        }
        if ((drawable = this.overlayLookup.get((Object)(overlay = gauge.getGaugeOverlay()))) == null) {
            drawable = this.createDrawable(this.guiHelper, overlay);
            this.overlayLookup.put(overlay, drawable);
        }
        return drawable;
    }

    private IDrawable createDrawable(IGuiHelper helper, GaugeOverlay gaugeOverlay) {
        return helper.drawableBuilder(gaugeOverlay.getBarOverlay(), 0, 0, gaugeOverlay.getWidth(), gaugeOverlay.getHeight()).setTextureSize(gaugeOverlay.getWidth(), gaugeOverlay.getHeight()).build();
    }

    protected <STACK> STACK getDisplayedStack(IRecipeSlotsView recipeSlotsView, String slotName, IIngredientType<STACK> type, STACK empty) {
        Optional slotByName = recipeSlotsView.findSlotByName(slotName);
        if (slotByName.isPresent()) {
            return ((IRecipeSlotView)slotByName.get()).getDisplayedIngredient(type).orElse(empty);
        }
        return empty;
    }

    protected IRecipeSlotBuilder initItem(IRecipeLayoutBuilder builder, RecipeIngredientRole role, GuiSlot slot, List<ItemStack> stacks) {
        return this.initItem(builder, role, slot.getX(), slot.getY(), stacks);
    }

    protected IRecipeSlotBuilder initItem(IRecipeLayoutBuilder builder, RecipeIngredientRole role, int x, int y, List<ItemStack> stacks) {
        return (IRecipeSlotBuilder)builder.addSlot(role, x + 1, y + 1).addItemStacks(stacks);
    }

    protected IRecipeSlotBuilder initFluid(IRecipeLayoutBuilder builder, RecipeIngredientRole role, GuiGauge<?> gauge, List<FluidStack> stacks) {
        int width = gauge.getWidth() - 2;
        int height = gauge.getHeight() - 2;
        int max = stacks.stream().mapToInt(FluidStack::getAmount).filter(stackSize -> stackSize > 0).max().orElse(1000);
        return this.init(builder, (IIngredientType)NeoForgeTypes.FLUID_STACK, role, gauge, (List)stacks).setFluidRenderer((long)max, false, width, height);
    }

    protected <STACK extends ChemicalStack<?>> IRecipeSlotBuilder initChemical(IRecipeLayoutBuilder builder, IIngredientType<STACK> type, RecipeIngredientRole role, GuiElement element, List<STACK> stacks) {
        int width = element.getWidth() - 2;
        int height = element.getHeight() - 2;
        long max = stacks.stream().mapToLong(ChemicalStack::getAmount).filter(stackSize -> stackSize > 0L).max().orElse(1000L);
        return this.init(builder, type, role, element, stacks).setCustomRenderer(type, new ChemicalStackRenderer(max, width, height));
    }

    private <STACK> IRecipeSlotBuilder init(IRecipeLayoutBuilder builder, IIngredientType<STACK> type, RecipeIngredientRole role, GuiElement element, List<STACK> stacks) {
        int x = element.getX() + 1;
        int y = element.getY() + 1;
        IRecipeSlotBuilder slotBuilder = (IRecipeSlotBuilder)builder.addSlot(role, x, y).addIngredients(type, stacks);
        if (element instanceof GuiGauge) {
            GuiGauge gauge = (GuiGauge)element;
            slotBuilder.setOverlay(this.getOverlay(gauge), 0, 0);
        }
        return slotBuilder;
    }
}

