/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.gear.ModuleData;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.ChemicalInfuserRecipe;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.FluidSlurryToSlurryRecipe;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.ItemStackToInfuseTypeRecipe;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.ItemStackToPigmentRecipe;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.PaintingRecipe;
import mekanism.api.recipes.PigmentMixingRecipe;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.robit.GuiRobitRepair;
import mekanism.client.recipe_viewer.jei.CatalystRegistryHelper;
import mekanism.client.recipe_viewer.jei.ChemicalStackHelper;
import mekanism.client.recipe_viewer.jei.ChemicalStackRenderer;
import mekanism.client.recipe_viewer.jei.FormulaicRecipeTransferInfo;
import mekanism.client.recipe_viewer.jei.JeiGhostIngredientHandler;
import mekanism.client.recipe_viewer.jei.JeiGuiElementHandler;
import mekanism.client.recipe_viewer.jei.JeiQIOCraftingTransferHandler;
import mekanism.client.recipe_viewer.jei.machine.BoilerRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ChemicalCrystallizerRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ChemicalDissolutionRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ChemicalInfuserRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.CombinerRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ElectrolysisRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.FluidSlurryToSlurryRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.FluidToFluidRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.GasToGasRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ItemStackGasToItemStackRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ItemStackToEnergyRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ItemStackToFluidOptionalItemRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ItemStackToGasRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ItemStackToInfuseTypeRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ItemStackToItemStackRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.ItemStackToPigmentRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.MetallurgicInfuserRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.NucleosynthesizingRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.PaintingRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.PigmentMixerRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.PressurizedReactionRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.RotaryCondensentratorRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.SPSRecipeCategory;
import mekanism.client.recipe_viewer.jei.machine.SawmillRecipeCategory;
import mekanism.client.recipe_viewer.recipe.BoilerRecipeViewerRecipe;
import mekanism.client.recipe_viewer.recipe.SPSRecipeViewerRecipe;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.Mekanism;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.inventory.container.entity.robit.CraftingRobitContainer;
import mekanism.common.inventory.container.item.PortableQIODashboardContainer;
import mekanism.common.inventory.container.tile.QIODashboardContainer;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.registries.MekanismItems;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.RegistryUtils;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class MekanismJEI
implements IModPlugin {
    public static final IIngredientType<GasStack> TYPE_GAS = () -> GasStack.class;
    public static final IIngredientType<InfusionStack> TYPE_INFUSION = () -> InfusionStack.class;
    public static final IIngredientType<PigmentStack> TYPE_PIGMENT = () -> PigmentStack.class;
    public static final IIngredientType<SlurryStack> TYPE_SLURRY = () -> SlurryStack.class;
    public static final ChemicalStackHelper.GasStackHelper GAS_STACK_HELPER = new ChemicalStackHelper.GasStackHelper();
    public static final ChemicalStackHelper.InfusionStackHelper INFUSION_STACK_HELPER = new ChemicalStackHelper.InfusionStackHelper();
    public static final ChemicalStackHelper.PigmentStackHelper PIGMENT_STACK_HELPER = new ChemicalStackHelper.PigmentStackHelper();
    public static final ChemicalStackHelper.SlurryStackHelper SLURRY_STACK_HELPER = new ChemicalStackHelper.SlurryStackHelper();
    private static final Map<IRecipeViewerRecipeType<?>, RecipeType<?>> recipeTypeInstanceCache = new HashMap();
    private static final IIngredientSubtypeInterpreter<ItemStack> MEKANISM_NBT_INTERPRETER = (stack, context) -> {
        if (context == UidContext.Ingredient) {
            String representation = MekanismJEI.getChemicalComponent(stack, ContainerType.GAS, Capabilities.GAS.item());
            representation = MekanismJEI.addInterpretation(representation, MekanismJEI.getChemicalComponent(stack, ContainerType.INFUSION, Capabilities.INFUSION.item()));
            representation = MekanismJEI.addInterpretation(representation, MekanismJEI.getChemicalComponent(stack, ContainerType.PIGMENT, Capabilities.PIGMENT.item()));
            representation = MekanismJEI.addInterpretation(representation, MekanismJEI.getChemicalComponent(stack, ContainerType.SLURRY, Capabilities.SLURRY.item()));
            representation = MekanismJEI.addInterpretation(representation, MekanismJEI.getFluidComponent(stack));
            representation = MekanismJEI.addInterpretation(representation, MekanismJEI.getEnergyComponent(stack));
            return representation;
        }
        return "";
    };

    public static boolean shouldLoad() {
        return !Mekanism.hooks.EmiLoaded;
    }

    public static RecipeType<?> genericRecipeType(IRecipeViewerRecipeType<?> recipeType) {
        return recipeTypeInstanceCache.computeIfAbsent(recipeType, r -> {
            if (r.requiresHolder()) {
                return new RecipeType(r.id(), RecipeHolder.class);
            }
            return new RecipeType(r.id(), r.recipeClass());
        });
    }

    public static <TYPE> RecipeType<TYPE> recipeType(IRecipeViewerRecipeType<TYPE> recipeType) {
        if (recipeType.requiresHolder()) {
            throw new IllegalStateException("Basic recipe type requested for a recipe that uses holders");
        }
        return MekanismJEI.genericRecipeType(recipeType);
    }

    public static <TYPE extends Recipe<?>> RecipeType<RecipeHolder<TYPE>> holderRecipeType(IRecipeViewerRecipeType<TYPE> recipeType) {
        if (!recipeType.requiresHolder()) {
            throw new IllegalStateException("Holder recipe type requested for a recipe that doesn't use holders");
        }
        return MekanismJEI.genericRecipeType(recipeType);
    }

    public static RecipeType<?>[] recipeType(IRecipeViewerRecipeType<?> ... recipeTypes) {
        return (RecipeType[])Arrays.stream(recipeTypes).map(MekanismJEI::genericRecipeType).toArray(RecipeType[]::new);
    }

    private static String addInterpretation(String nbtRepresentation, String component) {
        return nbtRepresentation.isEmpty() ? component : nbtRepresentation + ":" + component;
    }

    private static String getChemicalComponent(ItemStack stack, ContainerType<?, ?, ? extends IChemicalHandler<?, ?>> containerType, ItemCapability<? extends IChemicalHandler<?, ?>, Void> capability) {
        IChemicalHandler handler = containerType.createHandlerIfData(stack);
        if (handler == null) {
            handler = (IChemicalHandler)stack.getCapability(capability);
        }
        if (handler != null) {
            String component = "";
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                Object chemicalStack = handler.getChemicalInTank(tank);
                if (!((ChemicalStack)chemicalStack).isEmpty()) {
                    component = MekanismJEI.addInterpretation(component, ((ChemicalStack)chemicalStack).getTypeRegistryName().toString());
                    continue;
                }
                if (tanks <= 1) continue;
                component = MekanismJEI.addInterpretation(component, "empty");
            }
            return component;
        }
        return "";
    }

    private static String getFluidComponent(ItemStack stack) {
        IFluidHandler handler = ContainerType.FLUID.createHandlerIfData(stack);
        if (handler == null) {
            handler = (IFluidHandler)Capabilities.FLUID.getCapability(stack);
        }
        if (handler != null) {
            String component = "";
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                FluidStack fluidStack = handler.getFluidInTank(tank);
                if (!fluidStack.isEmpty()) {
                    component = MekanismJEI.addInterpretation(component, RegistryUtils.getName(fluidStack.getFluid()).toString());
                    continue;
                }
                if (tanks <= 1) continue;
                component = MekanismJEI.addInterpretation(component, "empty");
            }
            return component;
        }
        return "";
    }

    private static String getEnergyComponent(ItemStack stack) {
        IStrictEnergyHandler energyHandlerItem = ContainerType.ENERGY.createHandlerIfData(stack);
        if (energyHandlerItem == null) {
            energyHandlerItem = (IStrictEnergyHandler)Capabilities.STRICT_ENERGY.getCapability(stack);
        }
        if (energyHandlerItem != null) {
            String component = "";
            int containers = energyHandlerItem.getEnergyContainerCount();
            for (int container = 0; container < containers; ++container) {
                long neededEnergy = energyHandlerItem.getNeededEnergy(container);
                if (neededEnergy == 0L) {
                    component = MekanismJEI.addInterpretation(component, "filled");
                    continue;
                }
                if (containers <= 1) continue;
                component = MekanismJEI.addInterpretation(component, "empty");
            }
            return component;
        }
        return "";
    }

    public static IIngredientType<? extends ChemicalStack<?>> getIngredientType(ChemicalType chemicalType) {
        return switch (chemicalType) {
            default -> throw new MatchException(null, null);
            case ChemicalType.GAS -> TYPE_GAS;
            case ChemicalType.INFUSION -> TYPE_INFUSION;
            case ChemicalType.PIGMENT -> TYPE_PIGMENT;
            case ChemicalType.SLURRY -> TYPE_SLURRY;
        };
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return Mekanism.rl("jei_plugin");
    }

    public static void registerItemSubtypes(ISubtypeRegistration registry, Collection<? extends Holder<? extends ItemLike>> itemProviders) {
        for (Holder<? extends ItemLike> holder : itemProviders) {
            ItemStack stack = new ItemStack((ItemLike)holder.value());
            if (!Capabilities.STRICT_ENERGY.hasCapability(stack) && !Capabilities.GAS.hasCapability(stack) && !Capabilities.INFUSION.hasCapability(stack) && !Capabilities.PIGMENT.hasCapability(stack) && !Capabilities.SLURRY.hasCapability(stack) && !Capabilities.FLUID.hasCapability(stack)) continue;
            registry.registerSubtypeInterpreter(stack.getItem(), MEKANISM_NBT_INTERPRETER);
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        if (MekanismJEI.shouldLoad()) {
            MekanismJEI.registerItemSubtypes(registry, MekanismItems.ITEMS.getEntries());
            MekanismJEI.registerItemSubtypes(registry, MekanismBlocks.BLOCKS.getSecondaryEntries());
        }
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        this.registerIngredientType(registry, (Registry)MekanismAPI.GAS_REGISTRY, (IIngredientType)TYPE_GAS, GAS_STACK_HELPER);
        this.registerIngredientType(registry, (Registry)MekanismAPI.INFUSE_TYPE_REGISTRY, (IIngredientType)TYPE_INFUSION, INFUSION_STACK_HELPER);
        this.registerIngredientType(registry, (Registry)MekanismAPI.PIGMENT_REGISTRY, (IIngredientType)TYPE_PIGMENT, PIGMENT_STACK_HELPER);
        this.registerIngredientType(registry, (Registry)MekanismAPI.SLURRY_REGISTRY, (IIngredientType)TYPE_SLURRY, SLURRY_STACK_HELPER);
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void registerIngredientType(IModIngredientRegistration registration, Registry<CHEMICAL> registry, IIngredientType<STACK> ingredientType, ChemicalStackHelper<CHEMICAL, STACK> stackHelper) {
        List<ChemicalStack> types = registry.stream().filter(chemical -> !chemical.isEmptyType()).map(chemical -> ChemicalUtil.withAmount(chemical, 1000L)).toList();
        stackHelper.setColorHelper(registration.getColorHelper());
        registration.register(ingredientType, types, stackHelper, new ChemicalStackRenderer());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (!MekanismJEI.shouldLoad()) {
            return;
        }
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemicalCrystallizerRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ChemicalCrystallizerRecipe>)RecipeViewerRecipeType.CRYSTALLIZING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemicalDissolutionRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ChemicalDissolutionRecipe>)RecipeViewerRecipeType.DISSOLUTION)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemicalInfuserRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ChemicalInfuserRecipe>)RecipeViewerRecipeType.CHEMICAL_INFUSING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidSlurryToSlurryRecipeCategory(guiHelper, (IRecipeViewerRecipeType<FluidSlurryToSlurryRecipe>)RecipeViewerRecipeType.WASHING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ElectrolysisRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ElectrolysisRecipe>)RecipeViewerRecipeType.SEPARATING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MetallurgicInfuserRecipeCategory(guiHelper, (IRecipeViewerRecipeType<MetallurgicInfuserRecipe>)RecipeViewerRecipeType.METALLURGIC_INFUSING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PressurizedReactionRecipeCategory(guiHelper, (IRecipeViewerRecipeType<PressurizedReactionRecipe>)RecipeViewerRecipeType.REACTION)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToPigmentRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackToPigmentRecipe>)RecipeViewerRecipeType.PIGMENT_EXTRACTING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PigmentMixerRecipeCategory(guiHelper, (IRecipeViewerRecipeType<PigmentMixingRecipe>)RecipeViewerRecipeType.PIGMENT_MIXING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PaintingRecipeCategory(guiHelper, (IRecipeViewerRecipeType<PaintingRecipe>)RecipeViewerRecipeType.PAINTING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new RotaryCondensentratorRecipeCategory(guiHelper, true)});
        registry.addRecipeCategories(new IRecipeCategory[]{new RotaryCondensentratorRecipeCategory(guiHelper, false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToGasRecipeCategory(guiHelper, RecipeViewerRecipeType.OXIDIZING, false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToFluidOptionalItemRecipeCategory(guiHelper, RecipeViewerRecipeType.NUTRITIONAL_LIQUIFICATION, false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GasToGasRecipeCategory(guiHelper, (IRecipeViewerRecipeType<GasToGasRecipe>)RecipeViewerRecipeType.ACTIVATING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GasToGasRecipeCategory(guiHelper, (IRecipeViewerRecipeType<GasToGasRecipe>)RecipeViewerRecipeType.CENTRIFUGING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CombinerRecipeCategory(guiHelper, (IRecipeViewerRecipeType<CombinerRecipe>)RecipeViewerRecipeType.COMBINING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackGasToItemStackRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackGasToItemStackRecipe>)RecipeViewerRecipeType.PURIFYING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackGasToItemStackRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackGasToItemStackRecipe>)RecipeViewerRecipeType.COMPRESSING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackGasToItemStackRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackGasToItemStackRecipe>)RecipeViewerRecipeType.INJECTING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new NucleosynthesizingRecipeCategory(guiHelper, (IRecipeViewerRecipeType<NucleosynthesizingRecipe>)RecipeViewerRecipeType.NUCLEOSYNTHESIZING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SPSRecipeCategory(guiHelper, (IRecipeViewerRecipeType<SPSRecipeViewerRecipe>)RecipeViewerRecipeType.SPS)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BoilerRecipeCategory(guiHelper, (IRecipeViewerRecipeType<BoilerRecipeViewerRecipe>)RecipeViewerRecipeType.BOILER)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SawmillRecipeCategory(guiHelper, (IRecipeViewerRecipeType<SawmillRecipe>)RecipeViewerRecipeType.SAWING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToItemStackRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackToItemStackRecipe>)RecipeViewerRecipeType.ENRICHING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToItemStackRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackToItemStackRecipe>)RecipeViewerRecipeType.CRUSHING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToItemStackRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackToItemStackRecipe>)RecipeViewerRecipeType.SMELTING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidToFluidRecipeCategory(guiHelper, (IRecipeViewerRecipeType<FluidToFluidRecipe>)RecipeViewerRecipeType.EVAPORATING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToEnergyRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackToEnergyRecipe>)RecipeViewerRecipeType.ENERGY_CONVERSION)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToGasRecipeCategory(guiHelper, RecipeViewerRecipeType.GAS_CONVERSION, true)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ItemStackToInfuseTypeRecipeCategory(guiHelper, (IRecipeViewerRecipeType<ItemStackToInfuseTypeRecipe>)RecipeViewerRecipeType.INFUSION_CONVERSION)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        if (!MekanismJEI.shouldLoad()) {
            return;
        }
        registry.addRecipeClickArea(GuiRobitRepair.class, 102, 48, 22, 15, new RecipeType[]{RecipeTypes.ANVIL});
        registry.addGenericGuiContainerHandler(GuiMekanism.class, (IGuiContainerHandler)new JeiGuiElementHandler(registry.getJeiHelpers().getIngredientManager()));
        registry.addGhostIngredientHandler(GuiMekanism.class, new JeiGhostIngredientHandler());
    }

    /*
     * Exception decompiling
     */
    public void registerRecipes(IRecipeRegistration registry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        if (!MekanismJEI.shouldLoad()) {
            return;
        }
        CatalystRegistryHelper.register(registry, RecipeViewerRecipeType.ENRICHING, RecipeViewerRecipeType.CRUSHING, RecipeViewerRecipeType.COMBINING, RecipeViewerRecipeType.PURIFYING, RecipeViewerRecipeType.COMPRESSING, RecipeViewerRecipeType.INJECTING, RecipeViewerRecipeType.SAWING, RecipeViewerRecipeType.METALLURGIC_INFUSING, RecipeViewerRecipeType.CRYSTALLIZING, RecipeViewerRecipeType.DISSOLUTION, RecipeViewerRecipeType.CHEMICAL_INFUSING, RecipeViewerRecipeType.OXIDIZING, RecipeViewerRecipeType.WASHING, RecipeViewerRecipeType.ACTIVATING, RecipeViewerRecipeType.SEPARATING, RecipeViewerRecipeType.SPS, RecipeViewerRecipeType.EVAPORATING, RecipeViewerRecipeType.BOILER, RecipeViewerRecipeType.REACTION, RecipeViewerRecipeType.CENTRIFUGING, RecipeViewerRecipeType.NUTRITIONAL_LIQUIFICATION, RecipeViewerRecipeType.PIGMENT_EXTRACTING, RecipeViewerRecipeType.PIGMENT_MIXING, RecipeViewerRecipeType.PAINTING, RecipeViewerRecipeType.NUCLEOSYNTHESIZING, RecipeViewerRecipeType.CONDENSENTRATING, RecipeViewerRecipeType.DECONDENSENTRATING, RecipeViewerRecipeType.SMELTING, RecipeViewerRecipeType.ENERGY_CONVERSION, RecipeViewerRecipeType.GAS_CONVERSION, RecipeViewerRecipeType.INFUSION_CONVERSION);
        CatalystRegistryHelper.register(registry, RecipeTypes.SMELTING, RecipeViewerRecipeType.VANILLA_SMELTING.workstations());
        CatalystRegistryHelper.register(registry, RecipeTypes.CRAFTING, RecipeViewerRecipeType.VANILLA_CRAFTING.workstations());
        CatalystRegistryHelper.register(registry, RecipeTypes.ANVIL, List.of(MekanismItems.ROBIT));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        if (!MekanismJEI.shouldLoad()) {
            return;
        }
        IRecipeTransferHandlerHelper transferHelper = registry.getTransferHelper();
        IStackHelper stackHelper = registry.getJeiHelpers().getStackHelper();
        registry.addRecipeTransferHandler(CraftingRobitContainer.class, (MenuType)MekanismContainerTypes.CRAFTING_ROBIT.get(), RecipeTypes.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler((IRecipeTransferInfo)new FormulaicRecipeTransferInfo());
        registry.addRecipeTransferHandler(new JeiQIOCraftingTransferHandler<QIODashboardContainer>(transferHelper, stackHelper, (MenuType)MekanismContainerTypes.QIO_DASHBOARD.get(), QIODashboardContainer.class), RecipeTypes.CRAFTING);
        registry.addRecipeTransferHandler(new JeiQIOCraftingTransferHandler<PortableQIODashboardContainer>(transferHelper, stackHelper, (MenuType)MekanismContainerTypes.PORTABLE_QIO_DASHBOARD.get(), PortableQIODashboardContainer.class), RecipeTypes.CRAFTING);
    }

    private static /* synthetic */ ItemStack lambda$registerRecipes$10(ModuleData data) {
        return data.getItemProvider().getItemStack();
    }
}

