/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.recipe;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.ingredients.chemical.IGasIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.emi.INamedRVRecipe;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.HeatUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import org.jetbrains.annotations.Nullable;

public record BoilerRecipeViewerRecipe(ResourceLocation id, @Nullable GasStackIngredient superHeatedCoolant, FluidStackIngredient water, GasStack steam, GasStack cooledCoolant, double temperature) implements INamedRVRecipe
{
    public static List<BoilerRecipeViewerRecipe> getBoilerRecipes() {
        int waterAmount = 1;
        double waterToSteamEfficiency = HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency();
        ArrayList<BoilerRecipeViewerRecipe> recipes = new ArrayList<BoilerRecipeViewerRecipe>();
        double temperature = (double)waterAmount * waterToSteamEfficiency / (50.0 * MekanismConfig.general.boilerWaterConductivity.get()) + HeatUtils.BASE_BOIL_TEMP;
        recipes.add(new BoilerRecipeViewerRecipe(RecipeViewerUtils.synthetic(Mekanism.rl("water"), "boiler"), null, (FluidStackIngredient)IngredientCreatorAccess.fluid().from(FluidTags.WATER, waterAmount), MekanismGases.STEAM.getStack(waterAmount), GasStack.EMPTY, temperature));
        for (Gas gas : MekanismAPI.GAS_REGISTRY) {
            GasAttributes.HeatedCoolant heatedCoolant = gas.get(GasAttributes.HeatedCoolant.class);
            if (heatedCoolant == null) continue;
            Gas cooledCoolant = heatedCoolant.getCooledGas();
            long coolantAmount = Math.round((double)waterAmount * waterToSteamEfficiency / heatedCoolant.getThermalEnthalpy());
            recipes.add(new BoilerRecipeViewerRecipe(RecipeViewerUtils.synthetic(gas.getRegistryName(), "boiler", "mekanism"), IngredientCreatorAccess.gasStack().from((IGasIngredient)((Object)gas), coolantAmount), (FluidStackIngredient)IngredientCreatorAccess.fluid().from(FluidTags.WATER, waterAmount), MekanismGases.STEAM.getStack(waterAmount), cooledCoolant.getStack(coolantAmount), HeatUtils.BASE_BOIL_TEMP));
        }
        return recipes;
    }
}

