/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.data;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.data.RenderData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.neoforged.neoforge.fluids.FluidStack;

@NothingNullByDefault
public class FluidRenderData
extends RenderData {
    public final FluidStack fluidType;

    public FluidRenderData(BlockPos renderLocation, int width, int height, int length, FluidStack fluidType) {
        super(renderLocation, width, height, length);
        this.fluidType = fluidType;
    }

    @Override
    public boolean isGaseous() {
        return MekanismUtils.lighterThanAirGas(this.fluidType);
    }

    public int getColorARGB() {
        return MekanismRenderer.getColorARGB(this.fluidType);
    }

    @Override
    public int getColorARGB(float scale) {
        return MekanismRenderer.getColorARGB(this.fluidType, scale);
    }

    @Override
    public int calculateGlowLight(int light) {
        return MekanismRenderer.calculateGlowLight(light, this.fluidType);
    }

    @Override
    public TextureAtlasSprite getTexture() {
        return MekanismRenderer.getFluidTexture(this.fluidType, MekanismRenderer.FluidTextureType.STILL);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), FluidStack.hashFluidAndComponents((FluidStack)this.fluidType));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object data) {
        if (!super.equals(data)) return false;
        if (!(data instanceof FluidRenderData)) return false;
        FluidRenderData other = (FluidRenderData)data;
        if (!FluidStack.isSameFluidSameComponents((FluidStack)this.fluidType, (FluidStack)other.fluidType)) return false;
        return true;
    }
}

