/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mekanism.api.MekanismAPI;
import mekanism.api.MekanismIMC;
import mekanism.api.providers.IItemProvider;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.CommonPlayerTracker;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.MekanismLang;
import mekanism.common.ReloadListener;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.base.IModModule;
import mekanism.common.base.KeySync;
import mekanism.common.base.MekFakePlayer;
import mekanism.common.base.MekanismPermissions;
import mekanism.common.base.PlayerState;
import mekanism.common.base.TagCache;
import mekanism.common.base.holiday.HolidayManager;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.command.CommandMek;
import mekanism.common.command.builders.BuildCommand;
import mekanism.common.command.builders.Builders;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.content.boiler.BoilerValidator;
import mekanism.common.content.evaporation.EvaporationMultiblockData;
import mekanism.common.content.evaporation.EvaporationValidator;
import mekanism.common.content.gear.MekaSuitDispenseBehavior;
import mekanism.common.content.gear.ModuleDispenseBehavior;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.content.matrix.MatrixMultiblockData;
import mekanism.common.content.matrix.MatrixValidator;
import mekanism.common.content.network.BoxedChemicalNetwork;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.content.qio.QIOGlobalItemLookup;
import mekanism.common.content.sps.SPSCache;
import mekanism.common.content.sps.SPSMultiblockData;
import mekanism.common.content.sps.SPSValidator;
import mekanism.common.content.tank.TankCache;
import mekanism.common.content.tank.TankMultiblockData;
import mekanism.common.content.tank.TankValidator;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.integration.MekanismHooks;
import mekanism.common.item.block.machine.ItemBlockFluidTank;
import mekanism.common.item.interfaces.IHasConditionalAttributes;
import mekanism.common.item.loot.MekanismLootFunctions;
import mekanism.common.item.predicate.MekanismItemPredicates;
import mekanism.common.lib.MekAnnotationScanner;
import mekanism.common.lib.Version;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.inventory.personalstorage.PersonalStorageManager;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.lib.transmitter.TransmitterNetworkRegistry;
import mekanism.common.network.PacketHandler;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.transmitter.PacketChemicalNetworkContents;
import mekanism.common.network.to_client.transmitter.PacketFluidNetworkContents;
import mekanism.common.network.to_client.transmitter.PacketNetworkScale;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.condition.MekanismRecipeConditions;
import mekanism.common.registries.MekanismArmorMaterials;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.registries.MekanismCreativeTabs;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.registries.MekanismDataMapTypes;
import mekanism.common.registries.MekanismDataSerializers;
import mekanism.common.registries.MekanismEntityTypes;
import mekanism.common.registries.MekanismFeatures;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.registries.MekanismGameEvents;
import mekanism.common.registries.MekanismGasIngredientTypes;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismHeightProviderTypes;
import mekanism.common.registries.MekanismInfuseTypes;
import mekanism.common.registries.MekanismInfusionIngredientTypes;
import mekanism.common.registries.MekanismIntProviderTypes;
import mekanism.common.registries.MekanismItems;
import mekanism.common.registries.MekanismModules;
import mekanism.common.registries.MekanismParticleTypes;
import mekanism.common.registries.MekanismPigmentIngredientTypes;
import mekanism.common.registries.MekanismPigments;
import mekanism.common.registries.MekanismPlacementModifiers;
import mekanism.common.registries.MekanismRecipeSerializersInternal;
import mekanism.common.registries.MekanismRobitSkins;
import mekanism.common.registries.MekanismSlurries;
import mekanism.common.registries.MekanismSlurryIngredientTypes;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.util.RegistryUtils;
import mekanism.common.world.GenHandler;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DispenserBlock;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.slf4j.Logger;

@Mod(value="mekanism")
public class Mekanism {
    public static final String MODID = "mekanism";
    public static final String MOD_NAME = "Mekanism";
    public static final String LOG_TAG = "[Mekanism]";
    public static final PlayerState playerState = new PlayerState();
    private final PacketHandler packetHandler;
    public static final Logger logger = LogUtils.getLogger();
    public static Mekanism instance;
    public static final MekanismHooks hooks;
    public final Version versionNumber;
    public static final MultiblockManager<TankMultiblockData> tankManager;
    public static final MultiblockManager<MatrixMultiblockData> matrixManager;
    public static final MultiblockManager<BoilerMultiblockData> boilerManager;
    public static final MultiblockManager<EvaporationMultiblockData> evaporationManager;
    public static final MultiblockManager<SPSMultiblockData> spsManager;
    public static final List<IModModule> modulesLoaded;
    public static final CommonWorldTickHandler worldTickHandler;
    public static final GameProfile gameProfile;
    public static final KeySync keyMap;
    public static final Set<GlobalPos> activeVibrators;
    private ReloadListener recipeCacheManager;

    public Mekanism(ModContainer modContainer, IEventBus modEventBus) {
        instance = this;
        this.versionNumber = new Version(modContainer);
        MekanismConfig.registerConfigs(modContainer);
        NeoForgeMod.enableMilkFluid();
        NeoForge.EVENT_BUS.addListener(this::onEnergyTransferred);
        NeoForge.EVENT_BUS.addListener(this::onChemicalTransferred);
        NeoForge.EVENT_BUS.addListener(this::onLiquidTransferred);
        NeoForge.EVENT_BUS.addListener(this::onModifyItemAttributes);
        NeoForge.EVENT_BUS.addListener(this::onWorldLoad);
        NeoForge.EVENT_BUS.addListener(this::onWorldUnload);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        NeoForge.EVENT_BUS.addListener(this::serverStopped);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::addReloadListenersLowest);
        NeoForge.EVENT_BUS.addListener(this::onTagsReload);
        NeoForge.EVENT_BUS.addListener(MekanismPermissions::registerPermissionNodes);
        modEventBus.addListener(Capabilities::registerCapabilities);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerChunkTicketControllers);
        modEventBus.addListener(MekanismConfig::onConfigLoad);
        modEventBus.addListener(this::imcQueue);
        modEventBus.addListener(this::imcHandle);
        MekanismItems.ITEMS.register(modEventBus);
        MekanismBlocks.BLOCKS.register(modEventBus);
        MekanismFluids.FLUIDS.register(modEventBus);
        MekanismArmorMaterials.ARMOR_MATERIALS.register(modEventBus);
        MekanismAttachmentTypes.ATTACHMENT_TYPES.register(modEventBus);
        MekanismContainerTypes.CONTAINER_TYPES.register(modEventBus);
        MekanismCreativeTabs.CREATIVE_TABS.register(modEventBus);
        MekanismCriteriaTriggers.CRITERIA_TRIGGERS.register(modEventBus);
        MekanismDataComponents.DATA_COMPONENTS.register(modEventBus);
        MekanismEntityTypes.ENTITY_TYPES.register(modEventBus);
        MekanismTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        MekanismGameEvents.GAME_EVENTS.register(modEventBus);
        MekanismSounds.SOUND_EVENTS.register(modEventBus);
        MekanismParticleTypes.PARTICLE_TYPES.register(modEventBus);
        MekanismHeightProviderTypes.HEIGHT_PROVIDER_TYPES.register(modEventBus);
        MekanismIntProviderTypes.INT_PROVIDER_TYPES.register(modEventBus);
        MekanismPlacementModifiers.PLACEMENT_MODIFIERS.register(modEventBus);
        MekanismFeatures.FEATURES.register(modEventBus);
        MekanismRecipeType.RECIPE_TYPES.register(modEventBus);
        MekanismRecipeSerializersInternal.RECIPE_SERIALIZERS.register(modEventBus);
        MekanismDataSerializers.DATA_SERIALIZERS.register(modEventBus);
        MekanismLootFunctions.REGISTER.register(modEventBus);
        MekanismGases.GASES.register(modEventBus);
        MekanismInfuseTypes.INFUSE_TYPES.register(modEventBus);
        MekanismPigments.PIGMENTS.register(modEventBus);
        MekanismSlurries.SLURRIES.register(modEventBus);
        MekanismGasIngredientTypes.INGREDIENT_TYPES.register(modEventBus);
        MekanismInfusionIngredientTypes.INGREDIENT_TYPES.register(modEventBus);
        MekanismPigmentIngredientTypes.INGREDIENT_TYPES.register(modEventBus);
        MekanismSlurryIngredientTypes.INGREDIENT_TYPES.register(modEventBus);
        MekanismRobitSkins.createAndRegisterDatapack(modEventBus);
        MekanismModules.MODULES.register(modEventBus);
        MekanismRecipeConditions.CONDITION_CODECS.register(modEventBus);
        MekanismItemPredicates.PREDICATES.register(modEventBus);
        MekanismDataMapTypes.REGISTER.register(modEventBus);
        modEventBus.addListener(this::registerEventListener);
        modEventBus.addListener(this::registerRegistries);
        this.packetHandler = new PacketHandler(modEventBus, this.versionNumber);
        hooks.hookConstructor(modEventBus);
    }

    public static synchronized void addModule(IModModule modModule) {
        modulesLoaded.add(modModule);
    }

    public static PacketHandler packetHandler() {
        return Mekanism.instance.packetHandler;
    }

    private void registerRegistries(NewRegistryEvent event) {
        event.register(MekanismAPI.GAS_REGISTRY);
        event.register(MekanismAPI.INFUSE_TYPE_REGISTRY);
        event.register(MekanismAPI.PIGMENT_REGISTRY);
        event.register(MekanismAPI.SLURRY_REGISTRY);
        event.register(MekanismAPI.GAS_INGREDIENT_TYPES);
        event.register(MekanismAPI.INFUSION_INGREDIENT_TYPES);
        event.register(MekanismAPI.PIGMENT_INGREDIENT_TYPES);
        event.register(MekanismAPI.SLURRY_INGREDIENT_TYPES);
        event.register(MekanismAPI.MODULE_REGISTRY);
        event.register(MekanismAPI.ROBIT_SKIN_SERIALIZER_REGISTRY);
    }

    private void registerEventListener(RegisterEvent event) {
        event.register(MekanismAPI.GAS_REGISTRY_NAME, MekanismAPI.EMPTY_CHEMICAL_NAME, () -> MekanismAPI.EMPTY_GAS);
        event.register(MekanismAPI.INFUSE_TYPE_REGISTRY_NAME, MekanismAPI.EMPTY_CHEMICAL_NAME, () -> MekanismAPI.EMPTY_INFUSE_TYPE);
        event.register(MekanismAPI.PIGMENT_REGISTRY_NAME, MekanismAPI.EMPTY_CHEMICAL_NAME, () -> MekanismAPI.EMPTY_PIGMENT);
        event.register(MekanismAPI.SLURRY_REGISTRY_NAME, MekanismAPI.EMPTY_CHEMICAL_NAME, () -> MekanismAPI.EMPTY_SLURRY);
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void setRecipeCacheManager(ReloadListener manager) {
        if (this.recipeCacheManager == null) {
            this.recipeCacheManager = manager;
        } else {
            logger.warn("Recipe cache manager has already been set.");
        }
    }

    public ReloadListener getRecipeCacheManager() {
        return this.recipeCacheManager;
    }

    private void onTagsReload(TagsUpdatedEvent event) {
        TagCache.resetTagCaches();
    }

    private void addReloadListenersLowest(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this.getRecipeCacheManager());
    }

    private void registerCommands(RegisterCommandsEvent event) {
        BuildCommand.register("boiler", MekanismLang.BOILER, new Builders.BoilerBuilder());
        BuildCommand.register("matrix", MekanismLang.MATRIX, new Builders.MatrixBuilder());
        BuildCommand.register("tank", MekanismLang.DYNAMIC_TANK, new Builders.TankBuilder());
        BuildCommand.register("evaporation", MekanismLang.EVAPORATION_PLANT, new Builders.EvaporationBuilder());
        BuildCommand.register("sps", MekanismLang.SPS, new Builders.SPSBuilder());
        event.getDispatcher().register(CommandMek.register());
    }

    private void serverStopped(ServerStoppedEvent event) {
        playerState.clear(false);
        activeVibrators.clear();
        worldTickHandler.resetChunkData();
        FrequencyType.clear();
        BoilerMultiblockData.hotMap.clear();
        QIOGlobalItemLookup.INSTANCE.reset();
        RadiationManager.get().reset();
        MultiblockManager.reset();
        FrequencyManager.reset();
        TransporterManager.reset();
        PathfinderCache.reset();
        TransmitterNetworkRegistry.reset();
        GenHandler.reset();
        PersonalStorageManager.reset();
    }

    private void imcQueue(InterModEnqueueEvent event) {
        hooks.sendIMCMessages(event);
        MekanismIMC.addModuleContainer(MekanismItems.MEKA_TOOL, "add_meka_tool_modules");
        MekanismIMC.addModuleContainer(MekanismItems.MEKASUIT_HELMET, "add_meka_suit_helmet_modules");
        MekanismIMC.addModuleContainer(MekanismItems.MEKASUIT_BODYARMOR, "add_meka_suit_bodyarmor_modules");
        MekanismIMC.addModuleContainer(MekanismItems.MEKASUIT_PANTS, "add_meka_suit_pants_modules");
        MekanismIMC.addModuleContainer(MekanismItems.MEKASUIT_BOOTS, "add_meka_suit_boots_modules");
        MekanismIMC.addModulesToAll(MekanismModules.ENERGY_UNIT);
        MekanismIMC.addMekaSuitModules(MekanismModules.COLOR_MODULATION_UNIT, MekanismModules.LASER_DISSIPATION_UNIT, MekanismModules.RADIATION_SHIELDING_UNIT);
        MekanismIMC.addMekaToolModules(MekanismModules.ATTACK_AMPLIFICATION_UNIT, MekanismModules.SILK_TOUCH_UNIT, MekanismModules.FORTUNE_UNIT, MekanismModules.BLASTING_UNIT, MekanismModules.VEIN_MINING_UNIT, MekanismModules.FARMING_UNIT, MekanismModules.SHEARING_UNIT, MekanismModules.TELEPORTATION_UNIT, MekanismModules.EXCAVATION_ESCALATION_UNIT);
        MekanismIMC.addMekaSuitHelmetModules(MekanismModules.ELECTROLYTIC_BREATHING_UNIT, MekanismModules.INHALATION_PURIFICATION_UNIT, MekanismModules.VISION_ENHANCEMENT_UNIT, MekanismModules.NUTRITIONAL_INJECTION_UNIT);
        MekanismIMC.addMekaSuitBodyarmorModules(MekanismModules.JETPACK_UNIT, MekanismModules.GRAVITATIONAL_MODULATING_UNIT, MekanismModules.CHARGE_DISTRIBUTION_UNIT, MekanismModules.DOSIMETER_UNIT, MekanismModules.GEIGER_UNIT, MekanismModules.ELYTRA_UNIT);
        MekanismIMC.addMekaSuitPantsModules(MekanismModules.LOCOMOTIVE_BOOSTING_UNIT, MekanismModules.GYROSCOPIC_STABILIZATION_UNIT, MekanismModules.HYDROSTATIC_REPULSOR_UNIT, MekanismModules.MOTORIZED_SERVO_UNIT);
        MekanismIMC.addMekaSuitBootsModules(MekanismModules.HYDRAULIC_PROPULSION_UNIT, MekanismModules.MAGNETIC_ATTRACTION_UNIT, MekanismModules.FROST_WALKER_UNIT, MekanismModules.SOUL_SURFER_UNIT);
    }

    private void imcHandle(InterModProcessEvent event) {
        ModuleHelper.get().processIMC(event);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        logger.info("Version {} initializing...", (Object)this.versionNumber);
        hooks.hookCommonSetup();
        this.setRecipeCacheManager(new ReloadListener());
        HolidayManager.init();
        event.enqueueWork(() -> {
            MekAnnotationScanner.collectScanData();
            MekanismFluids.FLUIDS.registerBucketDispenserBehavior();
            Mekanism.registerFluidTankBehaviors(MekanismBlocks.BASIC_FLUID_TANK, MekanismBlocks.ADVANCED_FLUID_TANK, MekanismBlocks.ELITE_FLUID_TANK, MekanismBlocks.ULTIMATE_FLUID_TANK, MekanismBlocks.CREATIVE_FLUID_TANK);
            Mekanism.registerDispenseBehavior((DispenseItemBehavior)new ModuleDispenseBehavior(), MekanismItems.MEKA_TOOL);
            Mekanism.registerDispenseBehavior((DispenseItemBehavior)new MekaSuitDispenseBehavior(), MekanismItems.MEKASUIT_HELMET, MekanismItems.MEKASUIT_BODYARMOR, MekanismItems.MEKASUIT_PANTS, MekanismItems.MEKASUIT_BOOTS);
        });
        NeoForge.EVENT_BUS.register((Object)new CommonPlayerTracker());
        NeoForge.EVENT_BUS.register((Object)new CommonPlayerTickHandler());
        NeoForge.EVENT_BUS.register((Object)worldTickHandler);
        NeoForge.EVENT_BUS.register((Object)RadiationManager.get());
        TransmitterNetworkRegistry.initiate();
        logger.info("Fake player readout: UUID = {}, name = {}", (Object)gameProfile.getId(), (Object)gameProfile.getName());
        logger.info("Mod loaded.");
    }

    private static void registerDispenseBehavior(DispenseItemBehavior behavior, IItemProvider ... itemProviders) {
        for (IItemProvider itemProvider : itemProviders) {
            DispenserBlock.registerBehavior((ItemLike)itemProvider.asItem(), (DispenseItemBehavior)behavior);
        }
    }

    private static void registerFluidTankBehaviors(IItemProvider ... itemProviders) {
        Mekanism.registerDispenseBehavior((DispenseItemBehavior)ItemBlockFluidTank.FluidTankItemDispenseBehavior.INSTANCE, new IItemProvider[0]);
        for (IItemProvider itemProvider : itemProviders) {
            Item item = itemProvider.asItem();
            CauldronInteraction.EMPTY.map().put(item, ItemBlockFluidTank.BasicCauldronInteraction.EMPTY);
            CauldronInteraction.WATER.map().put(item, ItemBlockFluidTank.BasicDrainCauldronInteraction.WATER);
            CauldronInteraction.LAVA.map().put(item, ItemBlockFluidTank.BasicDrainCauldronInteraction.LAVA);
        }
    }

    private void registerChunkTicketControllers(RegisterTicketControllersEvent event) {
        event.register(TileComponentChunkLoader.TICKET_CONTROLLER);
    }

    private void onEnergyTransferred(EnergyNetwork.EnergyTransferEvent event) {
        PacketUtils.sendToAllTracking(event.network, new PacketNetworkScale(event.network));
    }

    private void onChemicalTransferred(BoxedChemicalNetwork.ChemicalTransferEvent event) {
        UUID networkID = ((BoxedChemicalNetwork)event.network).getUUID();
        PacketUtils.log("Sending type '{}' update message for chemical network with id {}", event.transferType.getChemical().getRegistryName(), networkID);
        PacketUtils.sendToAllTracking(event.network, new PacketNetworkScale(event.network), new PacketChemicalNetworkContents(networkID, event.transferType));
    }

    private void onLiquidTransferred(FluidNetwork.FluidTransferEvent event) {
        UUID networkID = ((FluidNetwork)event.network).getUUID();
        PacketUtils.log("Sending type '{}' update message for fluid network with id {}", RegistryUtils.getName(event.fluidType.getFluid()), networkID);
        PacketUtils.sendToAllTracking(event.network, new PacketNetworkScale(event.network), new PacketFluidNetworkContents(networkID, event.fluidType));
    }

    private void onModifyItemAttributes(ItemAttributeModifierEvent event) {
        Item item = event.getItemStack().getItem();
        if (item instanceof IHasConditionalAttributes) {
            IHasConditionalAttributes item2 = (IHasConditionalAttributes)item;
            item2.adjustAttributes(event);
        }
    }

    private void onWorldLoad(LevelEvent.Load event) {
        playerState.init(event.getLevel());
    }

    private void onWorldUnload(LevelEvent.Unload event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            level = (ServerLevel)levelAccessor;
            MekFakePlayer.releaseInstance(level);
        }
        if ((levelAccessor = event.getLevel()) instanceof Level) {
            level = (Level)levelAccessor;
            if (MekanismConfig.general.validOredictionificatorFilters.hasInvalidationListeners()) {
                MekanismConfig.general.validOredictionificatorFilters.removeInvalidationListenersMatching(level, (listener, world) -> {
                    TileEntityOredictionificator.ODConfigValueInvalidationListener odListener;
                    return listener instanceof TileEntityOredictionificator.ODConfigValueInvalidationListener && (odListener = (TileEntityOredictionificator.ODConfigValueInvalidationListener)listener).isIn((Level)world);
                });
            }
        }
    }

    static {
        hooks = new MekanismHooks();
        tankManager = new MultiblockManager("dynamicTank", TankCache::new, TankValidator::new);
        matrixManager = new MultiblockManager("inductionMatrix", MultiblockCache::new, MatrixValidator::new);
        boilerManager = new MultiblockManager("thermoelectricBoiler", MultiblockCache::new, BoilerValidator::new);
        evaporationManager = new MultiblockManager("evaporation", MultiblockCache::new, EvaporationValidator::new);
        spsManager = new MultiblockManager("sps", SPSCache::new, SPSValidator::new);
        modulesLoaded = new ArrayList<IModModule>();
        worldTickHandler = new CommonWorldTickHandler();
        gameProfile = new GameProfile(UUID.nameUUIDFromBytes("mekanism.common".getBytes(StandardCharsets.UTF_8)), LOG_TAG);
        keyMap = new KeySync();
        activeVibrators = new ObjectOpenHashSet();
    }
}

