/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.inventory.slot.UpgradeInventorySlot;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;

@NothingNullByDefault
public record UpgradeAware(Map<Upgrade, Integer> upgrades, ItemStack inputSlot, ItemStack outputSlot) {
    public static final UpgradeAware EMPTY = new UpgradeAware(Collections.emptyMap(), ItemStack.EMPTY, ItemStack.EMPTY);
    private static final Set<Upgrade> SUPPORTS_ALL = EnumSet.allOf(Upgrade.class);
    public static final Codec<UpgradeAware> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(Upgrade.CODEC, (Codec)ExtraCodecs.POSITIVE_INT).fieldOf("upgrades").forGetter(UpgradeAware::upgrades), (App)ItemStack.OPTIONAL_CODEC.fieldOf("input").forGetter(UpgradeAware::inputSlot), (App)ItemStack.OPTIONAL_CODEC.fieldOf("output").forGetter(UpgradeAware::outputSlot)).apply((Applicative)instance, UpgradeAware::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpgradeAware> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(size -> new EnumMap(Upgrade.class), Upgrade.STREAM_CODEC, (StreamCodec)ByteBufCodecs.VAR_INT), UpgradeAware::upgrades, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, UpgradeAware::inputSlot, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, UpgradeAware::outputSlot, UpgradeAware::new);

    public UpgradeAware {
        upgrades = Collections.unmodifiableMap(upgrades);
        inputSlot = inputSlot.copy();
        outputSlot = outputSlot.copy();
    }

    public int getUpgradeCount(Upgrade upgrade) {
        return this.upgrades.getOrDefault(upgrade, 0);
    }

    public List<IInventorySlot> asInventorySlots() {
        return this.asInventorySlots(SUPPORTS_ALL);
    }

    public List<IInventorySlot> asInventorySlots(Set<Upgrade> supportedUpgrades) {
        UpgradeInventorySlot input = UpgradeInventorySlot.input(null, supportedUpgrades);
        UpgradeInventorySlot output = UpgradeInventorySlot.output(null);
        input.setStack(this.inputSlot);
        output.setStack(this.outputSlot);
        return List.of(input, output);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpgradeAware other = (UpgradeAware)o;
        return ItemStack.matches((ItemStack)this.inputSlot, (ItemStack)other.inputSlot) && ItemStack.matches((ItemStack)this.outputSlot, (ItemStack)other.outputSlot) && Objects.equals(this.upgrades, other.upgrades);
    }

    @Override
    public int hashCode() {
        int hash = this.upgrades.hashCode();
        hash = 31 * hash + ItemStack.hashItemAndComponents((ItemStack)this.inputSlot);
        return 31 * hash + ItemStack.hashItemAndComponents((ItemStack)this.outputSlot);
    }
}

